/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanBoolean;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanBoolean_template
extends Base_Template {
    private TitanBoolean single_value;
    private ArrayList<TitanBoolean_template> value_list;

    public TitanBoolean_template() {
    }

    public TitanBoolean_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanBoolean_template.check_single_selection(otherValue);
    }

    public TitanBoolean_template(boolean otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBoolean(otherValue);
    }

    public TitanBoolean_template(TitanBoolean otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound boolean value.");
        this.single_value = new TitanBoolean(otherValue);
    }

    public TitanBoolean_template(Optional<TitanBoolean> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanBoolean(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a boolean template from an unbound optional field.");
            }
        }
    }

    public TitanBoolean_template(TitanBoolean_template otherValue) {
        this.copy_template(otherValue);
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanBoolean_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanBoolean) {
            return this.operator_assign((TitanBoolean)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", otherValue));
    }

    @Override
    public TitanBoolean_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanBoolean_template) {
            return this.operator_assign((TitanBoolean_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", otherValue));
    }

    @Override
    public TitanBoolean_template operator_assign(Base_Template.template_sel otherValue) {
        TitanBoolean_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanBoolean_template operator_assign(boolean otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBoolean(otherValue);
        return this;
    }

    public TitanBoolean_template operator_assign(TitanBoolean otherValue) {
        otherValue.must_bound("Assignment of an unbound boolean value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanBoolean(otherValue);
        return this;
    }

    public TitanBoolean_template operator_assign(TitanBoolean_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanBoolean_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanBoolean(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanBoolean_template temp = new TitanBoolean_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported boolean template.");
            }
        }
        this.set_selection(otherValue);
    }

    public boolean and(TitanBoolean other_value) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("And operation of a non specific value template");
        }
        return this.single_value.and(other_value);
    }

    public boolean and(TitanBoolean_template other_template) {
        if (other_template.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("And operation of a non specific value template argument");
        }
        return this.and(other_template.single_value);
    }

    public boolean operator_equals(TitanBoolean otherValue) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Equals operation of a non specific value template");
        }
        return this.single_value.operator_equals(otherValue);
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanBoolean) {
            return this.match((TitanBoolean)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanBoolean) {
            this.log_match((TitanBoolean)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to boolean", match_value));
    }

    public boolean match(boolean otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(boolean otherValue, boolean legacy) {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported boolean template.");
    }

    public boolean match(TitanBoolean otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanBoolean otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        return this.match(otherValue.get_value(), legacy);
    }

    @Override
    public TitanBoolean valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing valueof or send operation on a non-specific boolean template.");
        }
        return this.single_value;
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        if (!Base_Template.template_sel.VALUE_LIST.equals((Object)templateType) && !Base_Template.template_sel.COMPLEMENTED_LIST.equals((Object)templateType)) {
            throw new TtcnError("Setting an invalid list type for a boolean template.");
        }
        this.clean_up();
        this.set_selection(templateType);
        this.value_list = new ArrayList(listLength);
        for (int i = 0; i < listLength; ++i) {
            this.value_list.add(new TitanBoolean_template());
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list boolean template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanBoolean_template list_item(int listIndex) {
        if (!Base_Template.template_sel.VALUE_LIST.equals((Object)this.template_selection) && !Base_Template.template_sel.COMPLEMENTED_LIST.equals((Object)this.template_selection)) {
            throw new TtcnError("Accessing a list element of a non-list boolean template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an boolean value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex > this.value_list.size()) {
            throw new TtcnError("Index overflow in an boolean value list template.");
        }
        return this.value_list.get(listIndex);
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                TTCN_Logger.log_event_str(this.single_value.get_value() != false ? "true" : "false");
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "boolean template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanBoolean_template temp = new TitanBoolean_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Boolean: {
                this.operator_assign(param.get_boolean());
                break;
            }
            default: {
                param.type_error("boolean template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = new Param_Types.Module_Param_Boolean(this.single_value.get_value());
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported boolean template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    public void log_match(TitanBoolean match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                text_buf.push_int(this.single_value.get_value() != false ? 1 : 0);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported boolean template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanBoolean();
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanBoolean_template temp = new TitanBoolean_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a boolean template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanBoolean_template.get_res_name(restriction), name == null ? "boolean" : name));
    }
}

