/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

import java.util.List;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.cfg.CfgParseTreePrinter;

public class IntervalDetector {
    protected Interval rootInterval = null;
    protected Interval actualInterval = null;
    private int maxLength;

    public void initRootInterval(int length) {
        this.rootInterval = this.actualInterval = new Interval(null, Interval.interval_type.NORMAL);
        this.actualInterval.setStartOffset(0);
        this.actualInterval.setStartLine(0);
        this.actualInterval.setEndOffset(length);
        this.maxLength = length;
    }

    protected int getMaxLength() {
        return this.maxLength;
    }

    protected void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public final void pushInterval(int offset, int line, Interval.interval_type type) {
        this.actualInterval = new Interval(this.actualInterval, type);
        if (this.rootInterval == null) {
            this.rootInterval = this.actualInterval;
        }
        this.actualInterval.setStartOffset(offset);
        this.actualInterval.setStartLine(line);
    }

    public final void pushInterval(Token aToken, Interval.interval_type aType) {
        this.pushInterval(aToken.getCharPositionInLine(), aToken.getLine(), aType);
    }

    public final void popInterval(int offset, int line) {
        if (this.actualInterval != null) {
            this.actualInterval.setEndOffset(offset);
            this.actualInterval.setEndLine(line);
            if (this.rootInterval.equals(this.actualInterval)) {
                this.actualInterval.setErroneous();
            } else {
                this.actualInterval = this.actualInterval.getParent();
            }
        }
    }

    public final void popInterval(Token aToken) {
        this.popInterval(aToken.getCharPositionInLine(), aToken.getLine());
    }

    public final void popInterval(CommonTokenStream aTokenStream) {
        int nonHiddenIndex = this.getNonHiddenTokensBefore(aTokenStream.index() - 1, aTokenStream.getTokens());
        Token t = aTokenStream.get(nonHiddenIndex);
        this.popInterval(t);
    }

    private final int getNonHiddenTokensBefore(int aIndex, List<Token> aTokens) {
        int nonHiddenIndex = aIndex;
        while (CfgParseTreePrinter.isHiddenToken(nonHiddenIndex, aTokens)) {
            --nonHiddenIndex;
        }
        return nonHiddenIndex;
    }

    public final Interval getRootInterval() {
        return this.rootInterval;
    }

    public void handleFinalCorrection() {
        if (this.rootInterval == null) {
            return;
        }
        while (this.actualInterval != null && !this.actualInterval.equals(this.rootInterval)) {
            this.actualInterval.setErroneous();
            this.popInterval(this.maxLength - 1, -1);
        }
    }
}

