/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.values.Named_Bits;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ASN1_BitString_Type
extends ASN1Type {
    private static final String BITSTRINGVALUEEXPECTED1 = "BIT STRING value was expected";
    private static final String BITSTRINGVALUEEXPECTED2 = "bitstring value was expected";
    private final Block mBlock;
    private NamedValues namedValues;

    public ASN1_BitString_Type(Block aBlock) {
        this.mBlock = aBlock;
        if (null != aBlock) {
            aBlock.setFullNameParent(this);
        }
    }

    @Override
    public IASN1Type newInstance() {
        return new ASN1_BitString_Type(this.mBlock);
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_BITSTRING_A;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_BITSTRING;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.namedValues) {
            this.namedValues.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (child == this.namedValues) {
            builder.append(".<namedvalues>");
        }
        return builder;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_BITSTRING.equals((Object)temp.getTypetype()) || IType.Type_type.TYPE_BITSTRING_A.equals((Object)temp.getTypetype());
    }

    @Override
    public String getTypename() {
        return "bitstring";
    }

    @Override
    public String getOutlineIcon() {
        return "bitstring.gif";
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("bit string");
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.myScope && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            return;
        }
        this.isErroneous = false;
        if (null == this.namedValues) {
            this.parseBlockBitstring();
        }
        if (this.isErroneous || null == this.namedValues) {
            return;
        }
        HashMap<String, Identifier> nameMap = new HashMap<String, Identifier>();
        int size = this.namedValues.getSize();
        for (int i = 0; i < size; ++i) {
            NamedValue namedValue = this.namedValues.getNamedValueByIndex(i);
            Identifier identifier = namedValue.getName();
            if (nameMap.containsKey(identifier.getName())) {
                Location tempLocation = ((Identifier)nameMap.get(identifier.getName())).getLocation();
                tempLocation.reportSingularSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was first declared here", identifier.getDisplayName()));
                identifier.getLocation().reportSemanticError(MessageFormat.format("Duplicate definition with name `{0}'' was declared here again", identifier.getDisplayName()));
                continue;
            }
            nameMap.put(identifier.getName(), identifier);
        }
        HashMap<Integer, NamedValue> valueMap = new HashMap<Integer, NamedValue>();
        int size2 = this.namedValues.getSize();
        block4: for (int i = 0; i < size2; ++i) {
            NamedValue namedValue = this.namedValues.getNamedValueByIndex(i);
            IValue value = namedValue.getValue();
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue last = value.getValueRefdLast(timestamp, referenceChain);
            referenceChain.release();
            if (last.getIsErroneous(timestamp)) continue;
            switch (last.getValuetype()) {
                case INTEGER_VALUE: {
                    Integer_Value integerValue = (Integer_Value)last;
                    if (integerValue.isNative()) {
                        int intValue = integerValue.intValue();
                        Integer intValueObject = intValue;
                        if (intValue < 0) {
                            value.getLocation().reportSemanticError(MessageFormat.format("A non-negative INTEGER value was expected for named bit `{0}'' instead of {1}", namedValue.getName().getDisplayName(), intValueObject));
                            value.setIsErroneous(true);
                            continue block4;
                        }
                        if (valueMap.containsKey(intValueObject)) {
                            value.getLocation().reportSemanticError(MessageFormat.format("Duplicate value {0} for named bit `{1}''", intValueObject, namedValue.getName().getDisplayName()));
                            value.setIsErroneous(true);
                            NamedValue temp = (NamedValue)valueMap.get(intValueObject);
                            temp.getLocation().reportSemanticError(MessageFormat.format("Bit {0} is already assigned to name `{1}''", intValueObject, temp.getName().getDisplayName()));
                            continue block4;
                        }
                        valueMap.put(intValueObject, namedValue);
                        continue block4;
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format("INTEGER value `{0}'' is too big to be used as a named bit", integerValue.getValueValue()));
                    value.setIsErroneous(true);
                    continue block4;
                }
                default: {
                    namedValue.getLocation().reportSemanticError(MessageFormat.format("INTEGER value was expected for named bit `{0}''", namedValue.getName().getDisplayName()));
                }
            }
        }
        nameMap.clear();
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        IValue last;
        boolean selfReference;
        block24: {
            block23: {
                selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
                last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
                if (last == null || last.getIsErroneous(timestamp)) {
                    return selfReference;
                }
                switch (value.getValuetype()) {
                    case OMIT_VALUE: 
                    case REFERENCED_VALUE: {
                        return selfReference;
                    }
                    case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                        if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                        return selfReference;
                    }
                }
                if (!last.isAsn()) break block23;
                if (last instanceof IReferencingType) {
                    IType type = last.getMyGovernor().getTypeRefdLast(timestamp);
                    switch (type.getTypetype()) {
                        case TYPE_BITSTRING: 
                        case TYPE_BITSTRING_A: {
                            break;
                        }
                        default: {
                            value.getLocation().reportSemanticError("(reference to) BIT STRING value was expected");
                            value.setIsErroneous(true);
                            value.setLastTimeChecked(timestamp);
                            return selfReference;
                        }
                    }
                }
                switch (last.getValuetype()) {
                    case BITSTRING_VALUE: {
                        break block24;
                    }
                    case HEXSTRING_VALUE: {
                        last.setValuetype(timestamp, IValue.Value_type.BITSTRING_VALUE);
                        break block24;
                    }
                    case UNDEFINED_BLOCK: {
                        last = last.setValuetype(timestamp, IValue.Value_type.NAMED_BITS);
                        if (this.namedValues == null) {
                            value.getLocation().reportSemanticError(MessageFormat.format("No named bits are defined in type `{0}''", this.getTypename()));
                            value.setIsErroneous(true);
                            value.setLastTimeChecked(timestamp);
                            return selfReference;
                        }
                        Named_Bits namedBits = (Named_Bits)last;
                        StringBuilder builder = new StringBuilder(namedBits.getNofIds());
                        for (int i = 0; i < namedBits.getNofIds(); ++i) {
                            Identifier id = namedBits.getIdByIndex(i);
                            if (!this.namedValues.hasNamedValueWithName(id)) {
                                id.getLocation().reportSemanticError(MessageFormat.format("No named bit with name `{0}'' is defined in type `{1}''", id.getDisplayName(), this.getTypename()));
                                value.setIsErroneous(true);
                                value.setLastTimeChecked(timestamp);
                                return selfReference;
                            }
                            IValue tempValue = this.namedValues.getNamedValueByName(id).getValue();
                            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            tempValue = tempValue.getValueRefdLast(timestamp, referenceChain);
                            referenceChain.release();
                            if (tempValue.getIsErroneous(timestamp) || !IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype())) continue;
                            int bitIndex = ((Integer_Value)tempValue).intValue();
                            while (builder.length() <= bitIndex) {
                                builder.append('0');
                            }
                            builder.setCharAt(bitIndex, '1');
                        }
                        last = new Bitstring_Value(builder.toString());
                        last.copyGeneralProperties(value);
                        namedBits.setRealValue((Bitstring_Value)last);
                        break block24;
                    }
                    default: {
                        value.getLocation().reportSemanticError(BITSTRINGVALUEEXPECTED1);
                        value.setIsErroneous(true);
                        value.setLastTimeChecked(timestamp);
                        return selfReference;
                    }
                }
            }
            switch (last.getValuetype()) {
                case BITSTRING_VALUE: {
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(BITSTRINGVALUEEXPECTED2);
                    value.setIsErroneous(true);
                }
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case BSTR_PATTERN: {
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format("{0} cannot be used for type `bitstring''", template.getTemplateTypeName()));
            }
        }
        return false;
    }

    private void parseBlockBitstring() {
        if (null == this.mBlock) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (null == parser) {
            return;
        }
        this.namedValues = parser.pr_special_NamedBitList().namedValues;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            this.isErroneous = true;
            this.namedValues = null;
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (this.namedValues != null) {
            this.namedValues.setFullNameParent(this);
            this.namedValues.setMyScope(this.getMyScope());
        }
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                Value indexValue = ((ArraySubReference)subreference).getValue();
                this.checkStringIndex(timestamp, indexValue, expectedIndex, refChain);
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.namedValues != null) {
            this.namedValues.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.namedValues == null || this.namedValues.accept(v);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.getGenNameTemplate(aData, source)));
        } else if (this.getParentType() == null || !this.getParentType().generatesOwnClass(aData, source)) {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.hasRawAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return "BIT__STRING";
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanBitString");
        return "TitanBitString";
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        aData.addBuiltinTypeImport("TitanBitString_template");
        return "TitanBitString_template";
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        this.generateCodeIspresentBound_forStrings(aData, expression, subreferences, subReferenceIndex, globalId, externalId, isTemplate, optype, field, targetScope);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp())) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        aData.addBuiltinTypeImport("TitanBitString");
        return "TitanBitString.TitanBitString";
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        aData.addBuiltinTypeImport("TitanBitString");
        return MessageFormat.format("TitanBitString.convert_to_BitString({0})", fromName);
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("TitanBitString");
        return "TitanBitString.TitanBitString_json_";
    }
}

