/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.ObjectIdentifierComponent;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RelativeObjectIdentifier_Value
extends Value {
    private final List<ObjectIdentifierComponent> objectIdComponents = new ArrayList<ObjectIdentifierComponent>();

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.RELATIVEOBJECTIDENTIFIER_VALUE;
    }

    public void addObjectIdComponent(ObjectIdentifierComponent component) {
        if (null == component) {
            return;
        }
        this.objectIdComponents.add(component);
        component.setFullNameParent(this);
        component.setMyScope(this.myScope);
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            ObjectIdentifierComponent component = this.objectIdComponents.get(i);
            if (component != child) continue;
            return builder.append(".").append(i + 1);
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_ROID;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        if (!this.isAsn()) {
            builder.append("objid ");
        }
        builder.append('{');
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(this.objectIdComponents.get(i).createStringRepresentation());
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            this.objectIdComponents.get(i).setMyScope(scope);
        }
    }

    public int getNofComponents() {
        return this.objectIdComponents.size();
    }

    public void getOidComponents(JavaGenData aData, List<String> components) {
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            this.objectIdComponents.get(i).getOidComponents(aData, components);
        }
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.checkROID(timestamp, referenceChain);
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            if (!this.objectIdComponents.get(i).isVariable()) continue;
            return true;
        }
        return false;
    }

    public void checkROID(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.objectIdComponents.isEmpty()) {
            return;
        }
        if (!referenceChain.add(this)) {
            return;
        }
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            referenceChain.markState();
            this.objectIdComponents.get(i).checkROID(timestamp, referenceChain);
            referenceChain.previousState();
        }
    }

    @Override
    public boolean evaluateIsvalue(boolean fromSequence) {
        return true;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        if (!IValue.Value_type.RELATIVEOBJECTIDENTIFIER_VALUE.equals((Object)last.getValuetype())) {
            return false;
        }
        RelativeObjectIdentifier_Value otherObjid = (RelativeObjectIdentifier_Value)last;
        if (this.objectIdComponents.size() != otherObjid.objectIdComponents.size()) {
            return false;
        }
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            if (this.objectIdComponents.get(i) == otherObjid.objectIdComponents.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.objectIdComponents.size();
        for (int i = 0; i < size; ++i) {
            ObjectIdentifierComponent component = this.objectIdComponents.get(i);
            component.updateSyntax(reparser, false);
            reparser.updateLocation(component.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.objectIdComponents != null) {
            for (ObjectIdentifierComponent c : this.objectIdComponents) {
                if (c.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("TitanObjectid");
        ArrayList<String> components = new ArrayList<String>();
        this.getOidComponents(aData, components);
        StringBuilder oiString = new StringBuilder();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                oiString.append(", ");
            }
            oiString.append(components.get(i));
        }
        result.append(MessageFormat.format("new TitanObjectid({0}, {1})", components.size(), oiString));
        return result;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        aData.addBuiltinTypeImport("TitanObjectid");
        source.append(MessageFormat.format("{0}.operator_assign({1});\n", name, this.generateSingleExpression(aData)));
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }
}

