/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorSetting;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ErrorBehaviorList
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String[] VALID_TYPES = new String[]{"UNBOUND", "INCOMPL_ANY", "ENC_ENUM", "INCOMPL_MSG", "LEN_FORM", "INVAL_MSG", "REPR", "CONSTRAINT", "TAG", "SUPERFL", "EXTENSION", "DEC_ENUM", "DEC_DUPFLD", "DEC_MISSFLD", "DEC_OPENTYPE", "DEC_UCSTR", "LEN_ERR", "SIGN_ERR", "INCOMP_ORDER", "TOKEN_ERR", "LOG_MATCHING", "FLOAT_TR", "FLOAT_NAN", "OMITTED_TAG", "NEGTEST_CONFL", "EXTRA_DATA"};
    private static final String[] VALID_HANDLINGS = new String[]{"DEFAULT", "ERROR", "WARNING", "IGNORE"};
    private final List<ErrorBehaviorSetting> settings = new ArrayList<ErrorBehaviorSetting>(1);
    private final Map<String, ErrorBehaviorSetting> settingMap = new HashMap<String, ErrorBehaviorSetting>();
    private ErrorBehaviorSetting settingAll;
    private CompilationTimeStamp lastTimeChecked;
    private Location location;

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.settings.size();
        for (int i = 0; i < size; ++i) {
            ErrorBehaviorSetting setting = this.settings.get(i);
            if (setting != child) continue;
            return builder.append(".<setting ").append(i + 1).append('>');
        }
        return builder;
    }

    public void addSetting(ErrorBehaviorSetting setting) {
        if (setting != null) {
            this.settings.add(setting);
        }
    }

    public void addAllBehaviors(ErrorBehaviorList other) {
        if (other != null) {
            this.settings.addAll(other.settings);
        }
    }

    public int getNofErrorBehaviors() {
        return this.settings.size();
    }

    public ErrorBehaviorSetting getBehaviorByIndex(int index) {
        return this.settings.get(index);
    }

    public boolean hasSetting(CompilationTimeStamp timestamp, String errorType) {
        this.check(timestamp);
        return this.settingAll != null || this.settingMap.containsKey(errorType);
    }

    public String getHandling(CompilationTimeStamp timestamp, String errorType) {
        this.check(timestamp);
        if (this.settingMap.containsKey(errorType)) {
            return this.settingMap.get(errorType).getErrorHandling();
        }
        if (this.settingAll != null) {
            return this.settingAll.getErrorHandling();
        }
        return "DEFAULT";
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        for (ErrorBehaviorSetting setting : this.settings) {
            String errorType = setting.getErrorType();
            if ("ALL".equals(errorType)) {
                if (this.settingAll != null) {
                    setting.getLocation().reportSemanticWarning("Duplicate setting for error type `ALL'");
                    this.settingAll.getLocation().reportSemanticWarning("The previous setting is ignored");
                }
                this.settingAll = setting;
                if (!this.settingMap.isEmpty()) {
                    setting.getLocation().reportSemanticWarning("All setting before `ALL' are ignored");
                    this.settingMap.clear();
                }
            } else {
                if (this.settingMap.containsKey(errorType)) {
                    setting.getLocation().reportSemanticWarning(MessageFormat.format("Duplicate setting for error type `{0}''", errorType));
                    this.settingMap.get(errorType).getLocation().reportSemanticWarning("The previous setting is ignored");
                    this.settingMap.put(errorType, setting);
                } else {
                    this.settingMap.put(errorType, setting);
                }
                boolean typeFound = false;
                for (String validType : VALID_TYPES) {
                    if (!validType.equals(errorType)) continue;
                    typeFound = true;
                    break;
                }
                if (!typeFound) {
                    setting.getLocation().reportSemanticWarning(MessageFormat.format("String `{0}'' is not a valid error type", errorType));
                }
            }
            String errorHandling = setting.getErrorHandling();
            boolean handlingFound = false;
            for (String validHandling : VALID_HANDLINGS) {
                if (!validHandling.equals(errorHandling)) continue;
                handlingFound = true;
                break;
            }
            if (handlingFound) continue;
            setting.getLocation().reportSemanticWarning(MessageFormat.format("String `{0}'' is not a valid error handling", errorHandling));
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (ErrorBehaviorSetting setting : this.settings) {
            setting.updateSyntax(reparser, false);
            reparser.updateLocation(setting.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.settings != null) {
            for (ErrorBehaviorSetting s : this.settings) {
                if (s.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.settingAll != null) {
            source.append(MessageFormat.format("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_{0});\n", this.settingAll.getErrorHandling()));
        } else {
            source.append("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
        }
        for (ErrorBehaviorSetting ebs : this.settingMap.values()) {
            source.append(MessageFormat.format("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_{0}, TTCN_EncDec.error_behavior_type.EB_{1});\n", ebs.getErrorType(), ebs.getErrorHandling()));
        }
    }
}

