/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Def_FunctionBase
extends Definition
implements IParameterisedAssignment {
    protected Location signatureLocation = null;
    protected Assignment.Assignment_type assignmentType;
    protected final FormalParameterList formalParameterList;
    protected final StatementBlock statementBlock;
    protected final Type returnType;
    protected final boolean isFinal;
    protected final boolean isAbstract;
    protected final boolean isDeterministic;
    protected final boolean isControl;
    protected NamedBridgeScope bridgeScope = null;

    protected Def_FunctionBase(Identifier identifier, StatementBlock statementBlock, boolean isAbstract, boolean isFinal, boolean isDeterministic, boolean isControl, FormalParameterList formalParameterList, Type returnType) {
        super(identifier);
        this.statementBlock = statementBlock;
        this.isAbstract = isAbstract;
        this.isControl = isControl;
        this.isDeterministic = isDeterministic;
        this.isFinal = isFinal;
        this.formalParameterList = formalParameterList;
        this.returnType = returnType;
    }

    @Override
    public String getOutlineIcon() {
        if (this.returnType == null) {
            return "function.gif";
        }
        return "function_return.gif";
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParameterList;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return this.assignmentType;
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.returnType;
    }

    public Location getSignatureLocation() {
        return this.signatureLocation;
    }

    public void setSignatureLocation(Location signatureLocation) {
        this.signatureLocation = signatureLocation;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean hasBody() {
        return this.statementBlock != null;
    }

    protected void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    public String generateCommonDocComment(String indentation, FormalParameterList formalParameterList, Type returnType) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n");
        if (formalParameterList != null && formalParameterList.getNofParameters() > 0) {
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                FormalParameter param = formalParameterList.getParameterByIndex(i);
                sb.append(ind).append("@param").append(" ").append(param.getIdentifier().getDisplayName()).append("\n");
            }
        }
        if (returnType != null) {
            sb.append(ind).append("@return").append("\n");
        }
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }

    public Ttcn3HoverContent getHoverContentFromComment(Ttcn3HoverContent hoverContent, DocumentComment dc, FormalParameterList formalParameterList) {
        if (dc != null) {
            dc.addDescsContent(hoverContent);
            dc.addParamsContent(hoverContent, formalParameterList);
            dc.addReturnContent(hoverContent);
            dc.addVerdictsContent(hoverContent);
            dc.addRequirementsContent(hoverContent);
            dc.addStatusContent(hoverContent);
            dc.addRemarksContent(hoverContent);
            dc.addSinceContent(hoverContent);
            dc.addVersionContent(hoverContent);
            dc.addAuthorsContent(hoverContent);
            dc.addReferenceContent(hoverContent);
            dc.addSeesContent(hoverContent);
            dc.addUrlsContent(hoverContent);
        } else if (formalParameterList != null && formalParameterList.getNofParameters() > 0) {
            hoverContent.addTag("Parameters");
            for (int i = 0; i < formalParameterList.getNofParameters(); ++i) {
                FormalParameter param = formalParameterList.getParameterByIndex(i);
                String paramType = param.getFormalParamType();
                StringBuilder sb = new StringBuilder(param.getIdentifier().getDisplayName());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                hoverContent.addIndentedText(sb.toString(), "");
            }
        }
        return hoverContent;
    }

    public abstract FormalParameterList.IsIdenticalResult isIdentical(CompilationTimeStamp var1, Def_FunctionBase var2);

    public static enum EncodingPrototype_type {
        NONE("<no prototype>"),
        BACKTRACK("backtrack"),
        CONVERT("convert"),
        FAST("fast"),
        SLIDING("sliding");

        private String name;

        private EncodingPrototype_type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

