/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Int2Enum_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".value";
    private static final String FULLNAMEPART2 = ".reference";
    private static final String STATEMENT_NAME = "int2enum";
    private static final String OPERANDERROR1 = "The first operand of the `int2enum' operation should be an integer value";
    private static final String OPERANDERROR2 = "A reference to a variable or a value parameter of type enumerated was expected";
    private final Value value;
    private final Reference reference;

    public Int2Enum_Statement(Value value, Reference reference) {
        this.value = value;
        this.reference = reference;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_INT2ENUM;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.reference == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        IType refType;
        IType varRef;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.value != null) {
            this.value.setLoweridToReference(timestamp);
            IType.Type_type temporalType = this.value.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            switch (temporalType) {
                case TYPE_INTEGER: 
                case TYPE_INTEGER_A: {
                    this.value.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                    break;
                }
                case TYPE_UNDEFINED: {
                    this.setIsErroneous();
                    break;
                }
                default: {
                    if (this.isErroneous) break;
                    this.value.getLocation().reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous();
                }
            }
        }
        if (this.reference != null && (varRef = this.reference.checkVariableReference(timestamp)) != null && IType.Type_type.TYPE_TTCN3_ENUMERATED != (refType = varRef.getTypeRefdLast(timestamp)).getTypetypeTtcn3() && !this.isErroneous) {
            this.reference.getLocation().reportSemanticError(OPERANDERROR2);
            this.setIsErroneous();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct valueExpression = new ExpressionStruct();
        this.value.generateCodeExpression(aData, valueExpression, true);
        ExpressionStruct referenceExpression = new ExpressionStruct();
        this.reference.generateCode(aData, referenceExpression);
        boolean isOptional = false;
        Assignment assignment = this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (assignment.getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(this.reference.getSubreferences())) {
            isOptional = true;
        }
        source.append((CharSequence)valueExpression.preamble);
        source.append((CharSequence)referenceExpression.preamble);
        source.append(MessageFormat.format("{0}{1}.int2enum({2});\n", referenceExpression.expression, isOptional ? ".get()" : "", valueExpression.expression));
        source.append((CharSequence)valueExpression.postamble);
        source.append((CharSequence)referenceExpression.postamble);
    }
}

