/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectCases
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".select_case_";
    private final List<SelectCase> select_cases = new ArrayList<SelectCase>();

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            if (this.select_cases.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectCase(SelectCase selectCase) {
        List<SelectCase> list = this.select_cases;
        synchronized (list) {
            this.select_cases.add(selectCase);
        }
        selectCase.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        for (SelectCase select_case : this.select_cases) {
            select_case.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (SelectCase select_case : this.select_cases) {
            select_case.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.select_cases.size();
        for (int i = 0; i < size; ++i) {
            this.select_cases.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        for (SelectCase select_case : this.select_cases) {
            select_case.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        for (SelectCase select_case : this.select_cases) {
            select_case.setMyAltguards(altGuards);
        }
    }

    public void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        for (SelectCase selectCase : this.select_cases) {
            selectCase.getStatementBlock().setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        boolean hasElse = false;
        for (SelectCase select_case : this.select_cases) {
            switch (select_case.hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (!select_case.hasElse()) continue;
            hasElse = true;
            break;
        }
        if (!hasElse && result == StatementBlock.ReturnStatus_type.RS_YES) {
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return result;
    }

    public boolean hasReceivingStatement() {
        for (int i = 0; i < this.select_cases.size(); ++i) {
            if (!this.select_cases.get(i).hasReceivingStatement()) continue;
            return true;
        }
        return false;
    }

    public void check(CompilationTimeStamp timestamp, IType governor) {
        boolean unrechable = false;
        for (SelectCase select_case : this.select_cases) {
            unrechable = select_case.check(timestamp, governor, unrechable);
        }
    }

    public void checkAllowedInterleave() {
        for (SelectCase select_case : this.select_cases) {
            select_case.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        for (SelectCase select_case : this.select_cases) {
            select_case.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (SelectCase select_case : this.select_cases) {
            select_case.updateSyntax(reparser, false);
            reparser.updateLocation(select_case.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.select_cases == null) {
            return;
        }
        for (SelectCase sc : this.select_cases) {
            sc.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.select_cases != null) {
            for (SelectCase sc : this.select_cases) {
                if (sc.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public List<SelectCase> getSelectCaseArray() {
        return this.select_cases;
    }

    public void generateCode(JavaGenData aData, StringBuilder source, String name) {
        StringBuilder init = new StringBuilder();
        AtomicBoolean unreach = new AtomicBoolean(false);
        for (int i = 0; i < this.select_cases.size() && !unreach.get(); ++i) {
            if (i > 0) {
                source.append("else { \n");
                init.append("}\n");
            }
            this.select_cases.get(i).generateCode(aData, source, name, unreach);
        }
        source.append((CharSequence)init);
    }
}

