/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectUnionCase
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String INVALID_UNION_FIELD = "Union `{0}'' has no field `{1}''";
    private static final String INVALID_ANYTYPE_FIELD = "Anytype `{0}'' has no field `{1}''";
    private static final String CASE_ALREADY_COVERED = "Case `{0}'' is already covered";
    private static final String FULLNAMEPART = ".block";
    private final List<Identifier> items;
    private final StatementBlock statementBlock;
    private Location location = NULL_Location.INSTANCE;

    public SelectUnionCase(List<Identifier> aItems, StatementBlock aStatementBlock) {
        this.items = aItems;
        this.statementBlock = aStatementBlock;
        if (this.statementBlock != null) {
            this.statementBlock.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.statementBlock == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    public StatementBlock getStatementBlock() {
        return this.statementBlock;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.statementBlock != null) {
            this.statementBlock.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock parStatementBlock, int index) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyStatementBlock(parStatementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyAltguards(altGuards);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public boolean hasElse() {
        return this.items == null;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementBlock != null) {
            return this.statementBlock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    public boolean hasReceivingStatement() {
        if (this.statementBlock != null) {
            return this.statementBlock.hasReceivingStatement(0);
        }
        return false;
    }

    public boolean check(CompilationTimeStamp aTimestamp, TTCN3_Choice_Type aUnionType, boolean aUnreachable, List<String> aFieldNames) {
        boolean unreachable2 = aUnreachable;
        if (this.items != null) {
            this.check(aUnionType, aFieldNames);
        } else {
            unreachable2 = true;
            aFieldNames.clear();
        }
        this.statementBlock.check(aTimestamp);
        return unreachable2;
    }

    public boolean check(CompilationTimeStamp aTimestamp, ASN1_Choice_Type aChoiceType, boolean aUnreachable, List<String> aFieldNames) {
        boolean unreachable2 = aUnreachable;
        if (this.items != null) {
            this.check(aChoiceType, aFieldNames);
        } else {
            unreachable2 = true;
            aFieldNames.clear();
        }
        this.statementBlock.check(aTimestamp);
        return unreachable2;
    }

    void checkStatementBlock(CompilationTimeStamp aTimestamp) {
        if (this.statementBlock != null) {
            this.statementBlock.check(aTimestamp);
        }
    }

    public boolean check(CompilationTimeStamp aTimestamp, Anytype_Type aAnytypeType, boolean aUnreachable, List<String> aTypesCovered) {
        boolean unreachable2 = aUnreachable;
        if (this.items != null) {
            this.check(aAnytypeType, aTypesCovered);
        } else {
            unreachable2 = true;
        }
        this.statementBlock.check(aTimestamp);
        return unreachable2;
    }

    public void check(TTCN3_Choice_Type aUnionType, List<String> aFieldNames) {
        for (Identifier identifier : this.items) {
            String name = identifier.getName();
            if (aUnionType.hasComponentWithName(name)) {
                if (aFieldNames.contains(name)) {
                    aFieldNames.remove(name);
                    continue;
                }
                identifier.getLocation().reportSemanticWarning(MessageFormat.format(CASE_ALREADY_COVERED, identifier.getTtcnName()));
                continue;
            }
            identifier.getLocation().reportSemanticError(MessageFormat.format(INVALID_UNION_FIELD, aUnionType.getFullName(), identifier.getTtcnName()));
        }
    }

    public void check(ASN1_Choice_Type aChoiceType, List<String> aFieldNames) {
        for (Identifier identifier : this.items) {
            if (aChoiceType.hasComponentWithName(identifier)) {
                if (aFieldNames.contains(identifier.getTtcnName())) {
                    aFieldNames.remove(identifier.getTtcnName());
                    continue;
                }
                identifier.getLocation().reportSemanticWarning(MessageFormat.format(CASE_ALREADY_COVERED, identifier.getTtcnName()));
                continue;
            }
            identifier.getLocation().reportSemanticError(MessageFormat.format(INVALID_UNION_FIELD, aChoiceType.getFullName(), identifier.getTtcnName()));
        }
    }

    public void check(Anytype_Type aAnytypeType, List<String> aTypesCovered) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            Identifier identifier = this.items.get(i);
            String name = identifier.getName();
            if (aAnytypeType.hasComponentWithName(name)) {
                if (aTypesCovered.contains(name)) {
                    aTypesCovered.remove(name);
                    continue;
                }
                identifier.getLocation().reportSemanticWarning(MessageFormat.format(CASE_ALREADY_COVERED, identifier.getTtcnName()));
                continue;
            }
            identifier.getLocation().reportSemanticError(MessageFormat.format(INVALID_ANYTYPE_FIELD, aAnytypeType.getFullName(), identifier.getTtcnName()));
        }
    }

    public void checkAllowedInterleave() {
        if (this.statementBlock != null) {
            this.statementBlock.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        if (this.statementBlock != null) {
            this.statementBlock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.items != null) {
            for (Identifier item : this.items) {
                if (item instanceof Identifier) {
                    Identifier identifier = item;
                    reparser.updateLocation(identifier.getLocation());
                    continue;
                }
                ErrorReporter.INTERNAL_ERROR((String)"Invalid type in select union case");
            }
        }
        if (this.statementBlock != null) {
            this.statementBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementBlock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.statementBlock != null) {
            this.statementBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.items != null) {
            for (Identifier item : this.items) {
                if (item.accept(v)) continue;
                return false;
            }
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    public void generateCode(JavaGenData aData, StringBuilder source, AtomicBoolean unreach) {
        if (this.items != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                Identifier identifier = this.items.get(i);
                String name = identifier.getName();
                source.append(MessageFormat.format("case ALT_{0}:\n", FieldSubReference.getJavaGetterName(name)));
            }
        } else {
            unreach.set(true);
            source.append("default:\n");
        }
        this.statementBlock.generateCode(aData, source);
        source.append("break;\n");
    }
}

