/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ValueListConstraint
extends SubtypeConstraint {
    private final List<IValue> values;

    public ValueListConstraint() {
        this.values = new ArrayList<IValue>();
    }

    public ValueListConstraint(IValue value) {
        this.values = new ArrayList<IValue>();
        this.values.add(value);
    }

    private ValueListConstraint(List<IValue> values) {
        this.values = values;
    }

    @Override
    public ValueListConstraint complement() {
        ErrorReporter.INTERNAL_ERROR((String)"invalid set operation");
        return null;
    }

    @Override
    public ValueListConstraint except(SubtypeConstraint other) {
        ValueListConstraint o = (ValueListConstraint)other;
        ArrayList<IValue> returnValue = new ArrayList<IValue>();
        for (IValue v : this.values) {
            if (o.isElement(v)) continue;
            returnValue.add(v);
        }
        return new ValueListConstraint(returnValue);
    }

    @Override
    public SubtypeConstraint intersection(SubtypeConstraint other) {
        ValueListConstraint o = (ValueListConstraint)other;
        ArrayList<IValue> returnValue = new ArrayList<IValue>();
        for (IValue v : this.values) {
            if (!o.isElement(v)) continue;
            returnValue.add(v);
        }
        return new ValueListConstraint(returnValue);
    }

    @Override
    public TernaryBool isSubset(SubtypeConstraint other) {
        return this.except(other).isEmpty();
    }

    @Override
    public boolean isElement(Object o) {
        Value val = (Value)o;
        for (IValue v : this.values) {
            if (!v.checkEquality(CompilationTimeStamp.getBaseTimestamp(), val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.values.isEmpty());
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        int i;
        ValueListConstraint o = (ValueListConstraint)other;
        if (this.values.size() != o.values.size()) {
            return TernaryBool.TFALSE;
        }
        boolean[] found = new boolean[this.values.size()];
        for (i = 0; i < found.length; ++i) {
            found[i] = false;
        }
        int size = this.values.size();
        for (i = 0; i < size; ++i) {
            IValue tempValueI = this.values.get(i);
            boolean foundI = false;
            for (int j = 0; j < size; ++j) {
                IValue tempValueJ;
                if (found[j] || !tempValueI.checkEquality((tempValueJ = o.values.get(j)).getLastTimeChecked(), tempValueJ)) continue;
                found[j] = true;
                foundI = true;
                break;
            }
            if (foundI) continue;
            return TernaryBool.TFALSE;
        }
        return TernaryBool.TTRUE;
    }

    @Override
    public TernaryBool isFull() {
        return TernaryBool.TUNKNOWN;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        boolean needComma = false;
        for (IValue v : this.values) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(v.createStringRepresentation());
            needComma = true;
        }
        sb.append(')');
    }

    @Override
    public ValueListConstraint union(SubtypeConstraint other) {
        ValueListConstraint o = (ValueListConstraint)other;
        ArrayList<IValue> returnValue = new ArrayList<IValue>();
        returnValue.addAll(this.values);
        for (IValue v : o.values) {
            if (this.isElement(v)) continue;
            returnValue.add(v);
        }
        return new ValueListConstraint(returnValue);
    }

    public ValueListConstraint remove(RangeListConstraint sizeConstraint, boolean ifElement) {
        ArrayList<IValue> returnValue = new ArrayList<IValue>();
        block5: for (IValue v : this.values) {
            switch (v.getValuetype()) {
                case ARRAY_VALUE: {
                    if (sizeConstraint.isElement(new SizeLimit(((Array_Value)v).getNofComponents())) == ifElement) continue block5;
                    returnValue.add(v);
                    continue block5;
                }
                case SEQUENCEOF_VALUE: {
                    if (sizeConstraint.isElement(new SizeLimit(((SequenceOf_Value)v).getNofComponents())) == ifElement) continue block5;
                    returnValue.add(v);
                    continue block5;
                }
                case SETOF_VALUE: {
                    if (sizeConstraint.isElement(new SizeLimit(((SetOf_Value)v).getNofComponents())) == ifElement) continue block5;
                    returnValue.add(v);
                    continue block5;
                }
            }
            ErrorReporter.INTERNAL_ERROR();
        }
        return new ValueListConstraint(returnValue);
    }
}

