/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.types.Altstep_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Altstep_Reference_Value
extends Value {
    private final Def_Altstep referredAltstep;

    public Altstep_Reference_Value(Def_Altstep referredAltstep) {
        this.referredAltstep = referredAltstep;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.ALTSTEP_REFERENCE_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("refers(");
        builder.append(this.referredAltstep.getAssignmentName()).append(')');
        return builder.toString();
    }

    public Def_Altstep getReferredAltstep() {
        return this.referredAltstep;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_ALTSTEP;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.ALTSTEP_REFERENCE_VALUE.equals((Object)last.getValuetype()) && this.referredAltstep == ((Altstep_Reference_Value)last).getReferredAltstep();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(name);
        source.append(".operator_assign( ");
        source.append((CharSequence)this.generateSingleExpression(aData));
        source.append(" );\n");
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        aData.addBuiltinTypeImport("Default_Base");
        aData.addBuiltinTypeImport("TitanAlt_Status");
        StringBuilder result = new StringBuilder();
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        if (governor == null || this.referredAltstep == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "''"));
            return result;
        }
        IType lastGovernor = governor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        result.append(MessageFormat.format("new {0}(new {0}.function_pointer() '{'\n", governor.getGenNameValue(aData, result)));
        result.append("@Override\n");
        result.append("public String getModuleName() {\n");
        result.append(MessageFormat.format("return \"{0}\";\n", this.referredAltstep.getMyScope().getModuleScopeGen().getIdentifier().getName()));
        result.append("}\n");
        result.append("@Override\n");
        result.append("public String getDefinitionName() {\n");
        result.append(MessageFormat.format("return \"{0}\";\n", this.referredAltstep.getIdentifier().getName()));
        result.append("}\n");
        Altstep_Type altstepType = (Altstep_Type)lastGovernor;
        String moduleName = this.referredAltstep.getMyScope().getModuleScopeGen().getName();
        String altstepName = this.referredAltstep.getIdentifier().getName();
        String altstepGenName = this.referredAltstep.getGenNameFromScope(aData, result, "");
        StringBuilder actualParList = altstepType.getFormalParameters().generateCodeActualParlist("");
        result.append("@Override\n");
        result.append("public void invoke_standalone(");
        altstepType.getFormalParameters().generateCode(aData, result);
        result.append(") {\n");
        result.append(MessageFormat.format("{0}({1});\n", altstepGenName, actualParList));
        result.append("}\n");
        result.append("@Override\n");
        result.append("public Default_Base activate(");
        altstepType.getFormalParameters().generateCode(aData, result);
        result.append(") {\n");
        result.append(MessageFormat.format("return {0}.activate_{1}({2});\n", moduleName, altstepName, actualParList));
        result.append("}\n");
        result.append("@Override\n");
        result.append("public TitanAlt_Status invoke(");
        altstepType.getFormalParameters().generateCode(aData, result);
        result.append(") {\n");
        result.append(MessageFormat.format("return {0}.{1}_instance({2});\n", moduleName, altstepName, actualParList));
        result.append("}\n");
        result.append("})\n");
        return result;
    }
}

