/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Omit_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionUtilities;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EqualsExpression
extends Expression_Value {
    private final Value value1;
    private final Value value2;

    public EqualsExpression(Value value1, Value value2) {
        this.value1 = value1;
        this.value2 = value2;
        if (value1 != null) {
            value1.setFullNameParent(this);
        }
        if (value2 != null) {
            value2.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.EQUALS_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.value1 != null && this.value1.checkExpressionSelfReferenceValue(timestamp, lhs)) {
            return true;
        }
        return this.value2 != null && this.value2.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(this.value1.createStringRepresentation());
        builder.append(" == ");
        builder.append(this.value2.createStringRepresentation()).append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value1 != null) {
            this.value1.setMyScope(scope);
        }
        if (this.value2 != null) {
            this.value2.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value1 != null) {
            this.value1.setCodeSection(codeSection);
        }
        if (this.value2 != null) {
            this.value2.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value1 == child) {
            return builder.append(".<operand1>");
        }
        if (this.value2 == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return true;
        }
        return this.value1.isUnfoldable(timestamp, expectedValue, referenceChain) || this.value2.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value1 == null || this.value2 == null) {
            return;
        }
        if (this.value1.getIsErroneous(timestamp) || this.value2.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        ExpressionUtilities.checkExpressionOperatorCompatibility(timestamp, (Expression_Value)this, referenceChain, expectedValue, this.value1, this.value2);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.value1.getValueRefdLast(timestamp, expectedValue, referenceChain);
        this.value2.getValueRefdLast(timestamp, expectedValue, referenceChain);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value1 == null || this.value2 == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp) || this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last1 = this.value1.getValueRefdLast(timestamp, referenceChain);
        IValue last2 = this.value2.getValueRefdLast(timestamp, referenceChain);
        if (last1 == null || last2 == null) {
            this.setIsErroneous(true);
            return this.lastValue;
        }
        this.lastValue = new Boolean_Value(last1.checkEquality(timestamp, last2));
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value1 != null) {
                referenceChain.markState();
                this.value1.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.value2 != null) {
                referenceChain.markState();
                this.value2.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value1 != null) {
            this.value1.updateSyntax(reparser, false);
            reparser.updateLocation(this.value1.getLocation());
        }
        if (this.value2 != null) {
            this.value2.updateSyntax(reparser, false);
            reparser.updateLocation(this.value2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value1 != null) {
            this.value1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.value2 != null) {
            this.value2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value1 != null && !this.value1.accept(v)) {
            return false;
        }
        return this.value2 == null || this.value2.accept(v);
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value1 != null) {
            this.value1.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.value2 != null) {
            this.value2.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return this.value1.canGenerateSingleExpression() && this.value2.canGenerateSingleExpression() && !this.get_needs_conversion();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        Reference reference;
        Assignment assignment;
        Reference reference2;
        Assignment assignment2;
        boolean isOptional1 = false;
        boolean isOptional2 = false;
        IValue temp = this.value1.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
        if (temp instanceof Omit_Value) {
            isOptional1 = true;
        } else if (temp instanceof Referenced_Value && (assignment2 = (reference2 = ((Referenced_Value)temp).getReference()).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)).getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference2.getSubreferences())) {
            isOptional1 = true;
        }
        IValue temp2 = this.value2.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
        if (temp2 instanceof Omit_Value) {
            isOptional2 = true;
        } else if (temp2 instanceof Referenced_Value && (assignment = (reference = ((Referenced_Value)temp2).getReference()).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)).getType(CompilationTimeStamp.getBaseTimestamp()).fieldIsOptional(reference.getSubreferences())) {
            isOptional2 = true;
        }
        if (this.get_needs_conversion()) {
            ExpressionStruct tempExpr = new ExpressionStruct();
            IType type1 = this.value1.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            IType type2 = this.value2.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE).getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
            if (isOptional2) {
                this.value2.generateCodeExpression(aData, tempExpr, true);
            } else {
                this.value2.generateCodeExpressionMandatory(aData, tempExpr, false);
            }
            if (tempExpr.preamble.length() > 0) {
                expression.preamble.append((CharSequence)tempExpr.preamble);
            }
            String tempId2 = type1.generateConversion(aData, type2, tempExpr.expression.toString(), true, expression);
            if (isOptional1) {
                this.value1.generateCodeExpression(aData, expression, true);
            } else {
                this.value1.generateCodeExpressionMandatory(aData, expression, false);
            }
            expression.expression.append(MessageFormat.format(".operator_equals({0})", tempId2));
            return;
        }
        if (isOptional1) {
            this.value1.generateCodeExpression(aData, expression, true);
            expression.expression.append(".operator_equals( ");
            this.value2.generateCodeExpression(aData, expression, true);
            expression.expression.append(" )");
        } else if (isOptional2) {
            this.value2.generateCodeExpression(aData, expression, true);
            expression.expression.append(".operator_equals( ");
            this.value1.generateCodeExpression(aData, expression, true);
            expression.expression.append(" )");
        } else {
            this.value1.generateCodeExpressionMandatory(aData, expression, true);
            expression.expression.append(".operator_equals( ");
            this.value2.generateCodeExpressionMandatory(aData, expression, false);
            expression.expression.append(" )");
        }
    }
}

