/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Anytype_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Choice_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class IsChoosenExpression
extends Expression_Value {
    private static final String CONSTANTREFERENCEEXPECTED = "Reference to a constant value was expected instead of {0}";
    private static final String STATICREFERENCEEXPECTED = "Reference to a static value was expected instead of {0}";
    private static final String VALUETEMPLATEEXPECTED = "Reference to a value or template was expected instead of {0}";
    private static final String OPERANDERROR = "The operand of operation `ischosen()'' should be a record or set value or template, instead of `{0}''";
    private static final String MISSINGFIELD = "Type `{0}'' does not have a field named `{1}''";
    private final Reference reference;
    private Identifier identifier;
    private Referenced_Value value;
    private Referenced_Template template;
    private CompilationTimeStamp lastTimeoperandsChecked;

    public IsChoosenExpression(Reference reference) {
        this.reference = reference;
        if (reference != null) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.ISCHOOSEN_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        if (this.template != null && this.template.checkExpressionSelfReferenceTemplate(timestamp, lhs)) {
            return true;
        }
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("ischoosen(");
        builder.append(this.reference.getDisplayName());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.reference != null) {
            this.reference.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.reference == child) {
            return builder.append(".<operand>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.value == null || this.getIsErroneous(timestamp)) {
            return true;
        }
        return this.value.isUnfoldable(timestamp, expectedValue, referenceChain);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType governor;
        if (this.lastTimeoperandsChecked != null && !this.lastTimeoperandsChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeoperandsChecked = timestamp;
        this.value = null;
        this.identifier = null;
        if (this.reference == null || this.reference.getSubreferences().size() < 2) {
            this.setIsErroneous(true);
            return;
        }
        Reference tempReference = this.reference.newInstance();
        tempReference.setFullNameParent(this);
        tempReference.setMyScope(this.getMyScope());
        ISubReference subreference = tempReference.removeLastSubReference();
        if (!ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            this.setIsErroneous(true);
            return;
        }
        this.identifier = ((FieldSubReference)subreference).getId();
        Assignment assignment = tempReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return;
        }
        switch (assignment.getAssignmentType()) {
            case A_CONST: 
            case A_EXT_CONST: 
            case A_MODULEPAR: 
            case A_VAR: 
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: 
            case A_PAR_VAL_OUT: 
            case A_PAR_VAL_INOUT: {
                this.value = new Referenced_Value(tempReference);
                this.value.setLocation(tempReference.getLocation());
                this.value.setMyScope(this.getMyScope());
                BridgingNamedNode tempNamedNode = new BridgingNamedNode(this, ".<operand>");
                this.value.setFullNameParent(tempNamedNode);
                governor = this.value.getExpressionGovernor(timestamp, expectedValue);
                if (governor == null) {
                    this.setIsErroneous(true);
                    break;
                }
                this.value.setMyGovernor(governor);
                IValue tempValue2 = governor.checkThisValueRef(timestamp, this.value);
                if (!tempValue2.getIsErroneous(timestamp)) break;
                this.setIsErroneous(true);
                break;
            }
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                this.template = new Referenced_Template(tempReference);
                this.template.setLocation(tempReference.getLocation());
                this.template.setMyScope(this.getMyScope());
                BridgingNamedNode tempNamedNode = new BridgingNamedNode(this, ".<operand>");
                this.template.setFullNameParent(tempNamedNode);
                governor = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) || Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? this.template.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE) : this.template.getExpressionGovernor(timestamp, expectedValue);
                if (governor == null) {
                    this.setIsErroneous(true);
                } else {
                    this.template.setMyGovernor(governor);
                    TTCN3Template last = this.template.getTemplateReferencedLast(timestamp, referenceChain);
                    if (last.getIsErroneous(timestamp)) {
                        this.setIsErroneous(true);
                    }
                }
                if (Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) || Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue)) break;
                if (Expected_Value_type.EXPECTED_CONSTANT.equals((Object)expectedValue)) {
                    this.template.getLocation().reportSemanticError(MessageFormat.format(CONSTANTREFERENCEEXPECTED, assignment.getDescription()));
                } else {
                    this.template.getLocation().reportSemanticError(MessageFormat.format(STATICREFERENCEEXPECTED, assignment.getDescription()));
                }
                this.setIsErroneous(true);
                break;
            }
            default: {
                tempReference.getLocation().reportSemanticError(MessageFormat.format(VALUETEMPLATEEXPECTED, assignment.getDescription()));
                this.setIsErroneous(true);
                return;
            }
        }
        if (governor != null && !(governor = governor.getTypeRefdLast(timestamp)).getIsErroneous(timestamp)) {
            CompField field = null;
            switch (governor.getTypetype()) {
                case TYPE_ASN1_CHOICE: {
                    if (!((ASN1_Choice_Type)governor).hasComponentWithName(this.identifier)) break;
                    field = ((ASN1_Choice_Type)governor).getComponentByName(this.identifier);
                    break;
                }
                case TYPE_TTCN3_CHOICE: {
                    if (!((TTCN3_Choice_Type)governor).hasComponentWithName(this.identifier.getName())) break;
                    field = ((TTCN3_Choice_Type)governor).getComponentByName(this.identifier.getName());
                    break;
                }
                case TYPE_OPENTYPE: {
                    if (!((Open_Type)governor).hasComponentWithName(this.identifier)) break;
                    field = ((Open_Type)governor).getComponentByName(this.identifier);
                    break;
                }
                case TYPE_ANYTYPE: {
                    if (!((Anytype_Type)governor).hasComponentWithName(this.identifier.getName())) break;
                    field = ((Anytype_Type)governor).getComponentByName(this.identifier.getName());
                    break;
                }
                default: {
                    this.location.reportSemanticError(MessageFormat.format(OPERANDERROR, governor.getTypename()));
                    this.setIsErroneous(true);
                    return;
                }
            }
            if (null == field) {
                this.location.reportSemanticError(MessageFormat.format(MISSINGFIELD, governor.getTypename(), this.identifier.getDisplayName()));
                this.setIsErroneous(true);
            }
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        boolean result;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.reference == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.value == null) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        IValue last = this.value.getValueRefdLast(timestamp, referenceChain);
        switch (last.getValuetype()) {
            case CHOICE_VALUE: {
                result = ((Choice_Value)last).fieldIsChosen(this.identifier);
                break;
            }
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.CHOICE_VALUE);
                result = ((Choice_Value)last).fieldIsChosen(this.identifier);
                break;
            }
            case ANYTYPE_VALUE: {
                result = ((Anytype_Value)last).fieldIsChosen(timestamp, this.identifier);
                break;
            }
            default: {
                this.setIsErroneous(true);
                return last;
            }
        }
        this.lastValue = new Boolean_Value(result);
        this.lastValue.copyGeneralProperties(this);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        this.checkExpressionOperands(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, referenceChain);
        if (referenceChain.add(this)) {
            referenceChain.markState();
            if (this.value != null) {
                this.value.checkRecursions(timestamp, referenceChain);
            }
            if (this.template != null) {
                this.template.checkRecursions(timestamp, referenceChain);
            }
            referenceChain.previousState();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.reference != null) {
            this.reference.updateSyntax(reparser, false);
            reparser.updateLocation(this.reference.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.reference == null) {
            return;
        }
        this.reference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.value != null) {
            this.value.reArrangeInitCode(aData, source, usageModule);
        }
        if (this.template != null) {
            this.template.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return false;
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        String field;
        String genNameValue;
        Reference reference;
        if (this.value != null && (reference = this.value.getReference()) != null) {
            genNameValue = this.value.getMyGovernor().getGenNameValue(aData, expression.expression);
            field = MessageFormat.format("{0}.union_selection_type.ALT_{1}", genNameValue, FieldSubReference.getJavaGetterName(this.identifier.getName()));
            reference.generateCodeIsPresentBoundChosen(aData, expression, false, this.getOperationType(), field);
        }
        if (this.template != null && (reference = this.template.getReference()) != null) {
            genNameValue = this.template.getMyGovernor().getGenNameValue(aData, expression.expression);
            field = MessageFormat.format("{0}.union_selection_type.ALT_{1}", genNameValue, FieldSubReference.getJavaGetterName(this.identifier.getName()));
            reference.generateCodeIsPresentBoundChosen(aData, expression, true, this.getOperationType(), field);
        }
    }
}

