/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;

public abstract class SelectionMethodBase {
    protected List<Module> allModules;
    protected List<Module> modulesToCheck;
    protected List<Module> modulesToSkip;
    protected List<String> semanticallyChecked;
    protected long start;
    protected long end;
    protected boolean writeDebugInfo;
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS", Locale.US);
    protected String format = "%s %s";
    protected String header;
    protected String footer;

    public List<Module> getModulesToCheck() {
        return this.modulesToCheck;
    }

    public List<Module> getModulesToSkip() {
        return this.modulesToSkip;
    }

    public void setModules(List<Module> allModules, List<String> semanticallyChecked) {
        this.modulesToCheck = new ArrayList<Module>();
        this.modulesToSkip = new ArrayList<Module>();
        this.allModules = new ArrayList<Module>(allModules);
        this.semanticallyChecked = semanticallyChecked;
    }

    protected SelectionMethodBase() {
        this.writeDebugInfo = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
    }

    protected void afterExecute() {
        for (Module module : this.allModules) {
            if (this.modulesToCheck.contains(module) || this.modulesToSkip.contains(module)) continue;
            this.modulesToSkip.add(module);
        }
    }

    protected void infoAfterExecute() {
        TITANDebugConsole.println("**Selection time is:     " + (double)this.end * 1.0E-9 + " seconds (" + this.end + " nanoseconds).");
        TITANDebugConsole.println("**Nr. of broken modules: " + this.modulesToCheck.size());
        TITANDebugConsole.println("**Broken modules name:   " + this.modulesToCheck);
        TITANDebugConsole.println(new String[0]);
    }
}

