/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.parsers.FileSaveTracker;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.PlatformUI;

public final class GlobalDeltaVisitor
implements IResourceDeltaVisitor {
    private final IProject project;
    private final IContainer[] workingDirectories;
    private final List<IFile> outdatedFiles = new ArrayList<IFile>();

    public GlobalDeltaVisitor(IProject project) {
        this.project = project;
        boolean reportError = PlatformUI.isWorkbenchRunning();
        this.workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryResources(reportError);
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource.getName().startsWith(".")) {
            return false;
        }
        switch (resource.getType()) {
            case 1: {
                if (delta.getKind() == 2) {
                    IFile file = (IFile)resource;
                    if (FileSaveTracker.isFileBeingSaved(file)) {
                        FileSaveTracker.fileSaved(file);
                    }
                    this.outdatedFiles.add(file);
                } else if (delta.getFlags() != 131072 && (delta.getFlags() == 2 || !resource.isAccessible() || !ResourceExclusionHelper.isDirectlyExcluded((IFile)resource) && GlobalParser.isSupportedExtension(resource.getFileExtension()))) {
                    IFile file = (IFile)resource;
                    if (FileSaveTracker.isFileBeingSaved(file)) {
                        FileSaveTracker.fileSaved(file);
                    } else {
                        this.outdatedFiles.add(file);
                    }
                }
                return false;
            }
            case 2: {
                for (IContainer workingDirectory : this.workingDirectories) {
                    if (!workingDirectory.equals(resource)) continue;
                    return false;
                }
                if (!resource.isAccessible() || resource.getLocation() == null) {
                    return true;
                }
                if (!ResourceExclusionHelper.isDirectlyExcluded((IFolder)resource)) break;
                return false;
            }
        }
        return true;
    }

    public WorkspaceJob[] reportOutdatedFiles() {
        WorkspaceJob[] jobs = new WorkspaceJob[2];
        if (!this.outdatedFiles.isEmpty()) {
            jobs[0] = GlobalParser.getProjectSourceParser(this.project).reportOutdating(this.outdatedFiles);
            jobs[1] = GlobalParser.getConfigSourceParser(this.project).reportOutdating(this.outdatedFiles);
        }
        return jobs;
    }
}

