/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.compiler.BuildTimestamp;

public class JavaGenData {
    private final Module module;
    private final StringBuilder mSrc;
    private final StringBuilder classHeader;
    private final HashSet<String> mGlobalVariablesGenerated;
    private final StringBuilder mGlobalVariables;
    private final StringBuilder constructor;
    private final StringBuilder preInit;
    private final StringBuilder postInit;
    private final StringBuilder setModuleParameters;
    private final StringBuilder getModuleParameters;
    private final StringBuilder logModuleParameters;
    private final StringBuilder startPTCFunction;
    private final StringBuilder executeTestcase;
    private final StringBuilder executeAllTestcases;
    private final StringBuilder initComp;
    private final StringBuilder initSystemPort;
    private final StringBuilder listTestcases;
    private final StringBuilder listModulePars;
    private final Set<String> mImports;
    private final Set<String> mInternalImports;
    private final Set<String> mInterModuleImports;
    private final HashMap<String, StringBuilder> types;
    private final HashMap<String, String> typeConversionFunctions;
    private boolean allowOmitInValueList = false;
    private boolean legacyCodecHandling = false;
    private boolean rawDisabled = false;
    private boolean jsonDisabled = false;
    private boolean addSourceInfo = false;
    private boolean forceGenSeof = false;
    public HashMap<String, String> attibute_registry;
    private boolean mDebug;
    private int tempVariableCounter = 0;
    public BuildTimestamp buildTimestamp;

    public JavaGenData(Module module, BuildTimestamp timestamp) {
        this.module = module;
        this.buildTimestamp = timestamp;
        this.mSrc = new StringBuilder();
        this.classHeader = new StringBuilder();
        this.mGlobalVariablesGenerated = new HashSet();
        this.mGlobalVariables = new StringBuilder();
        this.attibute_registry = new HashMap();
        this.constructor = new StringBuilder();
        this.preInit = new StringBuilder();
        this.postInit = new StringBuilder();
        this.setModuleParameters = new StringBuilder();
        this.getModuleParameters = new StringBuilder();
        this.logModuleParameters = new StringBuilder();
        this.startPTCFunction = new StringBuilder();
        this.executeTestcase = new StringBuilder();
        this.executeAllTestcases = new StringBuilder();
        this.initComp = new StringBuilder();
        this.initSystemPort = new StringBuilder();
        this.listTestcases = new StringBuilder();
        this.listModulePars = new StringBuilder();
        this.mImports = new TreeSet<String>();
        this.mInternalImports = new TreeSet<String>();
        this.mInterModuleImports = new TreeSet<String>();
        this.mDebug = false;
        this.types = new HashMap();
        this.typeConversionFunctions = new HashMap();
    }

    public void collectProjectSettings(Location location) {
        if (location == null || location instanceof NULL_Location) {
            return;
        }
        IResource f = location.getFile();
        if (f == null) {
            return;
        }
        IProject project = f.getProject();
        if (project == null) {
            return;
        }
        try {
            String s = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "omitInValueList"));
            this.allowOmitInValueList = s == null || "true".equals(s);
            s = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceGenSeof"));
            this.forceGenSeof = s != null && "true".equals(s);
            s = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableRAW"));
            this.rawDisabled = s == null || "true".equals(s);
            s = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableJSON"));
            this.jsonDisabled = s == null || "true".equals(s);
            this.legacyCodecHandling = false;
            s = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "addSourceLineInfo"));
            this.addSourceInfo = s == null || "true".equals(s);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
    }

    public StringBuilder getCodeForType(String typeName) {
        if (this.types.containsKey(typeName)) {
            return this.types.get(typeName);
        }
        StringBuilder temp = new StringBuilder();
        this.types.put(typeName, temp);
        return temp;
    }

    public Module getModuleScope() {
        return this.module;
    }

    public StringBuilder getSrc() {
        return this.mSrc;
    }

    public StringBuilder getClassHeader() {
        return this.classHeader;
    }

    public boolean hasGlobalVariable(String name) {
        return this.mGlobalVariablesGenerated.contains(name);
    }

    public void addGlobalVariable(String name, String code) {
        this.mGlobalVariablesGenerated.add(name);
        this.mGlobalVariables.append(code);
    }

    StringBuilder getGlobalVariables() {
        return this.mGlobalVariables;
    }

    public StringBuilder getConstructor() {
        return this.constructor;
    }

    public StringBuilder getPreInit() {
        return this.preInit;
    }

    public StringBuilder getPostInit() {
        return this.postInit;
    }

    public StringBuilder getSetModuleParameters() {
        return this.setModuleParameters;
    }

    public StringBuilder getGetModuleParameters() {
        return this.getModuleParameters;
    }

    public StringBuilder getLogModuleParameters() {
        return this.logModuleParameters;
    }

    public StringBuilder getStartPTCFunction() {
        return this.startPTCFunction;
    }

    public StringBuilder getExecuteTestcase() {
        return this.executeTestcase;
    }

    public StringBuilder getExecuteAllTestcase() {
        return this.executeAllTestcases;
    }

    public StringBuilder getInitComp() {
        return this.initComp;
    }

    public StringBuilder getInitSystemPort() {
        return this.initSystemPort;
    }

    public StringBuilder getListTestcases() {
        return this.listTestcases;
    }

    public StringBuilder getListModulePars() {
        return this.listModulePars;
    }

    public void addImport(String aNewImport) {
        this.mImports.add(aNewImport);
    }

    public void addBuiltinTypeImport(String aNewImport) {
        this.mInternalImports.add(aNewImport);
    }

    public void addCommonLibraryImport(String aNewImport) {
        this.mInternalImports.add(aNewImport);
    }

    public void addInterModuleImport(String aNewImport) {
        this.mInterModuleImports.add(aNewImport);
    }

    public Set<String> getImports() {
        return this.mImports;
    }

    public HashMap<String, StringBuilder> getTypes() {
        return this.types;
    }

    public HashMap<String, String> getTypesConversions() {
        return this.typeConversionFunctions;
    }

    public Set<String> getInternalImports() {
        return this.mInternalImports;
    }

    public Set<String> getInterModuleImports() {
        return this.mInterModuleImports;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean aDebug) {
        this.mDebug = aDebug;
    }

    public BuildTimestamp getBuildTimstamp() {
        return this.buildTimestamp;
    }

    public String getTemporaryVariableName() {
        StringBuilder builder = new StringBuilder("tmp_");
        ++this.tempVariableCounter;
        builder.append(this.tempVariableCounter);
        return builder.toString();
    }

    public boolean getAllowOmitInValueList() {
        return this.allowOmitInValueList;
    }

    public boolean getForceGenSeof() {
        return this.forceGenSeof;
    }

    public boolean getEnableRaw() {
        return !this.rawDisabled;
    }

    public boolean getEnableJson() {
        return !this.jsonDisabled;
    }

    public boolean getAddSourceInfo() {
        return this.addSourceInfo;
    }

    public boolean getLegacyCodecHandling() {
        return this.legacyCodecHandling;
    }

    public boolean hasTypeConversion(String functionName) {
        return this.typeConversionFunctions.containsKey(functionName);
    }

    public void addTypeConversion(String functionName, String functionBody) {
        if (!this.typeConversionFunctions.containsKey(functionName)) {
            this.typeConversionFunctions.put(functionName, functionBody);
        }
    }
}

