/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.BreadcrumbTreeContentProvider;
import org.eclipse.titan.designer.editors.BreadcrumbTreeItem;
import org.eclipse.titan.designer.editors.BreadcumbTreeStyledLabelProvider;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class Breadcrumb {
    private static final int BUTTON_MARGIN = 5;
    private static final int BUTTON_TEXT_MARGIN = 3;
    private static Image FolderImage;
    private static Image TTCN3Image;
    private static Image TTCNPPImage;
    private static Image ASN1Image;
    private final Composite parent;
    private final Composite composite;
    private PaintListener paintListener;
    private final List<Control> dynamicElements;
    private boolean isEnabled;
    private GridData layoutData;
    private Shell shell;
    private TreeViewer treeViewer;

    public Breadcrumb(Composite parent) {
        this.composite = new Composite(parent, 0);
        RowLayout rowlayout = new RowLayout();
        rowlayout.marginHeight = 0;
        rowlayout.marginWidth = 0;
        rowlayout.marginLeft = 0;
        rowlayout.marginRight = 0;
        this.composite.setLayout((Layout)rowlayout);
        this.layoutData = new GridData(4, 4, true, false);
        this.composite.setLayoutData((Object)this.layoutData);
        this.composite.addPaintListener(e -> {
            Point point = this.composite.computeSize(-1, -1);
            point.x = parent.getSize().x;
            this.composite.setBackground(ColorManager.getBreadcrumbColor());
            this.composite.layout();
            this.composite.setSize(point);
        });
        this.dynamicElements = new ArrayList<Control>();
        this.parent = parent;
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(Breadcrumb.this.composite.getBackground());
                e.gc.setForeground(Breadcrumb.this.composite.getForeground());
                e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                Button button = (Button)e.getSource();
                Image image = button.getImage();
                String text = button.getText();
                int fontSize = e.gc.textExtent((String)text).y;
                int imageHeight = image != null ? image.getBounds().height : 0;
                int imageWidth = image != null ? image.getBounds().width : 0;
                int buttonHeight = button.getBounds().height;
                if (image != null) {
                    e.gc.drawImage(image, 5, (buttonHeight - imageHeight) / 2);
                }
                if (text != null && text.length() != 0) {
                    e.gc.drawText(text, imageWidth + 5 + (image != null ? 3 : 0), (buttonHeight - fontSize) / 2);
                }
            }
        };
    }

    public void changeParentViewerLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.parent.setLayout((Layout)layout);
    }

    public void updateSourceViewerLayout() {
        if (this.parent.isDisposed()) {
            return;
        }
        Control[] children = this.parent.getChildren();
        if (children.length < 2) {
            return;
        }
        for (Control child : children) {
            if (child != this.composite) {
                child.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                continue;
            }
            this.layoutData.exclude = !this.isEnabled;
        }
        this.composite.layout();
        this.parent.layout();
    }

    private Button addButton(String text, String imageName) {
        return this.addButton(text, ImageCache.getImage(imageName));
    }

    private Button addButton(String text, Image image) {
        return this.addButton(text, image, null);
    }

    private Button addButton(String text, Image image, Object data) {
        final Button button = new Button(this.composite, 8);
        button.setData(data);
        button.addPaintListener(this.paintListener);
        if (image != null) {
            button.setImage(image);
        }
        button.setText(text);
        Point size = button.computeSize(-1, -1);
        button.setSize(size);
        button.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Rectangle buttonPos = button.getBounds();
                Point realLocation = Breadcrumb.this.parent.getDisplay().map((Control)Breadcrumb.this.parent, null, buttonPos.x, buttonPos.y);
                Breadcrumb.this.shell = new Shell(Breadcrumb.this.composite.getShell(), 16404);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                Breadcrumb.this.shell.setLayout((Layout)layout);
                Composite fcomposite = new Composite((Composite)Breadcrumb.this.shell, 0);
                fcomposite.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout gridLayout = new GridLayout(1, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                fcomposite.setLayout((Layout)gridLayout);
                Breadcrumb.this.treeViewer = new TreeViewer(fcomposite, 770);
                Breadcrumb.this.treeViewer.setContentProvider((IContentProvider)new BreadcrumbTreeContentProvider());
                Breadcrumb.this.treeViewer.setLabelProvider((IBaseLabelProvider)new BreadcumbTreeStyledLabelProvider());
                Breadcrumb.this.treeViewer.setInput(button.getData());
                Breadcrumb.this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        BreadcrumbTreeItem item;
                        TreeSelection selection;
                        if (event.getSelection() instanceof TreeSelection && (selection = (TreeSelection)event.getSelection()).getFirstElement() instanceof BreadcrumbTreeItem && !(item = (BreadcrumbTreeItem)selection.getFirstElement()).isDirectory() && item.getData() instanceof File) {
                            File selected = (File)item.getData();
                            URI uri = selected.toURI();
                            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
                            if (files.length > 0) {
                                IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                IWorkbenchPage page = targetEditor.getSite().getPage();
                                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(files[0].getName());
                                try {
                                    IEditorPart iEditorPart = page.openEditor((IEditorInput)new FileEditorInput(files[0]), desc.getId());
                                }
                                catch (PartInitException partInitException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                });
                Tree tree = (Tree)Breadcrumb.this.treeViewer.getControl();
                tree.setLayoutData((Object)new GridData(4, 4, true, true));
                Breadcrumb.this.shell.setBounds(new Rectangle(realLocation.x, realLocation.y + buttonPos.height, 200, 200));
                Breadcrumb.this.shell.setVisible(true);
                Breadcrumb.this.installCloser(Breadcrumb.this.shell);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return button;
    }

    private Button addTextButton(String text) {
        Button button = new Button(this.composite, 8);
        button.addPaintListener(this.paintListener);
        button.setText(text);
        Point size = button.computeSize(-1, -1);
        button.setSize(size);
        return button;
    }

    public void addBaseElement(String text) {
        this.addBaseElement(text, null, null);
    }

    public void addBaseElement(String text, Image image, Object data) {
        this.addArrowButton();
        this.addButton(text, image, data);
    }

    public void clearDynamicElements() {
        for (Control dynbutton : this.dynamicElements) {
            dynbutton.dispose();
        }
        this.dynamicElements.clear();
    }

    public void addDynamicElement(Declaration declaration) {
        ArrayList<Scope> tree = new ArrayList<Scope>();
        Assignment assignment = declaration.getAssignment();
        if (assignment == null) {
            return;
        }
        for (Scope scope = assignment.getMyScope(); scope != null && !(scope instanceof Module); scope = scope.getParentScope()) {
            tree.add(scope);
        }
        for (int i = tree.size(); i > 0; --i) {
            Scope parentScope = (Scope)tree.get(i - 1);
            Assignment info = parentScope.getScopeBreadcrumbDefinition();
            if (info == null) continue;
            this.addArrowButton(true);
            Button parentButton = this.addButton(info.getIdentifier().getDisplayName(), info.getOutlineIcon());
            this.dynamicElements.add((Control)parentButton);
        }
        Point point = this.composite.computeSize(-1, -1);
        this.composite.layout();
        this.composite.setSize(point);
    }

    private void addArrowButton() {
        this.addArrowButton(false);
    }

    private void addArrowButton(boolean isDynamic) {
        Button arrowButton = this.addTextButton(">");
        if (isDynamic) {
            this.dynamicElements.add((Control)arrowButton);
        }
    }

    public void buildFilePath(IEditorInput input) {
        StringBuilder pathpart = new StringBuilder();
        IFile file = (IFile)input.getAdapter(IFile.class);
        IProject project = file.getProject();
        IPath container = project.getLocation();
        IPath fileLocation = file.getLocation();
        int containerSegments = container.segmentCount();
        this.addBaseElement(project.getName(), ImageCache.getImage("titan.gif"), null);
        pathpart.append(container);
        pathpart.append('/');
        IPath path = file.getFullPath();
        for (int i = containerSegments; i < fileLocation.segmentCount(); ++i) {
            String segment = fileLocation.segment(i);
            pathpart.append(segment);
            pathpart.append('/');
            Path elementPath = new Path(pathpart.toString());
            if (i != fileLocation.segmentCount() - 1) {
                this.addBaseElement(segment, FolderImage, elementPath);
                continue;
            }
            if (segment.matches(".*[.][Tt][Tt][Cc][Nn]3?$")) {
                this.addBaseElement(segment, TTCN3Image, elementPath);
                continue;
            }
            if (segment.matches(".*[.][Tt][Tt][Cc][Nn][Pp][Pp]$")) {
                this.addBaseElement(segment, TTCNPPImage, elementPath);
                continue;
            }
            if (!segment.matches(".*[.][Aa][Ss][Nn]1?$")) continue;
            this.addBaseElement(segment, ASN1Image, elementPath);
        }
    }

    public void setEnabled(boolean isEnabled) {
        if (this.composite.isDisposed()) {
            return;
        }
        this.composite.setVisible(isEnabled);
        this.isEnabled = isEnabled;
    }

    private void installCloser(Shell shell) {
        Listener focusListener = event -> {
            Widget focusedElement = event.widget;
            boolean isFocused = focusedElement == shell || focusedElement instanceof Tree;
            switch (event.type) {
                case 15: {
                    if (!isFocused) {
                        shell.close();
                    }
                }
                case 16: {
                    if (event.display.getActiveShell() != null) break;
                    shell.close();
                }
            }
        };
        Display display = shell.getDisplay();
        display.addFilter(15, focusListener);
        display.addFilter(16, focusListener);
        shell.addDisposeListener(event -> {
            display.removeFilter(15, focusListener);
            display.removeFilter(16, focusListener);
        });
    }

    static {
        ISharedImages shared = PlatformUI.getWorkbench().getSharedImages();
        FolderImage = shared.getImage("IMG_OBJ_FOLDER");
        TTCN3Image = ImageCache.getImage("ttcn.gif");
        TTCNPPImage = ImageCache.getImage("ttcnpp.gif");
        ASN1Image = ImageCache.getImage("asn.gif");
    }
}

