/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;

public final class OpenDeclarationHelper {
    public static final String NORECOGNISABLEFILE = "The file related to the editor could not be identified";
    public static final String NORECOGNISABLEREFERENCE = "Current text selection does not resolve to a TTCN3 reference";
    public static final String NORECOGNISABLESCOPE = "The reference does not seem to be in a valid scope";
    public static final String NORECOGNISABLEMODULENAME = "The name of the module in the file `{0}'' could not be identified";
    public static final String EXCLUDEDFROMBUILD = "The name of the module in the file `{0}'' could not be identified, the file is excluded from build";
    public static final String NOTFOUNDMODULE = "The module `{0}'' could not be found";

    private OpenDeclarationHelper() {
    }

    public static DeclarationCollector findVisibleDeclarations(IEditorPart targetEditor, IReferenceParser referenceParser, IDocument document, int offset) {
        return OpenDeclarationHelper.findVisibleDeclarations(targetEditor, referenceParser, document, offset, true);
    }

    public static DeclarationCollector findVisibleDeclarations(IEditorPart targetEditor, IReferenceParser referenceParser, IDocument document, int offset, boolean reportErrors) {
        IFile file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            if (reportErrors) {
                ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)NORECOGNISABLEFILE);
            }
            return null;
        }
        Reference reference = null;
        referenceParser.setErrorReporting(reportErrors);
        reference = referenceParser.findReferenceForOpening(file, offset, document);
        if (reference == null) {
            if (reportErrors) {
                ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)NORECOGNISABLEREFERENCE);
            }
            return null;
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        if (ResourceExclusionHelper.isExcluded((IResource)file)) {
            ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)MessageFormat.format(EXCLUDEDFROMBUILD, file.getFullPath()));
            return null;
        }
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule == null) {
            if (reportErrors) {
                ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)MessageFormat.format(NOTFOUNDMODULE, file.getFullPath()));
            }
            return null;
        }
        Scope scope = tempModule.getSmallestEnclosingScope(offset);
        if (scope == null) {
            if (reportErrors) {
                ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)NORECOGNISABLESCOPE);
            }
            return null;
        }
        reference.setMyScope(scope);
        reference.detectModid();
        if (reference.getId() == null) {
            if (reportErrors) {
                ErrorReporter.parallelDisplayInStatusLine((IEditorPart)targetEditor, (String)NORECOGNISABLEREFERENCE);
            }
            return null;
        }
        DeclarationCollector declarationCollector = new DeclarationCollector(reference);
        scope.addDeclaration(declarationCollector);
        return declarationCollector;
    }
}

