/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.titan.designer.editors.asn1editor.PartitionScanner;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class DocumentSetupParticipant
implements IDocumentSetupParticipant {
    private final ASN1Editor editor;

    public DocumentSetupParticipant(ASN1Editor editor) {
        this.editor = editor;
    }

    public void setup(final IDocument document) {
        EditorTracker.remove(this.editor);
        EditorTracker.put((IFile)this.editor.getEditorInput().getAdapter(IFile.class), this.editor);
        DocumentTracker.put((IFile)this.editor.getEditorInput().getAdapter(IFile.class), document, this.editor);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PartitionScanner(), PartitionScanner.PARTITION_TYPES);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner("__asn1_partitioning", (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        partitioner.connect(document);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                GlobalIntervalHandler.putInterval(event.getDocument(), null);
            }

            public void documentChanged(DocumentEvent event) {
                IPreferencesService prefs = Platform.getPreferencesService();
                if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
                    DocumentSetupParticipant.this.analyze(document, false);
                }
            }
        });
        this.analyze(document, true);
    }

    void analyze(IDocument document, boolean isInitial) {
        IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(project);
        projectSourceParser.reportOutdating(editedFile);
        if (isInitial || !this.editor.isSemanticCheckingDelayed()) {
            projectSourceParser.analyzeAll();
        } else {
            projectSourceParser.reportSyntacticOutdatingOnly(editedFile);
            projectSourceParser.analyzeAllOnlySyntactically();
        }
    }
}

