/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ComponentSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigItemTransferBase;

public final class ComponentItemTransfer
extends ConfigItemTransferBase {
    private static ComponentItemTransfer instance = new ComponentItemTransfer();
    private static final String TYPE_NAME = "TITAN-ComponentItem-transfer-format";
    private static final int TYPEID = ComponentItemTransfer.registerType((String)"TITAN-ComponentItem-transfer-format");

    public static ComponentItemTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        ComponentSectionHandler.Component[] items = (ComponentSectionHandler.Component[])object;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(items.length);
            for (int i = 0; i < items.length; ++i) {
                out.writeUTF(this.convertToString(items[i].getRoot()));
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    protected ComponentSectionHandler.Component[] nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            ComponentSectionHandler.Component[] items = new ComponentSectionHandler.Component[n];
            for (int i = 0; i < n; ++i) {
                items[i] = new ComponentSectionHandler.Component();
                ParserRuleContext root = new ParserRuleContext();
                items[i].setRoot((ParseTree)root);
                String hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String componentName = in.readUTF();
                AddedParseTree componentNameNode = new AddedParseTree(componentName);
                items[i].setComponentName((ParseTree)componentNameNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)componentNameNode);
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(":="));
                hiddenBefore = in.readUTF();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)hiddenBefore));
                String hostName = in.readUTF();
                AddedParseTree hostNameNode = new AddedParseTree(hostName);
                items[i].setHostName((ParseTree)hostNameNode);
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)hostNameNode);
            }
            return items;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return new ComponentSectionHandler.Component[0];
        }
    }
}

