/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.IncludeSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.include.IncludeSectionDropTargetListener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class IncludeSubPage {
    private Label totalIncludeElementsLabel;
    private Table includeElementsTable;
    private TableViewer includeElementsTableViewer;
    private final ConfigEditor editor;
    private IncludeSectionHandler includeSectionHandler;
    private Button add;
    private Button remove;

    public IncludeSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createIncludeSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 386);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.includeElementsTable = toolkit.createTable(client, 66306);
        this.includeElementsTable.setEnabled(this.includeSectionHandler != null);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.includeElementsTable.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.includeElementsTable, 16384, 0);
        column.setText("File name");
        column.setMoveable(false);
        column.setWidth(100);
        this.includeElementsTable.setLinesVisible(true);
        this.includeElementsTable.setHeaderVisible(true);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setEnabled(this.includeSectionHandler != null);
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParseTree newItem;
                if (IncludeSubPage.this.includeSectionHandler == null) {
                    return;
                }
                if (IncludeSubPage.this.includeSectionHandler.getLastSectionRoot() == null) {
                    IncludeSubPage.this.createNewIncludeSection();
                }
                if ((newItem = IncludeSubPage.this.createNewIncludeItem()) == null) {
                    return;
                }
                ParserRuleContext root = IncludeSubPage.this.includeSectionHandler.getLastSectionRoot();
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
                ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)newItem);
                IncludeSubPage.this.includeSectionHandler.getFiles().add(newItem);
                IncludeSubPage.this.internalRefresh();
                IncludeSubPage.this.includeElementsTable.select(IncludeSubPage.this.includeSectionHandler.getFiles().size() - 1);
                IncludeSubPage.this.includeElementsTable.showSelection();
                IncludeSubPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.includeSectionHandler != null);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IncludeSubPage.this.includeElementsTableViewer == null || IncludeSubPage.this.includeSectionHandler == null) {
                    return;
                }
                IncludeSubPage.this.removeSelectedIncludeItems();
                if (IncludeSubPage.this.includeSectionHandler.getFiles().isEmpty()) {
                    IncludeSubPage.this.removeIncludeSection();
                }
                IncludeSubPage.this.internalRefresh();
                IncludeSubPage.this.editor.setDirty();
            }
        });
        this.totalIncludeElementsLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalIncludeElementsLabel.setLayoutData((Object)gd);
        section.setText("Included configurations");
        section.setDescription("Specify the list of included configuration files for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(768);
        section.setLayoutData((Object)gd);
        this.includeElementsTableViewer = new TableViewer(this.includeElementsTable);
        this.includeElementsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.includeElementsTableViewer.setContentProvider((IContentProvider)new IncludeDataContentProvider());
        this.includeElementsTableViewer.setLabelProvider((IBaseLabelProvider)new IncludeDataLabelProvider());
        this.includeElementsTableViewer.setInput((Object)this.includeSectionHandler);
        this.includeElementsTableViewer.setColumnProperties(new String[]{"file_name"});
        this.includeElementsTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.includeElementsTable)});
        this.includeElementsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                IncludeDataLabelProvider labelProvider = (IncludeDataLabelProvider)IncludeSubPage.this.includeElementsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, 0);
            }

            public void modify(Object element, String property, Object value) {
                if (element != null && element instanceof TableItem && value instanceof String) {
                    ParseTree item = (ParseTree)((TableItem)element).getData();
                    ConfigTreeNodeUtilities.setText((ParseTree)item, (String)((String)value));
                    IncludeSubPage.this.includeElementsTableViewer.refresh((Object)item);
                    IncludeSubPage.this.editor.setDirty();
                }
            }
        });
        this.includeElementsTableViewer.addDragSupport(3, new Transfer[]{IncludeItemTransfer.getInstance()}, (DragSourceListener)new IncludeSectionDragSourceListener(this, this.includeElementsTableViewer));
        this.includeElementsTableViewer.addDropSupport(19, new Transfer[]{IncludeItemTransfer.getInstance()}, (DropTargetListener)new IncludeSectionDropTargetListener(this.includeElementsTableViewer, this.editor));
        this.internalRefresh();
    }

    private void internalRefresh() {
        this.add.setEnabled(this.includeSectionHandler != null);
        this.remove.setEnabled(this.includeSectionHandler != null);
        this.includeElementsTable.setEnabled(this.includeSectionHandler != null);
        this.includeElementsTableViewer.setInput((Object)this.includeSectionHandler);
        if (this.includeSectionHandler != null) {
            this.totalIncludeElementsLabel.setText("Total: " + this.includeSectionHandler.getFiles().size());
        }
    }

    public void refreshData(IncludeSectionHandler includeSectionHandler) {
        this.includeSectionHandler = includeSectionHandler;
        if (this.includeElementsTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IncludeSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewIncludeSection() {
        if (this.includeSectionHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.includeSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[INCLUDE]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private ParseTree createNewIncludeItem() {
        if (this.includeSectionHandler == null) {
            return null;
        }
        return new AddedParseTree("\"included_file\"");
    }

    private void removeIncludeSection() {
        if (this.includeSectionHandler == null || this.includeSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.includeSectionHandler.getLastSectionRoot());
        this.includeSectionHandler.setLastSectionRoot((ParserRuleContext)null);
    }

    public void removeSelectedIncludeItems() {
        if (this.includeElementsTableViewer == null || this.includeSectionHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.includeElementsTableViewer.getSelection();
        for (ParseTree item : selection) {
            if (item == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.includeSectionHandler.getLastSectionRoot(), (ParseTree)item);
            this.includeSectionHandler.getFiles().remove(item);
        }
    }
}

