/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.designer.editors.ttcn3editor.PairMatcher;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class GotoMatchingBracketAction
extends AbstractHandler
implements IEditorActionDelegate {
    private TTCN3Editor targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public final void run(IAction action) {
        int carretOffset;
        TextSelection tSelection;
        if (this.targetEditor == null) {
            return;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && (tSelection = (TextSelection)this.selection).getLength() != 0) {
            return;
        }
        PairMatcher pairMatcher = new PairMatcher();
        IDocument document = this.targetEditor.getDocument();
        IRegion region = pairMatcher.match(document, carretOffset = this.targetEditor.getCarretOffset());
        if (region == null) {
            return;
        }
        int targetOffset = region.getOffset() + 1 == carretOffset ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        this.targetEditor.setCarretOffset(targetOffset);
        this.targetEditor.selectAndReveal(targetOffset, 0);
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public final void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor instanceof TTCN3Editor ? (TTCN3Editor)targetEditor : null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int carretOffset;
        TextSelection tSelection;
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.targetEditor = targetEditor instanceof TTCN3Editor ? (TTCN3Editor)targetEditor : null;
        if (targetEditor == null) {
            return null;
        }
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && (tSelection = (TextSelection)this.selection).getLength() != 0) {
            return null;
        }
        PairMatcher pairMatcher = new PairMatcher();
        IDocument document = this.targetEditor.getDocument();
        IRegion region = pairMatcher.match(document, carretOffset = this.targetEditor.getCarretOffset());
        if (region == null) {
            return null;
        }
        int targetOffset = region.getOffset() + 1 == carretOffset ? region.getOffset() + region.getLength() : region.getOffset() + 1;
        this.targetEditor.setCarretOffset(targetOffset);
        this.targetEditor.selectAndReveal(targetOffset, 0);
        return null;
    }
}

