/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Timer;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.Stylers;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3ReferenceParser;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.CompletionFinder;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public final class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final String STANDARD_ERROR_MESSAGE = "No completions available.";
    private final AbstractDecoratedTextEditor editor;
    private final String sortingpolicy;
    private int proposalListSize;
    private int numberOfComputedResults = 0;
    private String errorMessage = null;
    private final String partition;

    public ContentAssistProcessor(AbstractDecoratedTextEditor editor, String partition) {
        this.editor = editor;
        this.partition = partition;
        this.sortingpolicy = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.proposalSorting");
        this.proposalListSize = Activator.getDefault().getPreferenceStore().getInt("org.eclipse.titan.designer.proposalListSize");
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals;
        IPreferencesService prefs;
        if (this.editor == null) {
            return new ICompletionProposal[0];
        }
        final IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return new ICompletionProposal[0];
        }
        if (this.editor instanceof TTCN3Editor) {
            final TTCN3Editor t3editor = (TTCN3Editor)this.editor;
            BusyIndicator.showWhile((Display)t3editor.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    t3editor.analyzeCurrentFile(file);
                }
            });
        }
        IDocument doc = viewer.getDocument();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule == null) {
            return null;
        }
        CompletionFinder cf = new CompletionFinder(tempModule);
        TemplateContextType contextType = new TemplateContextType("TTCN3_SOURCE_CODE", "TTCN3 Code Skeleton Context");
        ProposalContext onleft = cf.findOnLeft((IEditorPart)this.editor, offset, doc, file);
        if (onleft != null) {
            String prefix = onleft.getPrefix();
            int replacementOffset = onleft.proposalContextInfo.offset - prefix.length();
            ProposalCollector propCollector = new ProposalCollector(contextType, Identifier.Identifier_type.ID_TTCN, doc, prefix, replacementOffset);
            onleft.getProposals(propCollector);
            if (!onleft.doFallback()) {
                ICompletionProposal[] proposals2 = propCollector.getCompletitions(this.proposalListSize);
                this.numberOfComputedResults = proposals2.length;
                return proposals2;
            }
        }
        TTCN3ReferenceParser refParser = new TTCN3ReferenceParser(true);
        Reference ref = refParser.findReferenceForClassMemberCompletion(file, offset, doc);
        Reference oldRef = refParser.findReferenceForCompletion(file, offset, doc);
        if ((ref == null || ref.getSubreferences().isEmpty()) && oldRef == null) {
            return new ICompletionProposal[0];
        }
        Scope scope = null;
        String moduleName = null;
        if (tempModule != null) {
            moduleName = tempModule.getName();
            scope = tempModule.getSmallestEnclosingScope(refParser.getReplacementOffset());
            if (ref != null) {
                ref.setMyScope(scope);
                ref.detectModid();
            }
            if (oldRef != null) {
                oldRef.setMyScope(scope);
                oldRef.detectModid();
            }
        }
        if ((prefs = Platform.getPreferencesService()).getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
            TITANDebugConsole.println("parsed the reference: " + ref);
        }
        ProposalCollector propCollector = ref != null ? new ProposalCollector(Identifier.Identifier_type.ID_TTCN, "TTCN3_SOURCE_CODE", contextType, doc, ref, refParser.getReplacementOffset()) : new ProposalCollector(Identifier.Identifier_type.ID_TTCN, "TTCN3_SOURCE_CODE", contextType, doc, oldRef, refParser.getReplacementOffset());
        CompilationTimeStamp timestamp = tempModule.getLastCompilationTimeStamp();
        if (timestamp == null) {
            return null;
        }
        if (ref != null) {
            Assignment assignment = scope.getAssBySRef(timestamp, ref);
            if (assignment == null) {
                return null;
            }
            IType type = assignment.getType(timestamp);
            if (type != null && (type = ref.getSubreferences().size() > 1 ? type.getFieldType(timestamp, ref, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false) : type.getTypeRefdLast(timestamp)) instanceof Class_Type) {
                this.getClassProposals(tempModule, ref, scope, propCollector, offset);
            }
        }
        ref = oldRef;
        propCollector.setProjectParser(projectSourceParser);
        if (moduleName == null) {
            if (ref.getModuleIdentifier() == null) {
                Set<String> moduleNames = projectSourceParser.getKnownModuleNames();
                for (String name : moduleNames) {
                    Module module = projectSourceParser.getModuleByName(name);
                    if (module == null) continue;
                    propCollector.addProposal(name, name, ImageCache.getImage("ttcn.gif"), "module");
                    module.getAssignments().addProposal(propCollector);
                }
            } else {
                Module module = projectSourceParser.getModuleByName(ref.getModuleIdentifier().getName());
                if (module != null) {
                    module.getAssignments().addProposal(propCollector);
                }
            }
        } else if (scope != null) {
            scope.addProposal(propCollector);
        }
        propCollector.sortTillMarked();
        propCollector.markPosition();
        if (ref.getSubreferences().size() != 1) {
            if ("alphabetically".equals(this.sortingpolicy)) {
                propCollector.sortAll();
            }
            ICompletionProposal[] proposals3 = propCollector.getCompletitions();
            this.numberOfComputedResults = proposals3.length;
            return proposals3;
        }
        Set<String> knownModuleNames = projectSourceParser.getKnownModuleNames();
        for (String knownModuleName : knownModuleNames) {
            Identifier tempIdentifier = new Identifier(Identifier.Identifier_type.ID_NAME, knownModuleName);
            Module tempModule2 = projectSourceParser.getModuleByName(knownModuleName);
            propCollector.addProposal(tempIdentifier, ImageCache.getImage(tempModule2.getOutlineIcon()), "module");
        }
        propCollector.sortTillMarked();
        propCollector.markPosition();
        if (ref.getModuleIdentifier() == null) {
            if (scope == null) {
                TTCN3CodeSkeletons.addSkeletonProposals(doc, refParser.getReplacementOffset(), propCollector);
            } else {
                scope.addSkeletonProposal(propCollector);
            }
            propCollector.addTemplateProposal("refers", new Template("refers( function/altstep/testcase name )", "", propCollector.getContextIdentifier(), "refers( ${fatName} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.addTemplateProposal("derefers", new Template("derefers( function/altstep/testcase name )(parameters)", "", propCollector.getContextIdentifier(), "derefers( ${fatName} ) ( ${parameters} );", false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            propCollector.sortTillMarked();
            propCollector.markPosition();
            TTCN3CodeSkeletons.addPredefinedSkeletonProposals(doc, refParser.getReplacementOffset(), propCollector);
            if (scope == null) {
                TTCN3Keywords.addKeywordProposals(propCollector);
            } else {
                scope.addKeywordProposal(propCollector);
            }
            propCollector.sortTillMarked();
            propCollector.markPosition();
        } else {
            if (scope == null || !(scope instanceof StatementBlock)) {
                if ("alphabetically".equals(this.sortingpolicy)) {
                    propCollector.sortAll();
                }
                proposals = propCollector.getCompletitions();
                this.numberOfComputedResults = proposals.length;
                return proposals;
            }
            String fakeModule = ref.getModuleIdentifier().getName();
            if ("any component".equals(fakeModule) || "all component".equals(fakeModule)) {
                Component_Type.addAnyorAllProposal(propCollector, 0);
            } else if ("any port".equals(fakeModule) || "all port".equals(fakeModule)) {
                PortTypeBody.addAnyorAllProposal(propCollector, 0);
            } else if ("any timer".equals(fakeModule) || "all timer".equals(fakeModule)) {
                Timer.addAnyorAllProposal(propCollector, 0);
            }
        }
        if ("alphabetically".equals(this.sortingpolicy)) {
            propCollector.sortAll();
        }
        proposals = propCollector.getCompletitions();
        this.numberOfComputedResults = proposals.length;
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        if (this.partition.equals("_comment_partition_comment_type")) {
            return new char[]{'@', '<'};
        }
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.numberOfComputedResults > 0) {
            return null;
        }
        return STANDARD_ERROR_MESSAGE;
    }

    private void getClassProposals(Module module, Reference ref, Scope scope, ProposalCollector propCollector, int offset) {
        if (ref != null && scope != null) {
            Class_Type ct;
            IType fieldType;
            IType refd;
            IType type;
            CompilationTimeStamp timestamp = module.getLastCompilationTimeStamp();
            if (timestamp == null) {
                return;
            }
            Assignment assignment = scope.getAssBySRef(timestamp, ref);
            if (assignment instanceof Def_Var && (type = assignment.getType(timestamp)) != null && (refd = type.getTypeRefdLast(timestamp)) instanceof Class_Type && (fieldType = (ct = (Class_Type)refd).getFieldType(timestamp, ref, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false)) instanceof Class_Type) {
                ct = (Class_Type)fieldType;
                if (ct.getClassTypeBody() == null) {
                    return;
                }
                for (Map.Entry<String, Definition> entry : ct.getDefinitionMap().getDefinitionMap().entrySet()) {
                    String visibility;
                    IType memberType;
                    Definition d = entry.getValue();
                    String memberName = d.getIdentifier().getDisplayName();
                    if (d instanceof Def_Function) {
                        memberName.concat("()");
                    }
                    String memberTypeName = (memberType = d.getType(timestamp)) != null ? memberType.getTypename() : "";
                    Stylers.ColoredStyler styler = null;
                    switch (d.getVisibilityModifier()) {
                        case Private: {
                            styler = new Stylers.ColoredStyler(Stylers.PrivateColor);
                            visibility = "private";
                            break;
                        }
                        case Public: {
                            visibility = "public";
                            styler = new Stylers.ColoredStyler(Stylers.PublicColor);
                            break;
                        }
                        default: {
                            visibility = "protected";
                            styler = new Stylers.ColoredStyler(Stylers.ProtectedColor);
                        }
                    }
                    String context = "<i>" + visibility + "</i> <b>" + memberTypeName + "</b> " + memberName;
                    CompletionProposal cp = new CompletionProposal(memberName, offset, 0, memberName.length(), ImageCache.getImage(d.getOutlineIcon()), new StyledString(memberName), null, new Ttcn3HoverContent(context), 0);
                    cp.getStyledDisplayString().append(" \u25fc", (StyledString.Styler)styler);
                    propCollector.addProposal(cp);
                }
                propCollector.sortAll();
            }
        }
    }
}

