/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsChecker;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.BrokenPartsViaReferences;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectSourceSyntacticAnalyzer;

public class ProjectSourceSemanticAnalyzer {
    private static final String DUPLICATEMODULE = "Modules must be unique, but `{0}'' was declared multiple times";
    public static final String CIRCULARIMPORTCHAIN = "Circular import chain is not recommended: {0}";
    private final Map<IFile, Module> fileModuleMap = new ConcurrentHashMap<IFile, Module>();
    private final Map<String, Module> moduleMap = new ConcurrentHashMap<String, Module>();
    private final Map<String, Module> outdatedModuleMap = new HashMap<String, Module>();
    private final Set<String> semanticallyUptodateModules = new HashSet<String>();

    public boolean isOutdated(IFile file) {
        Module module = this.fileModuleMap.get(file);
        return module == null || !this.semanticallyUptodateModules.contains(module.getName());
    }

    Module internalGetModuleByName(String name, boolean uptodateOnly) {
        if (this.moduleMap.containsKey(name)) {
            return this.moduleMap.get(name);
        }
        if (!uptodateOnly && this.outdatedModuleMap.containsKey(name)) {
            return this.outdatedModuleMap.get(name);
        }
        return null;
    }

    Set<String> internalGetKnownModuleNames() {
        HashSet<String> temp = new HashSet<String>();
        temp.addAll(this.moduleMap.keySet());
        return temp;
    }

    Collection<Module> internalGetModules() {
        return this.moduleMap.values();
    }

    Module getModulebyFile(IFile file) {
        return this.fileModuleMap.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutdating(IFile outdatedFile, boolean useOnTheFlyParsing) {
        if (!useOnTheFlyParsing) {
            return;
        }
        Module module = this.fileModuleMap.get(outdatedFile);
        if (module == null) {
            return;
        }
        IResource moduleFile = module.getIdentifier().getLocation().getFile();
        if (!outdatedFile.equals(moduleFile)) {
            return;
        }
        String moduleName = module.getName();
        this.moduleMap.remove(moduleName);
        this.fileModuleMap.remove(moduleFile);
        Object object = this.outdatedModuleMap;
        synchronized (object) {
            this.outdatedModuleMap.put(moduleName, module);
        }
        object = this.semanticallyUptodateModules;
        synchronized (object) {
            this.semanticallyUptodateModules.remove(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSemanticOutdating(IFile outdatedFile) {
        Module module = this.fileModuleMap.get(outdatedFile);
        if (module != null) {
            Set<String> set = this.semanticallyUptodateModules;
            synchronized (set) {
                this.semanticallyUptodateModules.remove(module.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSemanticInformation() {
        Set<String> set = this.semanticallyUptodateModules;
        synchronized (set) {
            this.semanticallyUptodateModules.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removedReferencestoRemovedFiles(IFile file, String moduleName) {
        Object object = this.semanticallyUptodateModules;
        synchronized (object) {
            this.semanticallyUptodateModules.remove(moduleName);
        }
        this.moduleMap.remove(moduleName);
        this.fileModuleMap.remove(file);
        object = this.outdatedModuleMap;
        synchronized (object) {
            this.outdatedModuleMap.remove(moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeModule(String moduleName) {
        Module module = this.internalGetModuleByName(moduleName, false);
        if (module == null) {
            return;
        }
        this.fileModuleMap.remove(module.getLocation().getFile());
        Map<String, Module> map = this.outdatedModuleMap;
        synchronized (map) {
            this.outdatedModuleMap.remove(moduleName);
        }
        this.moduleMap.remove(moduleName);
    }

    public void addModule(Module module) {
        this.fileModuleMap.put((IFile)module.getLocation().getFile(), module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IStatus analyzeMultipleProjectsSemantically(List<IProject> tobeSemanticallyAnalyzed, IProgressMonitor monitor, CompilationTimeStamp compilationCounter) {
        for (IProject project : tobeSemanticallyAnalyzed) {
            if (project.isAccessible() && TITANNature.hasTITANNature(project)) continue;
            return Status.CANCEL_STATUS;
        }
        long semanticCheckStart = System.nanoTime();
        for (IProject project : tobeSemanticallyAnalyzed) {
            ProjectSourceSemanticAnalyzer semanticAnalyzer = GlobalParser.getProjectSourceParser(project).getSemanticAnalyzer();
            Map<String, Module> map = semanticAnalyzer.outdatedModuleMap;
            synchronized (map) {
                semanticAnalyzer.outdatedModuleMap.clear();
            }
            semanticAnalyzer.moduleMap.clear();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName("On-the-fly semantic checking of everything ");
        progress.subTask("Checking the importations of the modules");
        try {
            Iterator<Module> iterator;
            Iterator semanticAnalyzer;
            Ass_pard.resetAllInstanceCounters();
            HashMap<Iterator<Module>, Module> uniqueModules = new HashMap<Iterator<Module>, Module>();
            HashSet<Iterator<Module>> duplicatedModules = new HashSet<Iterator<Module>>();
            ArrayList<Module> allModules = new ArrayList<Module>();
            ArrayList<String> semanticallyChecked = new ArrayList<String>();
            for (IProject project : tobeSemanticallyAnalyzed) {
                semanticAnalyzer = GlobalParser.getProjectSourceParser(project).getSemanticAnalyzer();
                for (Module module : ((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).fileModuleMap.values()) {
                    if (!(module instanceof TTCN3Module)) continue;
                    MarkerHandler.markAllSemanticMarkersForRemoval(module.getIdentifier());
                }
            }
            Iterator<IProject> iterator2 = tobeSemanticallyAnalyzed.iterator();
            block10: while (true) {
                IProject project;
                if (!iterator2.hasNext()) {
                    int nofModulesTobeChecked = 0;
                    if (allModules.size() > semanticallyChecked.size()) {
                        BrokenPartsViaReferences selectionMethod;
                        ModuleImportationChain referenceChain = new ModuleImportationChain(CIRCULARIMPORTCHAIN, false);
                        for (Module module : allModules) {
                            if (!(module instanceof TTCN3Module)) continue;
                            List<ImportModule> imports = ((TTCN3Module)module).getImports();
                            for (ImportModule imp : imports) {
                                MarkerHandler.markAllSemanticMarkersForRemoval(imp.getLocation());
                            }
                        }
                        for (Module module : allModules) {
                            module.checkImports(compilationCounter, referenceChain, new ArrayList<Module>());
                            referenceChain.clear();
                        }
                        progress.subTask("Calculating the list of modules to be checked");
                        BrokenPartsViaReferences selectionMethodBase = selectionMethod = new BrokenPartsViaReferences(compilationCounter);
                        selectionMethodBase.setModules(allModules, semanticallyChecked);
                        selectionMethod.execute();
                        if (OutOfMemoryCheck.isOutOfMemory()) {
                            OutOfMemoryCheck.outOfMemoryEvent();
                            return Status.CANCEL_STATUS;
                        }
                        BrokenPartsChecker brokenPartsChecker = new BrokenPartsChecker(progress.newChild(1), compilationCounter, selectionMethodBase);
                        brokenPartsChecker.doChecking();
                        for (Module module2 : selectionMethodBase.getModulesToSkip()) {
                            MarkerHandler.reEnableAllMarkers((IFile)module2.getLocation().getFile());
                        }
                        nofModulesTobeChecked = selectionMethodBase.getModulesToCheck().size();
                    } else {
                        for (Module module2 : allModules) {
                            MarkerHandler.reEnableAllMarkers((IFile)module2.getLocation().getFile());
                        }
                    }
                    IPreferencesService preferenceService = Platform.getPreferencesService();
                    String option = preferenceService.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportUnsupportedConstructs", "warning", null);
                    for (IProject project2 : tobeSemanticallyAnalyzed) {
                        ProjectSourceSyntacticAnalyzer syntacticAnalyzer = GlobalParser.getProjectSourceParser(project2).getSyntacticAnalyzer();
                        for (IFile file : syntacticAnalyzer.unsupportedConstructMap.keySet()) {
                            List<TITANMarker> list = syntacticAnalyzer.unsupportedConstructMap.get(file);
                            if (list == null || !file.isAccessible()) continue;
                            for (TITANMarker marker : list) {
                                Location location = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                                location.reportConfigurableSemanticProblem(option, marker.getMessage());
                            }
                        }
                    }
                    if (preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null)) {
                        TITANDebugConsole.println("  ** Had to start checking at " + nofModulesTobeChecked + " modules. ");
                        TITANDebugConsole.println("  **On-the-fly semantic checking of projects (" + allModules.size() + " modules) took " + (double)(System.nanoTime() - semanticCheckStart) * 1.0E-9 + " seconds");
                    }
                    progress.subTask("Cleanup operations");
                    iterator = tobeSemanticallyAnalyzed.iterator();
                    break;
                }
                project = iterator2.next();
                semanticAnalyzer = GlobalParser.getProjectSourceParser(project).getSemanticAnalyzer();
                iterator = ((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).fileModuleMap.values().iterator();
                while (true) {
                    Module module;
                    if (!iterator.hasNext()) continue block10;
                    module = iterator.next();
                    Iterator<Module> name = module.getIdentifier().getName();
                    allModules.add(module);
                    if (module instanceof ASN1Module) {
                        MarkerHandler.markAllSemanticMarkersForRemoval(module.getLocation().getFile());
                    }
                    if (uniqueModules.containsKey(name)) {
                        Location location = ((Module)uniqueModules.get(name)).getIdentifier().getLocation();
                        Location location2 = module.getIdentifier().getLocation();
                        if (!URIUtil.equals((URI)location.getFile().getLocationURI(), (URI)location2.getFile().getLocationURI())) {
                            location.reportSemanticError(MessageFormat.format(DUPLICATEMODULE, module.getIdentifier().getDisplayName()));
                            location2.reportSemanticError(MessageFormat.format(DUPLICATEMODULE, module.getIdentifier().getDisplayName()));
                            duplicatedModules.add(name);
                            ((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).semanticallyUptodateModules.remove(name);
                            continue;
                        }
                        uniqueModules.put(name, module);
                        ((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).moduleMap.put((String)((Object)name), module);
                        if (!((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).semanticallyUptodateModules.contains(name)) continue;
                        semanticallyChecked.add((String)((Object)name));
                        continue;
                    }
                    uniqueModules.put(name, module);
                    ((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).moduleMap.put((String)((Object)name), module);
                    if (!((ProjectSourceSemanticAnalyzer)((Object)semanticAnalyzer)).semanticallyUptodateModules.contains(name)) continue;
                    semanticallyChecked.add((String)((Object)name));
                }
                break;
            }
            while (iterator.hasNext()) {
                IProject project2;
                project2 = (IProject)iterator.next();
                ProjectSourceSemanticAnalyzer semanticAnalyzer2 = GlobalParser.getProjectSourceParser(project2).getSemanticAnalyzer();
                Set<String> set = semanticAnalyzer2.semanticallyUptodateModules;
                synchronized (set) {
                    semanticAnalyzer2.semanticallyUptodateModules.clear();
                    semanticAnalyzer2.semanticallyUptodateModules.addAll(semanticAnalyzer2.moduleMap.keySet());
                    for (String string : duplicatedModules) {
                        semanticAnalyzer2.semanticallyUptodateModules.remove(string);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        progress.done();
        Iterator<IProject> iterator = tobeSemanticallyAnalyzed.iterator();
        while (iterator.hasNext()) {
            IProject project = iterator.next();
            ProjectSourceParser parser = GlobalParser.getProjectSourceParser(project);
            parser.setLastTimeChecked(compilationCounter);
            GlobalProjectStructureTracker.updateData(project);
            MarkerHandler.removeAllOnTheFlyMarkedMarkers((IResource)project);
        }
        return Status.OK_STATUS;
    }
}

