/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.preferences.pages.ExcludeRegexpEditor;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;

public class FileListEditor
extends ExcludeRegexpEditor {
    private static final String[] FILTER_EXTENSIONS = new String[]{"*.*", "*.ttcn;*.ttcn3;*.ttcnpp", "*.asn;*.asn1"};
    private static final String[] FILTER_NAMES = new String[]{"All", "TTCN files", "ASN.1 files"};
    private final IProject project;
    private final Set<IFile> fileSet = new HashSet<IFile>();
    private final Set<IFile> fileSetWc = new HashSet<IFile>();

    public FileListEditor(String name, String labelText, Composite parent, IProject project) {
        super(name, labelText, parent);
        this.project = project;
    }

    @Override
    protected void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "Add");
        this.editButton = this.createPushButton(box, "Edit");
        this.removeButton = this.createPushButton(box, "Remove");
    }

    @Override
    protected String[] getNewInputObjects() {
        this.clearMessage();
        FileDialog dialog = new FileDialog(this.getShell(), 4098);
        dialog.setText("File(s) to split");
        dialog.setFilterExtensions(FILTER_EXTENSIONS);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterPath(this.project.getLocation().toOSString());
        dialog.open();
        String[] selection = dialog.getFileNames();
        if (selection.length == 0) {
            return null;
        }
        String path = Path.fromOSString((String)dialog.getFilterPath()).makeRelativeTo(this.project.getLocation()).toOSString();
        if (selection.length == 1) {
            selection[0] = this.addToFileSet(path, selection[0]);
            return selection[0] == null ? null : selection;
        }
        ArrayList<String> selectionList = new ArrayList<String>(selection.length);
        for (int i = 0; i < selection.length; ++i) {
            String filePath = this.addToFileSet(path, selection[i]);
            if (filePath == null) continue;
            selectionList.add(filePath);
        }
        return (String[])selectionList.toArray(String[]::new);
    }

    public boolean isChanged() {
        return !this.fileSet.equals(this.fileSetWc);
    }

    @Override
    protected String getEditInputObject(String original) {
        this.clearMessage();
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("File to split");
        dialog.setFilterExtensions(FILTER_EXTENSIONS);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.open();
        String selection = dialog.getFileName();
        if (selection == null) {
            return original;
        }
        String path = Path.fromOSString((String)dialog.getFilterPath()).makeRelativeTo(this.project.getLocation()).toOSString();
        String filePath = this.addToFileSet(path, selection);
        if (filePath == null) {
            return original;
        }
        this.fileSetWc.removeIf(f -> f.getProjectRelativePath().toOSString().equals(original));
        return filePath;
    }

    public void loadDefault() {
        this.clearMessage();
        this.list.removeAll();
        this.fileSetWc.clear();
    }

    public void load() {
        ResourceVisitor rv = new ResourceVisitor();
        try {
            this.project.accept((IResourceVisitor)rv);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.fileSet.addAll(rv.fileSet);
        this.fileSetWc.addAll(rv.fileSet);
        this.list.removeAll();
        for (IFile file : this.fileSet) {
            this.list.add(file.getProjectRelativePath().toOSString());
        }
    }

    public void store() {
        HashSet<IFile> diff1 = new HashSet<IFile>(this.fileSet);
        diff1.removeAll(this.fileSetWc);
        for (IFile file : diff1) {
            FileBuildPropertyData.setPropertyValue(file, "enableCodeSplitting", false);
        }
        HashSet<IFile> diff2 = new HashSet<IFile>(this.fileSetWc);
        diff2.removeAll(this.fileSet);
        for (IFile file : diff2) {
            FileBuildPropertyData.setPropertyValue(file, "enableCodeSplitting", true);
        }
        this.fileSet.clear();
        this.fileSet.addAll(this.fileSetWc);
    }

    @Override
    protected boolean removeObject(String toBeRemoved) {
        this.clearMessage();
        return this.fileSetWc.removeIf(f -> f.getProjectRelativePath().toOSString().equals(toBeRemoved));
    }

    private String addToFileSet(String path, String fileName) {
        String filePath = this.getFilePath(path, fileName);
        IFile file = (IFile)this.project.findMember(filePath);
        if (file == null) {
            this.showMessage("File not processed, no change performed");
            return null;
        }
        boolean modified = this.fileSetWc.add(file);
        if (!modified) {
            this.showMessage("Duplicate elements have been removed");
            return null;
        }
        return filePath;
    }

    private String getFilePath(String path, String fileName) {
        StringBuilder sb = new StringBuilder(path);
        return sb.append(File.separatorChar).append(fileName).toString();
    }

    private static final class ResourceVisitor
    implements IResourceVisitor {
        final Set<IFile> fileSet = new HashSet<IFile>();

        private ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource != null && resource.isAccessible() && resource.getType() == 1 && FileBuildPropertyData.getPropertyValue((IFile)resource, "enableCodeSplitting")) {
                this.fileSet.add((IFile)resource);
            }
            return true;
        }
    }
}

