/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.properties.pages.FieldEditorPropertyPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

abstract class BaseNamingConventionPropertyPage
extends FieldEditorPropertyPage {
    private boolean changed = false;
    private Composite pagecomp;
    private boolean initilizing = true;

    BaseNamingConventionPropertyPage(int style) {
        super(style);
    }

    protected boolean getChanged() {
        return this.changed;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.pagecomp = new Composite(parent, 0);
        this.pagecomp.setLayout((Layout)new GridLayout(1, false));
        this.pagecomp.setLayoutData((Object)new GridData(1808));
        Control result = super.createContents(this.pagecomp);
        this.initilizing = false;
        return result;
    }

    @Override
    protected void checkState() {
        if (!this.initilizing) {
            this.setErrorMessage(null);
        }
        super.checkState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.changed = true;
        super.propertyChange(event);
    }

    protected void createNamingConventionBody(Composite parent) {
        this.createModuleSection(parent);
        this.createTTCN3GlobalSection(parent);
        this.createTTCN3LocalSection(parent);
        this.createTTCN3ComponentSection(parent);
    }

    private RegexpFieldEditor createFieldEditor(Composite parent, String preference, final String namepart) {
        RegexpFieldEditor stringEditor = new RegexpFieldEditor(preference, "Format of " + namepart + " names", parent, namepart);
        stringEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                BaseNamingConventionPropertyPage.this.changed = true;
                BaseNamingConventionPropertyPage.this.setErrorMessage(null);
                String newValue = ((StringFieldEditor)event.getSource()).getStringValue();
                try {
                    Pattern.compile(newValue);
                }
                catch (PatternSyntaxException e) {
                    BaseNamingConventionPropertyPage.this.setErrorMessage("The format of " + namepart + " name regexp is wrong");
                }
            }
        });
        return stringEditor;
    }

    private ExpandableComposite createExtendableComposite(final Composite parent, String title) {
        ExpandableComposite ex = new ExpandableComposite(parent, 0, 50);
        ex.setText(title);
        ex.setExpanded(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        ex.setLayoutData((Object)data);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite temp;
                for (temp = parent; temp != null && !(temp instanceof ScrolledComposite); temp = temp.getParent()) {
                }
                if (temp != null) {
                    Point point = BaseNamingConventionPropertyPage.this.pagecomp.computeSize(-1, -1);
                    ((ScrolledComposite)temp).setMinSize(point);
                    ((ScrolledComposite)temp).layout(true, true);
                }
            }
        });
        return ex;
    }

    private void createModuleSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "module names");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionTTCN3Module", "TTCN-3 module name"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionASN1Module", "ASN.1 module name"));
    }

    private void createTTCN3GlobalSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "global TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(true);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionAltstep", "altstep"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalConstant", "global constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionExternalConstant", "external constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionFunction", "function"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionExternalFunction", "external function"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionModuleParameter", "module parameter"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalPort", "global port"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalTemplate", "global template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionTestcase", "testcase"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGlobalTimer", "global timer"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionType", "type"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionGroup", "group"));
    }

    private void createTTCN3LocalSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "local TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalConstant", "local constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalVariable", "local variable"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionlocalTemplate", "local template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalVariableTemplate", "local variable template"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionLocalTimer", "local timer"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionFormalParameter", "formal paremeter"));
    }

    private void createTTCN3ComponentSection(Composite parent) {
        ExpandableComposite expandable = this.createExtendableComposite(parent, "component internal TTCN-3 definitions");
        Composite comp = new Composite((Composite)expandable, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(768));
        expandable.setClient((Control)comp);
        expandable.setExpanded(false);
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentConstant", "component constant"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentVariable", "component variable"));
        this.addField((FieldEditor)this.createFieldEditor(comp, "org.eclipse.titan.designer.reportNamingConventionComponentTimer", "component timer"));
    }

    private static class RegexpFieldEditor
    extends StringFieldEditor {
        private final String regexpName;

        public RegexpFieldEditor(String name, String labelText, Composite parent, String regexpName) {
            super(name, labelText, UNLIMITED, parent);
            this.regexpName = regexpName;
        }

        public boolean isValid() {
            super.refreshValidState();
            return super.isValid();
        }

        protected boolean checkState() {
            String txt;
            boolean result = false;
            if (this.isEmptyStringAllowed()) {
                result = true;
            }
            if (this.getTextControl() == null) {
                result = false;
            }
            result = !(txt = this.getTextControl().getText()).trim().isEmpty() || this.isEmptyStringAllowed();
            boolean bl = result = result && this.doCheckState();
            if (!result && this.getPage().getErrorMessage() == null) {
                this.showErrorMessage(this.getErrorMessage());
            }
            return result;
        }

        protected boolean doCheckState() {
            String newValue = this.getStringValue();
            try {
                Pattern.compile(newValue);
            }
            catch (PatternSyntaxException e) {
                this.setErrorMessage("The format of " + this.regexpName + " name regexp is wrong");
                return false;
            }
            return true;
        }
    }
}

