/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocatorFieldEditor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.properties.data.MakeAttributesData;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class MakeAttributesTab {
    private static final String MAKEFLAGS_STRINGFIELDEDITOR_LABEL = "Makefile flags:";
    private TabItem makeAttributesTabItem;
    private static final String MAKEATTRIBUTES_TEXT = "Make attributes";
    private Composite makeAttributesComposite;
    private Composite makeFlagsComposite;
    private Composite makefileScriptComposite;
    public static final String TEMPORAL_MAKEFILE_SCRIPT = "org.eclipse.titan.designer.temporalMakefileUpdateScript";
    private TITANResourceLocatorFieldEditor temporalMakefileScriptFileFieldEditor;
    public static final String TEMPORAL_MAKEFILE_FLAGS = "org.eclipse.titan.designer.temporalMakefileFlags";
    private StringFieldEditor temporalMakefileFlagsStringFieldEditor;
    public static final String TEMPORAL_WORKINGDIRECTORY = "org.eclipse.titan.designer.temporalWorkingDir";
    private Composite workingDirComposite;
    private TITANResourceLocatorFieldEditor workingDirFieldEditor;
    private Label buildLeveltext;
    private Combo buildLevel;
    private Composite buildLevelComposite;
    private final IProject project;
    private final ProjectBuildPropertyPage page;

    public MakeAttributesTab(IProject project, ProjectBuildPropertyPage page) {
        this.project = project;
        this.page = page;
    }

    public void dispose() {
        this.buildLevel.dispose();
        this.buildLevelComposite.dispose();
        this.temporalMakefileFlagsStringFieldEditor.dispose();
        this.makeFlagsComposite.dispose();
        this.workingDirFieldEditor.dispose();
        this.temporalMakefileScriptFileFieldEditor.dispose();
        this.makefileScriptComposite.dispose();
        this.makeAttributesComposite.dispose();
        this.makeAttributesTabItem.dispose();
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.makeAttributesTabItem = new TabItem(tabFolder, 2048);
        this.makeAttributesTabItem.setText(MAKEATTRIBUTES_TEXT);
        this.makeAttributesTabItem.setToolTipText("Settings controlling the usage of the makefile.");
        this.makeAttributesComposite = new Composite((Composite)tabFolder, 2);
        this.makeAttributesComposite.setEnabled(true);
        this.makeAttributesComposite.setLayout((Layout)new GridLayout());
        this.makefileScriptComposite = new Composite(this.makeAttributesComposite, 0);
        GridLayout makefileScriptLayout = new GridLayout();
        this.makefileScriptComposite.setLayout((Layout)makefileScriptLayout);
        GridData makefileScriptData = new GridData(4);
        makefileScriptData.grabExcessHorizontalSpace = true;
        makefileScriptData.horizontalAlignment = 4;
        makefileScriptData.horizontalSpan = 2;
        this.makefileScriptComposite.setLayoutData((Object)makefileScriptData);
        this.temporalMakefileScriptFileFieldEditor = new TITANResourceLocatorFieldEditor(TEMPORAL_MAKEFILE_SCRIPT, "Makefile updater script:", this.makefileScriptComposite, 1, this.project.getLocation().toOSString());
        this.temporalMakefileScriptFileFieldEditor.setEnabled(true, this.makefileScriptComposite);
        this.temporalMakefileScriptFileFieldEditor.getLabelControl(this.makefileScriptComposite).setToolTipText("The location of an external script,\n used to fine tune newly generated makefiles.\nThis field is optional.");
        this.buildLevelComposite = new Composite(this.makeAttributesComposite, 0);
        GridLayout buildLevelLayout = new GridLayout(2, false);
        this.buildLevelComposite.setLayout((Layout)buildLevelLayout);
        this.buildLevelComposite.setLayoutData((Object)new GridData(32));
        this.buildLeveltext = new Label(this.buildLevelComposite, 0);
        this.buildLeveltext.setText("Build level: ");
        this.buildLeveltext.setLayoutData((Object)new GridData(32));
        this.buildLeveltext.setToolTipText("The way the build process should behave, from now on.");
        this.buildLevel = new Combo(this.buildLevelComposite, 8);
        this.buildLevel.add("Level 0 - Semantic Check");
        this.buildLevel.add("Level 1 - TTCN3 -> C++ compilation");
        this.buildLevel.add("Level 2 - Creating object files");
        this.buildLevel.add("Level 2.5 - Creating object files with heuristical dependency update");
        this.buildLevel.add("Level 3 - Creating object files with dependency update");
        this.buildLevel.add("Level 4 - Creating Executable Test Suite");
        this.buildLevel.add("Level 4.5 - Creating Executable Test Suite with heuristical dependency update");
        this.buildLevel.add("Level 5 - Creating Executable Test Suite with dependency update");
        this.buildLevel.setText("Level 5 - Creating Executable Test Suite with dependency update");
        this.buildLevel.setEnabled(true);
        this.buildLevel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeAttributesTab.this.updateBuildLevelDependecies();
            }
        });
        this.makeFlagsComposite = new Composite(this.makeAttributesComposite, 0);
        GridLayout makeFlagsLayout = new GridLayout();
        this.makeFlagsComposite.setLayout((Layout)makeFlagsLayout);
        GridData makeFlagsData = new GridData(4);
        makeFlagsData.grabExcessHorizontalSpace = true;
        makeFlagsData.horizontalAlignment = 4;
        makeFlagsData.horizontalSpan = 2;
        this.makeFlagsComposite.setLayoutData((Object)makeFlagsData);
        this.temporalMakefileFlagsStringFieldEditor = new StringFieldEditor(TEMPORAL_MAKEFILE_FLAGS, "Makefile flags: all", this.makeFlagsComposite);
        this.temporalMakefileFlagsStringFieldEditor.setEnabled(true, this.makeFlagsComposite);
        this.temporalMakefileFlagsStringFieldEditor.getLabelControl(this.makeFlagsComposite).setToolTipText("The flags, the makefile will be called with when building the project.");
        this.temporalMakefileFlagsStringFieldEditor.setPage((DialogPage)this.page);
        this.workingDirComposite = new Composite(this.makeAttributesComposite, 0);
        GridLayout workingDirLayout2 = new GridLayout();
        this.workingDirComposite.setLayout((Layout)workingDirLayout2);
        GridData workingDirData2 = new GridData(4);
        workingDirData2.grabExcessHorizontalSpace = true;
        workingDirData2.horizontalAlignment = 4;
        workingDirData2.horizontalSpan = 2;
        this.workingDirComposite.setLayoutData((Object)workingDirData2);
        this.workingDirFieldEditor = new TITANResourceLocatorFieldEditor("workingDir", "working directory:", this.workingDirComposite, 2, this.project.getLocation().toOSString());
        this.workingDirFieldEditor.getLabelControl(this.workingDirComposite).setToolTipText("The location of the working directory. Where the build process will take place");
        this.workingDirFieldEditor.setPage((DialogPage)this.page);
        this.updateBuildLevelDependecies();
        this.makeAttributesTabItem.setControl((Control)this.makeAttributesComposite);
        return this.makeAttributesTabItem;
    }

    protected void updateBuildLevelDependecies() {
        int level = this.buildLevel.getSelectionIndex();
        switch (level) {
            case 0: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: check");
                this.buildLevel.setToolTipText("Only syntactic then semantic checks are done.\nNo executable is generated.");
                break;
            }
            case 1: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: compile");
                this.buildLevel.setToolTipText("Full checking then C++ code generated.\nNor objects nor executable are generated.");
                break;
            }
            case 2: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: objects");
                this.buildLevel.setToolTipText("Full checking then C++ code generated\nCompilation into object files but without refreshing the dependencies\nNo executable is generated.");
                break;
            }
            case 3: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: objects");
                this.buildLevel.setToolTipText("Full checking then C++ code generated.\nDependencies are heuristically updated.\nCompilation into object files.\nNo executable is generated.");
                break;
            }
            case 4: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: objects");
                this.buildLevel.setToolTipText("Full checking then C++ code generated.\nDependencies are updated.\nCompilation into object files.\nNo executable is generated.");
                break;
            }
            case 5: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: all");
                this.buildLevel.setToolTipText("Full compilation.\nThe executable is generated.");
                break;
            }
            case 6: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: all");
                this.buildLevel.setToolTipText("Full compilation with heuristical refreshing of the dependencies.\nThe executable is generated.");
                break;
            }
            case 7: {
                this.temporalMakefileFlagsStringFieldEditor.setLabelText("Makefile flags: all");
                this.buildLevel.setToolTipText("Full compilation with the refreshing of the dependencies.\nThe executable is generated.");
                break;
            }
        }
        this.makeFlagsComposite.layout(true);
    }

    protected void setMakefileGenerationEnabled(boolean value) {
        this.temporalMakefileScriptFileFieldEditor.setEnabled(value, this.makefileScriptComposite);
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "buildLevel"));
            temp = MakeAttributesData.getBuildLevel(temp);
            tempStorage.setValue("buildLevel", temp);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
            if (temp != null) {
                tempStorage.setValue("makefileUpdateScript", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileFlags"))) != null) {
                tempStorage.setValue("makefileFlags", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"))) != null) {
                tempStorage.setValue("workingDir", temp);
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        try {
            String actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "buildLevel"));
            actualValue = MakeAttributesData.getBuildLevel(actualValue);
            String copyValue = tempStorage.getString("buildLevel");
            result |= !actualValue.equals(copyValue);
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
            copyValue = tempStorage.getString("makefileUpdateScript");
            result |= actualValue == null || !actualValue.equals(copyValue);
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileFlags"));
            copyValue = tempStorage.getString("makefileFlags");
            result |= actualValue == null || !actualValue.equals(copyValue);
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
            copyValue = tempStorage.getString("workingDir");
            result |= actualValue == null || !actualValue.equals(copyValue);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        return result;
    }

    protected void performDefaults() {
        this.buildLevel.setEnabled(true);
        this.buildLevel.setText("Level 5 - Creating Executable Test Suite with dependency update");
        this.temporalMakefileScriptFileFieldEditor.setEnabled(true, this.makefileScriptComposite);
        this.temporalMakefileScriptFileFieldEditor.setStringValue("");
        this.temporalMakefileFlagsStringFieldEditor.setEnabled(true, this.makeFlagsComposite);
        this.temporalMakefileFlagsStringFieldEditor.setStringValue("");
        this.workingDirFieldEditor.setEnabled(true, this.workingDirComposite);
        this.workingDirFieldEditor.setStringValue("bin");
    }

    public boolean checkProperties(ProjectBuildPropertyPage page) {
        URI uri;
        if (!"".equals(this.temporalMakefileScriptFileFieldEditor.getStringValue())) {
            if (!this.temporalMakefileScriptFileFieldEditor.isValid()) {
                page.setErrorMessage(this.temporalMakefileScriptFileFieldEditor.getErrorMessage());
                return false;
            }
            uri = TITANPathUtilities.resolvePathURI((String)this.temporalMakefileScriptFileFieldEditor.getStringValue(), (String)this.project.getLocation().toOSString());
            File file = URIUtil.toPath((URI)uri).toFile();
            if (!file.exists()) {
                page.setErrorMessage("Makefile updater script must exist !");
                return false;
            }
        }
        if ("".equals(this.workingDirFieldEditor.getStringValue()) || !this.workingDirFieldEditor.isValid()) {
            String errorMessage = this.workingDirFieldEditor.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "The working directory must be set";
            }
            page.setErrorMessage(errorMessage);
            return false;
        }
        uri = TITANPathUtilities.resolvePathURI((String)this.workingDirFieldEditor.getStringValue(), (String)this.project.getLocation().toOSString());
        uri = uri.normalize();
        if (this.project.getLocationURI().equals(uri)) {
            page.setErrorMessage("The working directory of the project and its location can not be the same folder.");
        }
        return true;
    }

    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "buildLevel"));
            temp = MakeAttributesData.getBuildLevel(temp);
            this.buildLevel.setText(temp);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileUpdateScript"));
            this.temporalMakefileScriptFileFieldEditor.setStringValue(temp);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "makefileFlags"));
            this.temporalMakefileFlagsStringFieldEditor.setStringValue(temp);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"));
            if (temp == null) {
                this.workingDirFieldEditor.setStringValue("bin");
            } else {
                this.workingDirFieldEditor.setStringValue(temp);
            }
            this.updateBuildLevelDependecies();
        }
        catch (CoreException e) {
            this.buildLevel.setText("Level 5 - Creating Executable Test Suite with dependency update");
            this.temporalMakefileScriptFileFieldEditor.setStringValue("");
            this.temporalMakefileFlagsStringFieldEditor.setStringValue("");
            this.workingDirFieldEditor.setStringValue("bin");
        }
    }

    public boolean saveProperties(IProject project) {
        try {
            this.setProperty(project, "buildLevel", this.buildLevel.getText());
            String temp = this.temporalMakefileScriptFileFieldEditor.getStringValue();
            URI path = URIUtil.toURI((String)temp);
            URI resolvedPath = TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString());
            if (path.equals(resolvedPath)) {
                temp = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)temp);
            }
            this.setProperty(project, "makefileUpdateScript", temp);
            this.setProperty(project, "makefileFlags", this.temporalMakefileFlagsStringFieldEditor.getStringValue());
            temp = this.workingDirFieldEditor.getStringValue();
            path = URIUtil.toURI((String)temp);
            resolvedPath = TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString());
            if (path.equals(resolvedPath)) {
                temp = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)temp);
            }
            this.setProperty(project, "workingDir", temp);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            return false;
        }
        return true;
    }

    private void setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
        }
    }
}

