/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocatorFieldEditor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public final class MakefileCreationTab {
    private static final String CREATIONATTRIBUTES_TEXT = "Makefile creation attributes";
    private Composite automaticBuildPropertiesComposite;
    private Button useAbsolutePathButton;
    private Button gnuMakeButton;
    private Button incrementalDependecyRefresh;
    private Button dynamicLinking;
    private Button functionTestRuntimeButton;
    private Button singleModeButton;
    private Composite defaultTargetComposite;
    private ComboFieldEditor defaultTarget;
    private Composite targetExecutableComposite;
    public static final String TEMPORAL_TARGET_EXECUTABLE = "org.eclipse.titan.designer.temporalTargetExecutable";
    private TITANResourceLocatorFieldEditor temporalTargetExecutableFileFieldEditor;
    private TabItem creationAttributesTabItem;
    private final IProject project;
    private final PropertyPage page;

    public MakefileCreationTab(IProject project, PropertyPage page) {
        this.project = project;
        this.page = page;
    }

    public void dispose() {
        this.useAbsolutePathButton.dispose();
        this.gnuMakeButton.dispose();
        this.incrementalDependecyRefresh.dispose();
        this.dynamicLinking.dispose();
        this.functionTestRuntimeButton.dispose();
        this.singleModeButton.dispose();
        this.defaultTarget.dispose();
        this.defaultTargetComposite.dispose();
        this.temporalTargetExecutableFileFieldEditor.dispose();
        this.targetExecutableComposite.dispose();
        this.automaticBuildPropertiesComposite.dispose();
        this.creationAttributesTabItem.dispose();
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.creationAttributesTabItem = new TabItem(tabFolder, 2048);
        this.creationAttributesTabItem.setText(CREATIONATTRIBUTES_TEXT);
        this.creationAttributesTabItem.setToolTipText("Settings controlling the generation of the makefile.");
        this.automaticBuildPropertiesComposite = new Composite((Composite)tabFolder, 2);
        this.automaticBuildPropertiesComposite.setEnabled(true);
        this.automaticBuildPropertiesComposite.setLayout((Layout)new GridLayout());
        this.useAbsolutePathButton = new Button(this.automaticBuildPropertiesComposite, 32);
        this.useAbsolutePathButton.setText("use absolute pathnames in the Makefile");
        this.gnuMakeButton = new Button(this.automaticBuildPropertiesComposite, 32);
        this.gnuMakeButton.setText("generate Makefile for use with GNU make");
        this.incrementalDependecyRefresh = new Button(this.automaticBuildPropertiesComposite, 32);
        this.incrementalDependecyRefresh.setText("generate Makefile with incrementally refreshing dependency");
        this.dynamicLinking = new Button(this.automaticBuildPropertiesComposite, 32);
        this.dynamicLinking.setText("link dynamically");
        this.functionTestRuntimeButton = new Button(this.automaticBuildPropertiesComposite, 32);
        this.functionTestRuntimeButton.setText("generate Makefile for use with the function test runtime");
        this.singleModeButton = new Button(this.automaticBuildPropertiesComposite, 32);
        this.singleModeButton.setText("generate Makefile for single mode");
        this.defaultTargetComposite = new Composite(this.automaticBuildPropertiesComposite, 0);
        this.defaultTarget = new ComboFieldEditor("defaultTarget", "Default target:", MakefileCreationData.DefaultTarget.getDisplayNamesAndValues(), this.defaultTargetComposite);
        this.targetExecutableComposite = new Composite(this.automaticBuildPropertiesComposite, 0);
        GridLayout targetExecutableLayout = new GridLayout();
        this.targetExecutableComposite.setLayout((Layout)targetExecutableLayout);
        GridData targetExecutableData = new GridData(4);
        targetExecutableData.grabExcessHorizontalSpace = true;
        targetExecutableData.horizontalAlignment = 4;
        this.targetExecutableComposite.setLayoutData((Object)targetExecutableData);
        this.temporalTargetExecutableFileFieldEditor = new TITANResourceLocatorFieldEditor(TEMPORAL_TARGET_EXECUTABLE, "Target executable:", this.targetExecutableComposite, 1, this.project.getLocation().toOSString());
        this.temporalTargetExecutableFileFieldEditor.getLabelControl(this.targetExecutableComposite).setToolTipText("The \"final\" executable file that will be built. (Also called Executable Test Suite) \nThis field is optional.\n If it is not set, the executable will be generated into the working directory, with the name of the project.");
        this.temporalTargetExecutableFileFieldEditor.setPage((DialogPage)this.page);
        if ("win32".equals(Platform.getOS())) {
            String[] extensions = new String[]{"*.exe", "*.*"};
            this.temporalTargetExecutableFileFieldEditor.setFilterExtensions(extensions);
        }
        this.creationAttributesTabItem.setControl((Control)this.automaticBuildPropertiesComposite);
        return this.creationAttributesTabItem;
    }

    protected void setMakefileGenerationEnabled(boolean value) {
        this.useAbsolutePathButton.setEnabled(value);
        this.gnuMakeButton.setEnabled(value);
        this.incrementalDependecyRefresh.setEnabled(value);
        this.dynamicLinking.setEnabled(value);
        this.functionTestRuntimeButton.setEnabled(value);
        this.singleModeButton.setEnabled(value);
        this.defaultTargetComposite.setEnabled(value);
        this.defaultTarget.setEnabled(value, this.defaultTargetComposite);
        this.temporalTargetExecutableFileFieldEditor.setEnabled(value, this.targetExecutableComposite);
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useAbsolutePath"));
            if (temp != null) {
                tempStorage.setValue("useAbsolutePath", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "GNUMake"))) != null) {
                tempStorage.setValue("GNUMake", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "IncrementalDependency"))) != null) {
                tempStorage.setValue("IncrementalDependency", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty"))) != null) {
                tempStorage.setValue("DynamicLinkingProperty", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime"))) != null) {
                tempStorage.setValue("Function test runtime", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "singleMode"))) != null) {
                tempStorage.setValue("singleMode", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultTarget"))) != null) {
                tempStorage.setValue("defaultTarget", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"))) != null) {
                tempStorage.setValue("targetExecutable", temp);
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useAbsolutePath"));
            copyValue = tempStorage.getString("useAbsolutePath");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "GNUMake"));
            copyValue = tempStorage.getString("GNUMake");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "IncrementalDependency"));
            copyValue = tempStorage.getString("IncrementalDependency");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty"));
            copyValue = tempStorage.getString("DynamicLinkingProperty");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime"));
            copyValue = tempStorage.getString("Function test runtime");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "singleMode"));
            copyValue = tempStorage.getString("singleMode");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultTarget"));
            copyValue = tempStorage.getString("defaultTarget");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            copyValue = tempStorage.getString("targetExecutable");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        return result;
    }

    protected void performDefaults() {
        this.useAbsolutePathButton.setSelection(false);
        this.gnuMakeButton.setSelection(false);
        this.incrementalDependecyRefresh.setSelection(false);
        this.dynamicLinking.setSelection(false);
        this.functionTestRuntimeButton.setSelection(false);
        this.singleModeButton.setSelection(false);
        this.defaultTarget.setSelectedValue(MakefileCreationData.DefaultTarget.getDefault().toString());
        this.temporalTargetExecutableFileFieldEditor.setStringValue(MakefileCreationData.getDefaultTargetExecutableName(this.project));
        this.setMakefileGenerationEnabled(true);
    }

    public boolean checkProperties(ProjectBuildPropertyPage page) {
        if (this.dynamicLinking.getSelection()) {
            if (!this.gnuMakeButton.getSelection()) {
                page.setErrorMessage("Dynamic linking is only supported with GNU makefile right now.");
                return false;
            }
            if ("win32".equals(Platform.getOS())) {
                page.setErrorMessage("Dynamic linking is not supported on windows right now.");
                return false;
            }
        }
        if (this.incrementalDependecyRefresh.getSelection() && !this.gnuMakeButton.getSelection()) {
            page.setErrorMessage("Incremental dependency generation is only available when the Makefile is generated for use with GNU make");
            return false;
        }
        if ("".equals(this.temporalTargetExecutableFileFieldEditor.getStringValue()) || !this.temporalTargetExecutableFileFieldEditor.isValid()) {
            String errorMessage = this.temporalTargetExecutableFileFieldEditor.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "The target executable is not set";
            }
            page.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    public void loadProperties(IProject project) {
        boolean useAbsolutePath = false;
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useAbsolutePath"));
            useAbsolutePath = "true".equals(temp);
            this.useAbsolutePathButton.setSelection(useAbsolutePath);
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "GNUMake"));
            this.gnuMakeButton.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "IncrementalDependency"));
            this.incrementalDependecyRefresh.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "DynamicLinkingProperty"));
            this.dynamicLinking.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime"));
            this.functionTestRuntimeButton.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "singleMode"));
            this.singleModeButton.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultTarget"));
            if (temp == null || temp.length() == 0) {
                this.defaultTarget.setSelectedValue(MakefileCreationData.DefaultTarget.getDefault().toString());
            } else {
                try {
                    this.defaultTarget.setSelectedValue(MakefileCreationData.DefaultTarget.createInstance(temp).toString());
                }
                catch (IllegalArgumentException e) {
                    ErrorReporter.INTERNAL_ERROR((String)("Unknown default target in makefile creation tab: " + temp));
                }
            }
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (temp == null) {
                this.temporalTargetExecutableFileFieldEditor.setStringValue(MakefileCreationData.getDefaultTargetExecutableName(project, useAbsolutePath));
            } else {
                this.temporalTargetExecutableFileFieldEditor.setStringValue(temp);
            }
        }
        catch (CoreException e) {
            this.defaultTarget.setSelectedValue(MakefileCreationData.DefaultTarget.getDefault().toString());
            this.temporalTargetExecutableFileFieldEditor.setStringValue(MakefileCreationData.getDefaultTargetExecutableName(project, useAbsolutePath));
            this.setMakefileGenerationEnabled(false);
        }
    }

    public boolean saveProperties(IProject project) {
        try {
            this.setProperty(project, "useAbsolutePath", this.useAbsolutePathButton.getSelection() ? "true" : "false");
            this.setProperty(project, "GNUMake", this.gnuMakeButton.getSelection() ? "true" : "false");
            this.setProperty(project, "IncrementalDependency", this.incrementalDependecyRefresh.getSelection() ? "true" : "false");
            this.setProperty(project, "DynamicLinkingProperty", this.dynamicLinking.getSelection() ? "true" : "false");
            this.setProperty(project, "Function test runtime", this.functionTestRuntimeButton.getSelection() ? "true" : "false");
            this.setProperty(project, "singleMode", this.singleModeButton.getSelection() ? "true" : "false");
            this.setProperty(project, "defaultTarget", this.defaultTarget.getActualValue());
            String temp = this.temporalTargetExecutableFileFieldEditor.getStringValue();
            URI path = URIUtil.toURI((String)temp);
            URI resolvedPath = TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString());
            if (path.equals(resolvedPath)) {
                temp = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)temp);
            }
            this.setProperty(project, "targetExecutable", temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
        }
    }
}

