/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.MyListControl;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class PreprocessorSymbolsOptionsPage
implements IOptionsPage {
    private final boolean ttcn3symbols;
    private Composite mainComposite;
    private MyListControl definedSymbols;
    private MyListControl undefinedSymbols;

    public PreprocessorSymbolsOptionsPage(boolean ttcn3symbols) {
        this.ttcn3symbols = ttcn3symbols;
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.definedSymbols = new MyListControl(this.mainComposite, "Defined Symbols (-D)", "symbol");
        this.undefinedSymbols = new MyListControl(this.mainComposite, "Undefined Symbols (-U)", "symbol");
        return this.mainComposite;
    }

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.definedSymbols.dispose();
            this.undefinedSymbols.dispose();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.definedSymbols.setEnabled(enabled);
        this.undefinedSymbols.setEnabled(enabled);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String definesProperty = this.ttcn3symbols ? "TTCN3preprocessorDefines" : "preprocessorDefines";
        String undefinesProperty = this.ttcn3symbols ? "TTCN3preprocessorUndefines" : "preprocessorUndefines";
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", definesProperty));
            if (temp != null) {
                tempStorage.setValue(definesProperty, temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", undefinesProperty))) != null) {
                tempStorage.setValue(undefinesProperty, temp);
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String definesProperty = this.ttcn3symbols ? "TTCN3preprocessorDefines" : "preprocessorDefines";
        String undefinesProperty = this.ttcn3symbols ? "TTCN3preprocessorUndefines" : "preprocessorUndefines";
        boolean result = false;
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", definesProperty));
            copyValue = tempStorage.getString(definesProperty);
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", undefinesProperty));
            copyValue = tempStorage.getString(undefinesProperty);
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (result && this.ttcn3symbols && Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            GlobalParser.getProjectSourceParser(project).clearSemanticInformation();
            GlobalParser.getProjectSourceParser(project).analyzeAll();
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.definedSymbols.setEnabled(true);
        this.definedSymbols.setValues(new String[0]);
        this.undefinedSymbols.setEnabled(true);
        this.undefinedSymbols.setValues(new String[0]);
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        String definesProperty = this.ttcn3symbols ? "TTCN3preprocessorDefines" : "preprocessorDefines";
        String undefinesProperty = this.ttcn3symbols ? "TTCN3preprocessorUndefines" : "preprocessorUndefines";
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", definesProperty));
            this.definedSymbols.setValues(ListConverter.convertToList(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", undefinesProperty));
            this.undefinedSymbols.setValues(ListConverter.convertToList(temp));
        }
        catch (CoreException e) {
            this.definedSymbols.setValues(new String[0]);
            this.undefinedSymbols.setValues(new String[0]);
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        String definesProperty = this.ttcn3symbols ? "TTCN3preprocessorDefines" : "preprocessorDefines";
        String undefinesProperty = this.ttcn3symbols ? "TTCN3preprocessorUndefines" : "preprocessorUndefines";
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", definesProperty);
            String newValue = ListConverter.convertFromList(this.definedSymbols.getValues());
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
            qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", undefinesProperty);
            newValue = ListConverter.convertFromList(this.undefinedSymbols.getValues());
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

