/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RecordOf_Match;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanNull_Type;
import org.eclipse.titan.runtime.core.TitanValue_Array;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.utils.StringUtils;

public class TitanTemplate_Array<Tvalue extends Base_Type, Ttemplate extends Base_Template>
extends Restricted_Length_Template {
    private Class<Tvalue> classValue;
    private Class<Ttemplate> classTemplate;
    protected int array_size;
    private int indexOffset;
    protected Base_Template[] single_value;
    protected int singleSize;
    protected TitanTemplate_Array<?, ?>[] value_list;
    protected int listSize;
    private ArrayList<Pair_of_elements> permutationIntervals;

    private void encode_text_permutation(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        int number_of_permutations = this.get_number_of_permutations();
        text_buf.push_int(number_of_permutations);
        for (int i = 0; i < number_of_permutations; ++i) {
            text_buf.push_int(this.permutationIntervals.get(i).start_index);
            text_buf.push_int(this.permutationIntervals.get(i).end_index);
        }
    }

    private void decode_text_permutation(Text_Buf text_buf) {
        this.decode_text_restricted(text_buf);
        int number_of_permutations = text_buf.pull_int().get_int();
        this.permutationIntervals = new ArrayList(number_of_permutations);
        for (int i = 0; i < number_of_permutations; ++i) {
            int start_index = text_buf.pull_int().get_int();
            int end_index = text_buf.pull_int().get_int();
            this.permutationIntervals.add(new Pair_of_elements(start_index, end_index));
        }
    }

    private void clean_up_intervals() {
        this.permutationIntervals = null;
    }

    @Override
    protected void set_selection(Base_Template.template_sel otherValue) {
        super.set_selection(otherValue);
        this.clean_up_intervals();
    }

    protected void set_selection(TitanTemplate_Array<Tvalue, Ttemplate> otherValue) {
        super.set_selection(otherValue);
        this.clean_up_intervals();
        if (otherValue.template_selection == Base_Template.template_sel.SPECIFIC_VALUE && otherValue.permutationIntervals != null) {
            this.permutationIntervals = new ArrayList(otherValue.permutationIntervals.size());
            this.permutationIntervals.addAll(otherValue.permutationIntervals);
        }
    }

    public final List<Pair_of_elements> copy_permutations(List<Pair_of_elements> srcList) {
        if (srcList == null) {
            return null;
        }
        ArrayList<Pair_of_elements> newList = new ArrayList<Pair_of_elements>(srcList.size());
        for (Pair_of_elements srcElem : srcList) {
            Pair_of_elements newElem = new Pair_of_elements(srcElem.start_index, srcElem.start_index);
            newList.add(newElem);
        }
        return newList;
    }

    public void remove_all_permutations() {
        this.clean_up_intervals();
    }

    public void add_permutation(int start_index, int end_index) {
        if (start_index > end_index) {
            throw new TtcnError("wrong permutation interval settings start " + start_index + " can not be greater than end " + end_index);
        }
        int number_of_permutations = this.get_number_of_permutations();
        if (number_of_permutations > 0 && this.permutationIntervals.get(number_of_permutations - 1).end_index >= start_index) {
            throw new TtcnError(MessageFormat.format("the {0}{1} permutation overlaps the previous one", number_of_permutations, StringUtils.getOrdinalIndicator(number_of_permutations)));
        }
        if (this.permutationIntervals == null) {
            this.permutationIntervals = new ArrayList(1);
        }
        Pair_of_elements newElem = new Pair_of_elements(start_index, end_index);
        this.permutationIntervals.add(newElem);
    }

    public int get_number_of_permutations() {
        return this.permutationIntervals != null ? this.permutationIntervals.size() : 0;
    }

    public int get_permutation_start(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutationIntervals.get(index_value).start_index;
    }

    public int get_permutation_end(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutationIntervals.get(index_value).end_index;
    }

    public int get_permutation_size(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutationIntervals.get(index_value).end_index - this.permutationIntervals.get(index_value).start_index + 1;
    }

    boolean permutation_starts_at(int index_value) {
        int number_of_permutations = this.get_number_of_permutations();
        for (int i = 0; i < number_of_permutations; ++i) {
            if (this.permutationIntervals.get(i).start_index != index_value) continue;
            return true;
        }
        return false;
    }

    boolean permutation_ends_at(int index_value) {
        int number_of_permutations = this.get_number_of_permutations();
        for (int i = 0; i < number_of_permutations; ++i) {
            if (this.permutationIntervals.get(i).end_index != index_value) continue;
            return true;
        }
        return false;
    }

    protected void copy_value(TitanValue_Array<Tvalue> otherValue) {
        this.array_size = otherValue.array_size;
        this.indexOffset = otherValue.indexOffset;
        this.singleSize = otherValue.array_size;
        this.single_value = new Base_Template[this.singleSize];
        for (int i = 0; i < this.singleSize; ++i) {
            try {
                Base_Template helper = (Base_Template)this.classTemplate.newInstance();
                helper.operator_assign((Base_Type)otherValue.get_at(i));
                this.single_value[i] = helper;
                continue;
            }
            catch (InstantiationException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
            }
            catch (IllegalAccessException e) {
                throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
            }
        }
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
    }

    private void copy_template(TitanTemplate_Array<Tvalue, Ttemplate> otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.array_size = otherValue.array_size;
                this.indexOffset = otherValue.indexOffset;
                this.singleSize = otherValue.singleSize;
                this.single_value = new Base_Template[this.singleSize];
                for (int i = 0; i < this.singleSize; ++i) {
                    try {
                        Base_Template helper = (Base_Template)this.classTemplate.newInstance();
                        helper.operator_assign(otherValue.single_value[i]);
                        this.single_value[i] = helper;
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                    catch (IllegalAccessException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                }
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.array_size = otherValue.array_size;
                this.indexOffset = otherValue.indexOffset;
                this.listSize = otherValue.listSize;
                this.value_list = new TitanTemplate_Array[this.listSize];
                for (int i = 0; i < this.listSize; ++i) {
                    TitanTemplate_Array temp = new TitanTemplate_Array(otherValue.value_list[i]);
                    this.value_list[i] = temp;
                }
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported array template.");
            }
        }
        this.set_selection(otherValue);
    }

    private TitanTemplate_Array(Class<Tvalue> classValue, Class<Ttemplate> classTemplate) {
        this.classValue = classValue;
        this.classTemplate = classTemplate;
    }

    public TitanTemplate_Array(Class<Tvalue> classValue, Class<Ttemplate> classTemplate, Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanTemplate_Array.check_single_selection(otherValue);
        this.classValue = classValue;
        this.classTemplate = classTemplate;
    }

    public TitanTemplate_Array(Class<Tvalue> classValue, Class<Ttemplate> classTemplate, TitanNull_Type otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.classValue = classValue;
        this.classTemplate = classTemplate;
        this.single_value = null;
        this.permutationIntervals = null;
    }

    public TitanTemplate_Array(Class<Ttemplate> classTemplate, TitanValue_Array<Tvalue> otherValue) {
        this.classValue = otherValue.clazz;
        this.classTemplate = classTemplate;
        this.copy_value(otherValue);
    }

    public TitanTemplate_Array(TitanTemplate_Array<Tvalue, Ttemplate> otherValue) {
        this.classValue = otherValue.classValue;
        this.classTemplate = otherValue.classTemplate;
        this.copy_template(otherValue);
    }

    public TitanTemplate_Array(Class<Tvalue> classValue, Class<Ttemplate> classTemplate, int size, int offset) {
        this.classValue = classValue;
        this.classTemplate = classTemplate;
        this.indexOffset = offset;
        this.set_size(size);
    }

    public TitanTemplate_Array(Optional<TitanValue_Array<Tvalue>> other_value) {
        this.clean_up();
        switch (other_value.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.copy_value(other_value.get());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            default: {
                throw new TtcnError("Creating an array template from an unbound optional field.");
            }
        }
    }

    public void set_size(int length) {
        if (length < 0) {
            throw new TtcnError("Internal error: Setting a negative size for an array template.");
        }
        Base_Template.template_sel old_selection = this.template_selection;
        if (old_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            this.clean_up();
            this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
            this.single_value = null;
        }
        if (length > this.singleSize) {
            this.single_value = new Base_Template[length];
            if (old_selection == Base_Template.template_sel.ANY_VALUE || old_selection == Base_Template.template_sel.ANY_OR_OMIT) {
                for (int i = this.singleSize; i < length; ++i) {
                    try {
                        Base_Template helper = (Base_Template)this.classTemplate.newInstance();
                        helper.set_selection(Base_Template.template_sel.ANY_VALUE);
                        this.single_value[i] = helper;
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                    catch (IllegalAccessException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                }
            } else {
                for (int i = this.singleSize; i < length; ++i) {
                    try {
                        Base_Template helper;
                        this.single_value[i] = helper = (Base_Template)this.classTemplate.newInstance();
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                    catch (IllegalAccessException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                }
            }
        }
        this.array_size = length;
        this.singleSize = length;
    }

    public void setOffset(int offset) {
        this.indexOffset = offset;
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.singleSize = 0;
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.listSize = 0;
                for (int i = 0; i < this.listSize; ++i) {
                    this.value_list[i].clean_up();
                }
                this.value_list = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(Base_Template.template_sel otherValue) {
        TitanTemplate_Array.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(TitanNull_Type otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        return this;
    }

    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(TitanValue_Array<Tvalue> otherValue) {
        this.clean_up();
        this.copy_value(otherValue);
        return this;
    }

    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(Optional<TitanValue_Array<Tvalue>> other_value) {
        this.clean_up();
        switch (other_value.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.copy_value(other_value.get());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            default: {
                throw new TtcnError("Assignment of an unbound optional field to an array template.");
            }
        }
        return this;
    }

    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(TitanTemplate_Array<Tvalue, Ttemplate> otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    public Ttemplate get_at(int index) {
        if (index < this.indexOffset || index >= this.indexOffset + this.array_size) {
            throw new TtcnError(MessageFormat.format("Accessing an element of an array template using invalid index: {0}. Index range is [{1},{2}].", index, this.indexOffset, this.indexOffset + this.array_size));
        }
        index -= this.indexOffset;
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                if (index < this.singleSize) break;
                this.set_size(index + 1);
                break;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                this.set_size(this.listSize);
                break;
            }
            default: {
                this.set_size(index + 1);
            }
        }
        return (Ttemplate)this.single_value[index];
    }

    public Ttemplate get_at(TitanInteger index) {
        index.must_bound("Using an unbound integer value for indexing an array template.");
        return this.get_at(index.get_int());
    }

    public Ttemplate constGet_at(int index) {
        if (index < this.indexOffset) {
            throw new TtcnError(MessageFormat.format("Accessing an element of an array template using invalid index: {0}. Index range is [{1},{2}].", index, this.indexOffset, this.indexOffset + this.array_size));
        }
        index -= this.indexOffset;
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Accessing an element of a non-specific array template.");
        }
        if (index >= this.singleSize) {
            throw new TtcnError(MessageFormat.format("Index overflow in an array template: The index is {0} (starting at {1}), but the template has only {2} elements.", index + this.indexOffset, this.indexOffset, this.singleSize));
        }
        return (Ttemplate)this.single_value[index];
    }

    public Ttemplate constGet_at(TitanInteger index) {
        index.must_bound("Using an unbound integer value for indexing an array template.");
        return this.constGet_at(index.get_int());
    }

    public int n_elem() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.singleSize;
            }
            case VALUE_LIST: {
                return this.listSize;
            }
        }
        throw new TtcnError("Performing n_elem");
    }

    public TitanInteger lengthof() {
        return this.size_of(false);
    }

    public TitanInteger size_of() {
        return this.size_of(true);
    }

    public TitanInteger size_of(boolean isSize) {
        String opName = isSize ? "size" : "length";
        int minSize = 0;
        boolean has_any_or_none = false;
        if (this.is_ifPresent) {
            throw new TtcnError("Performing " + opName + "of() operation on an array template which has an ifpresent attribute.");
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                int count;
                minSize = 0;
                has_any_or_none = false;
                if (!isSize) {
                    for (count = this.singleSize; count > 0 && !this.single_value[count - 1].is_bound(); --count) {
                    }
                }
                block12: for (int i = 0; i < count; ++i) {
                    switch (this.single_value[i].get_selection()) {
                        case OMIT_VALUE: {
                            throw new TtcnError("Performing" + opName + "of() operation on an array template containing omit element.");
                        }
                        case ANY_OR_OMIT: {
                            has_any_or_none = true;
                            continue block12;
                        }
                        default: {
                            ++minSize;
                        }
                    }
                }
                break;
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing " + opName + "of() operation on an array template containing omit element.");
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                minSize = 0;
                has_any_or_none = true;
                break;
            }
            case VALUE_LIST: {
                if (this.listSize != 0) {
                    throw new TtcnError("Performing " + opName + "of() operation on an array template containing an empty list.");
                }
                int itemSize = this.value_list[0].size_of(isSize).get_int();
                for (int i = 1; i < this.listSize; ++i) {
                    if (this.value_list[i].size_of(isSize).get_int() == itemSize) continue;
                    throw new TtcnError("Performing " + opName + "of() operation on an array template containing a value list with different sizes.");
                }
                minSize = itemSize;
                has_any_or_none = false;
                break;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing " + opName + "of() operation on an array template containing complemented list.");
            }
            default: {
                throw new TtcnError("Performing " + opName + "of() operation on an uninitialized/unsupported array template.");
            }
        }
        return new TitanInteger(this.check_section_is_single(minSize, has_any_or_none, opName, "an", "array template"));
    }

    @Override
    public boolean is_value() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            return false;
        }
        for (int i = 0; i < this.singleSize; ++i) {
            if (this.single_value[i].is_value()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TitanValue_Array<Tvalue> valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific array template.");
        }
        if (this.singleSize != this.array_size) {
            throw new TtcnError("Performing a valueof or send operation on a specific array template with invalid size.");
        }
        TitanValue_Array<Tvalue> result = new TitanValue_Array<Tvalue>(this.classValue, this.array_size, this.indexOffset);
        for (int i = 0; i < this.array_size; ++i) {
            result.array_elements[i] = this.single_value[i].valueof();
        }
        return result;
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int length) {
        this.clean_up();
        switch (templateType) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.listSize = length;
                this.value_list = new TitanTemplate_Array[this.listSize];
                for (int i = 0; i < length; ++i) {
                    this.value_list[i] = new TitanTemplate_Array<Tvalue, Ttemplate>(this.classValue, this.classTemplate);
                }
                break;
            }
            default: {
                throw new TtcnError("Internal error: Setting an invalid type for an array template.");
            }
        }
        this.set_selection(templateType);
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list array template.");
        }
        return this.value_list.length;
    }

    @Override
    public TitanTemplate_Array<Tvalue, Ttemplate> list_item(int index) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Internal error: Accessing a list element of a non-list array template.");
        }
        if (index >= this.listSize) {
            throw new TtcnError("Internal error: Index overflow in a value list array template.");
        }
        if (index < 0) {
            throw new TtcnError("Internal error: Index overflow in a value list array template.");
        }
        return this.value_list[index];
    }

    private boolean match_function_specific(Base_Type value, int valueIndex, Restricted_Length_Template template, int templateIndex, boolean legacy) {
        if (valueIndex >= 0) {
            return ((TitanTemplate_Array)template).single_value[templateIndex].match(((TitanValue_Array)value).array_elements[valueIndex], legacy);
        }
        return ((TitanTemplate_Array)template).single_value[templateIndex].is_any_or_omit();
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanValue_Array) {
            return this.match((TitanValue_Array)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value {0} can not be cast to value array", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanValue_Array) {
            this.log_match((TitanValue_Array)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to value array", match_value));
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        if (param.get_id() != null && param.get_id().getClass().equals(Param_Types.Module_Param_Name.class) && param.get_id().next_name()) {
            int param_index;
            String param_field = param.get_id().get_current_name();
            if (param_field.charAt(0) < '0' || param_field.charAt(0) > '9') {
                param.error("Unexpected record field name in module parameter, expected a valid array template index", new Object[0]);
            }
            if ((param_index = Integer.parseInt(param_field)) >= this.array_size) {
                param.error("Invalid array index: %u. The array only has %u elements.", param_index, this.array_size);
            }
            ((Base_Template)this.get_at(param_index)).set_param(param);
            return;
        }
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "array template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanTemplate_Array<Tvalue, Ttemplate> temp = new TitanTemplate_Array<Tvalue, Ttemplate>(this.classValue, this.classTemplate);
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    ((TitanTemplate_Array)temp.list_item(i)).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Value_List: {
                this.set_size(param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    Param_Types.Module_Parameter curr = param.get_elem(i);
                    if (curr.get_type() == Param_Types.Module_Parameter.type_t.MP_NotUsed) continue;
                    ((Base_Template)this.get_at(i + this.indexOffset)).set_param(curr);
                }
                break;
            }
            case MP_Indexed_List: {
                for (int i = 0; i < param.get_size(); ++i) {
                    Param_Types.Module_Parameter curr = param.get_elem(i);
                    ((Base_Template)this.get_at(curr.get_id().get_index())).set_param(curr);
                }
                break;
            }
            default: {
                param.type_error("array template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (param_name.next_name()) {
            String param_field = param_name.get_current_name();
            if (param_field.charAt(0) < '0' || param_field.charAt(0) > '9') {
                throw new TtcnError("Unexpected record field name in module parameter reference, expected a valid array index");
            }
            int param_index = Integer.parseInt(param_field);
            if (param_index >= this.array_size) {
                throw new TtcnError(MessageFormat.format("Invalid array index: {0}. The array only has {1} elements.", param_index, this.array_size));
            }
            return this.single_value[param_index].get_param(param_name);
        }
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                ArrayList<Param_Types.Module_Parameter> values = new ArrayList<Param_Types.Module_Parameter>();
                for (int i = 0; i < this.array_size; ++i) {
                    values.add(this.single_value[i].get_param(param_name));
                }
                mp = new Param_Types.Module_Param_Value_List();
                mp.add_list_with_implicit_ids(values);
                values.clear();
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.length; ++i) {
                    mp.add_elem(this.value_list[i].get_param(param_name));
                }
                break;
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_permutation(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                text_buf.push_int(this.singleSize);
                for (int i = 0; i < this.array_size; ++i) {
                    this.single_value[i].encode_text(text_buf);
                }
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.listSize);
                for (int i = 0; i < this.listSize; ++i) {
                    this.value_list[i].encode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported array template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_permutation(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.singleSize = text_buf.pull_int().get_int();
                if (this.singleSize < 0) {
                    throw new TtcnError("Text decoder: Negative size was received for an array template.");
                }
                this.single_value = new Base_Template[this.singleSize];
                for (int i = 0; i < this.array_size; ++i) {
                    try {
                        Base_Template helper = (Base_Template)this.classTemplate.newInstance();
                        helper.decode_text(text_buf);
                        this.single_value[i] = helper;
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                    catch (IllegalAccessException e) {
                        throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
                    }
                }
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.listSize = text_buf.pull_int().get_int();
                this.value_list = new TitanTemplate_Array[this.listSize];
                for (int i = 0; i < this.listSize; ++i) {
                    this.value_list[i] = new TitanTemplate_Array<Tvalue, Ttemplate>(this.classValue, this.classTemplate);
                    this.value_list[i].decode_text(text_buf);
                }
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for an array template.");
            }
        }
    }

    public boolean match(TitanValue_Array<Tvalue> otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanValue_Array<Tvalue> otherValue, boolean legacy) {
        if (!this.match_length(this.array_size)) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                RecordOf_Match.match_function_t obj = new RecordOf_Match.match_function_t(){

                    @Override
                    public boolean match(Base_Type value_ptr, int value_index, Restricted_Length_Template template_ptr, int template_index, boolean legacy) {
                        return TitanTemplate_Array.this.match_function_specific(value_ptr, value_index, template_ptr, template_index, legacy);
                    }
                };
                return this.match_permutation_array(otherValue, this.array_size, this, this.singleSize, obj, legacy);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.listSize; ++i) {
                    if (!this.value_list[i].match((Base_Type)otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported array template.");
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (!legacy) break;
                for (int i = 0; i < this.listSize; ++i) {
                    if (!this.value_list[i].match_omit()) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
        }
        return false;
    }

    @Override
    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanValue_Array) {
            TitanValue_Array arrayOther = (TitanValue_Array)otherValue;
            return this.operator_assign(arrayOther);
        }
        try {
            Base_Template value = (Base_Template)this.classTemplate.newInstance();
            value.operator_assign(otherValue);
            this.singleSize = 1;
            this.single_value = new Base_Template[this.singleSize];
            this.single_value[0] = value;
        }
        catch (InstantiationException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
        }
        catch (IllegalAccessException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
        }
        return this;
    }

    @Override
    public TitanTemplate_Array<Tvalue, Ttemplate> operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanTemplate_Array) {
            TitanTemplate_Array arrayOther = (TitanTemplate_Array)otherValue;
            return this.operator_assign(arrayOther);
        }
        try {
            Base_Template value = (Base_Template)this.classTemplate.newInstance();
            value.operator_assign(otherValue);
            this.singleSize = 1;
            this.single_value = new Base_Template[this.singleSize];
            this.single_value[0] = value;
        }
        catch (InstantiationException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
        }
        catch (IllegalAccessException e) {
            throw new TtcnError(MessageFormat.format("Internal error: class `{0}'' could not be instantiated ({1}).", this.classTemplate, e));
        }
        return this;
    }

    private RecordOf_Match.answer recursive_permutation_match(Base_Type value_ptr, int value_start_index, int value_size, TitanTemplate_Array<Tvalue, Ttemplate> template_ptr, int template_start_index, int template_size, int permutation_index, RecordOf_Match.match_function_t match_function, AtomicInteger shift_size, boolean legacy) {
        boolean good;
        boolean permutation_begins;
        int nof_permutations = template_ptr.get_number_of_permutations();
        if (permutation_index > nof_permutations) {
            throw new TtcnError("Internal error: recursive_permutation_match: invalid argument.");
        }
        if (permutation_index < nof_permutations && template_ptr.get_permutation_end(permutation_index) > template_start_index + template_size) {
            throw new TtcnError(MessageFormat.format("Internal error: recursive_permutation_match: wrong permutation interval settings for permutation {0}.", permutation_index));
        }
        shift_size.set(0);
        if (template_size == 0) {
            if (value_size == 0) {
                return RecordOf_Match.answer.SUCCESS;
            }
            return RecordOf_Match.answer.FAILURE;
        }
        boolean bl = permutation_begins = permutation_index < nof_permutations && template_start_index == template_ptr.get_permutation_start(permutation_index);
        if (permutation_begins || match_function.match(value_ptr, -1, template_ptr, template_start_index, legacy)) {
            boolean already_superset;
            int largest_possible_size;
            boolean has_asterisk;
            int smallest_possible_size;
            int permutation_size;
            boolean is_asterisk;
            if (permutation_begins) {
                is_asterisk = false;
                permutation_size = template_ptr.get_permutation_size(permutation_index);
                smallest_possible_size = 0;
                has_asterisk = false;
                for (int i = 0; i < permutation_size; ++i) {
                    if (match_function.match(value_ptr, -1, template_ptr, i + template_start_index, legacy)) {
                        has_asterisk = true;
                        continue;
                    }
                    ++smallest_possible_size;
                }
                if (smallest_possible_size > value_size) {
                    return RecordOf_Match.answer.NO_CHANCE;
                }
                if (has_asterisk) {
                    largest_possible_size = value_size;
                    already_superset = smallest_possible_size == 0;
                } else {
                    largest_possible_size = smallest_possible_size;
                    already_superset = false;
                }
            } else {
                is_asterisk = true;
                already_superset = true;
                permutation_size = 1;
                smallest_possible_size = 0;
                largest_possible_size = value_size;
                has_asterisk = true;
            }
            int temp_size = smallest_possible_size;
            int[] pair_list = null;
            int old_temp_size = 0;
            if (!already_superset) {
                pair_list = new int[permutation_size];
                for (int i = 0; i < permutation_size; ++i) {
                    pair_list[i] = -1;
                }
            }
            while (!already_superset) {
                AtomicInteger x = new AtomicInteger(0);
                boolean found = RecordOf_Match.match_set_of_internal(value_ptr, value_start_index, temp_size, template_ptr, template_start_index, permutation_size, match_function, RecordOf_Match.type_of_matching.SUPERSET, x, pair_list, old_temp_size, legacy);
                if (found) {
                    already_superset = true;
                    continue;
                }
                if (has_asterisk && temp_size + x.get() <= largest_possible_size) {
                    old_temp_size = temp_size;
                    temp_size += x.get();
                    continue;
                }
                return RecordOf_Match.answer.FAILURE;
            }
            if (permutation_size == template_size) {
                if (has_asterisk || value_size == temp_size) {
                    return RecordOf_Match.answer.SUCCESS;
                }
                return RecordOf_Match.answer.FAILURE;
            }
            int i = temp_size;
            while (i <= largest_possible_size) {
                RecordOf_Match.answer result = is_asterisk ? this.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + permutation_size, template_size - permutation_size, permutation_index, match_function, shift_size, legacy) : this.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + permutation_size, template_size - permutation_size, permutation_index + 1, match_function, shift_size, legacy);
                if (result == RecordOf_Match.answer.SUCCESS) {
                    return RecordOf_Match.answer.SUCCESS;
                }
                if (result == RecordOf_Match.answer.NO_CHANCE) {
                    return RecordOf_Match.answer.NO_CHANCE;
                }
                if (i == value_size) {
                    return RecordOf_Match.answer.NO_CHANCE;
                }
                if ((i += shift_size.get() > 1 ? shift_size.get() : 1) > largest_possible_size) {
                    shift_size.set(i - largest_possible_size);
                    continue;
                }
                shift_size.set(0);
            }
            return RecordOf_Match.answer.FAILURE;
        }
        int distance = permutation_index < nof_permutations ? template_ptr.get_permutation_start(permutation_index) - template_start_index : template_size;
        if (value_size == 0) {
            return RecordOf_Match.answer.FAILURE;
        }
        int i = 0;
        while ((good = match_function.match(value_ptr, value_start_index + i, template_ptr, template_start_index + i, legacy)) && ++i < value_size && i < distance && !match_function.match(value_ptr, -1, template_ptr, template_start_index + i, legacy)) {
        }
        if (good && (i == distance || match_function.match(value_ptr, -1, template_ptr, template_start_index + i, legacy))) {
            if (i == template_size) {
                if (i < value_size) {
                    return RecordOf_Match.answer.FAILURE;
                }
                return RecordOf_Match.answer.SUCCESS;
            }
            return this.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + i, template_size - i, permutation_index, match_function, shift_size, legacy);
        }
        if (i == value_size) {
            return RecordOf_Match.answer.NO_CHANCE;
        }
        shift_size.set(0);
        --i;
        do {
            good = match_function.match(value_ptr, value_start_index + i + shift_size.get(), template_ptr, template_start_index + i, legacy);
            shift_size.incrementAndGet();
        } while (!good && i + shift_size.get() < value_size);
        if (good) {
            shift_size.decrementAndGet();
            return RecordOf_Match.answer.FAILURE;
        }
        return RecordOf_Match.answer.NO_CHANCE;
    }

    boolean match_permutation_array(Base_Type value_ptr, int value_size, TitanTemplate_Array<Tvalue, Ttemplate> template_ptr, int template_size, RecordOf_Match.match_function_t match_function, boolean legacy) {
        if (value_ptr == null || value_size < 0 || template_ptr == null || template_size < 0 || template_ptr.get_selection() != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Internal error: match_permutation_arry: invalid argument.");
        }
        int nof_permutations = template_ptr.get_number_of_permutations();
        if (nof_permutations == 0) {
            return RecordOf_Match.match_array(value_ptr, value_size, template_ptr, template_size, match_function, legacy);
        }
        if (nof_permutations == 1 && template_ptr.get_permutation_start(0) == 0 && template_ptr.get_permutation_end(0) == template_size - 1) {
            return RecordOf_Match.match_set_of(value_ptr, value_size, template_ptr, template_size, match_function, legacy);
        }
        AtomicInteger shift_size = new AtomicInteger(0);
        return this.recursive_permutation_match(value_ptr, 0, value_size, template_ptr, 0, template_size, 0, match_function, shift_size, legacy) == RecordOf_Match.answer.SUCCESS;
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                if (this.singleSize > 0) {
                    TTCN_Logger.log_event_str("{ ");
                    for (int elem_count = 0; elem_count < this.singleSize; ++elem_count) {
                        if (elem_count > 0) {
                            TTCN_Logger.log_event_str(", ");
                        }
                        if (this.permutation_starts_at(elem_count)) {
                            TTCN_Logger.log_event_str("permutation(");
                        }
                        this.single_value[elem_count].log();
                        if (!this.permutation_ends_at(elem_count)) continue;
                        TTCN_Logger.log_char(')');
                    }
                    TTCN_Logger.log_event_str(" }");
                    break;
                }
                TTCN_Logger.log_event_str("{ }");
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int list_count = 0; list_count < this.listSize; ++list_count) {
                    if (list_count > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list[list_count].log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_restricted();
        this.log_ifpresent();
    }

    public void log_match(TitanValue_Array<Tvalue> match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_OMIT: {
                if (this.template_selection == Base_Template.template_sel.OMIT_VALUE) {
                    return;
                }
            }
            case TR_VALUE: {
                if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) break;
                for (int i = 0; i < this.singleSize; ++i) {
                    this.single_value[i].check_restriction(restriction, name == null ? "array" : name, legacy);
                }
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanTemplate_Array.get_res_name(restriction), name == null ? "array" : name));
    }

    class Pair_of_elements {
        private final int start_index;
        private final int end_index;

        public Pair_of_elements(int start_index, int end_index) {
            this.start_index = start_index;
            this.end_index = end_index;
        }
    }
}

