/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1;

import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASN1.ASN1Assignment;
import org.eclipse.titan.designer.AST.ASN1.Ass_pard;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ValueSet_Assignment
extends ASN1Assignment {
    private static final String UNKNOWNASSIGNMENT = "unknown value assignment";
    private final IASN1Type type;
    private final Block mBlock;

    public ValueSet_Assignment(Identifier id, Ass_pard assPard, IASN1Type type, Block aBlock) {
        super(id, assPard);
        this.type = type;
        this.mBlock = aBlock;
        if (null != type) {
            type.setOwnertype(IType.TypeOwner_type.OT_VSET_ASS, this);
            type.setFullNameParent(this);
        }
        if (null != aBlock) {
            aBlock.setFullNameParent(this);
        }
    }

    @Override
    protected ASN1Assignment internalNewInstance(Identifier identifier) {
        return new ValueSet_Assignment(identifier, null, this.type.newInstance(), this.mBlock);
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_VS;
    }

    @Override
    public void setRightScope(Scope rightScope) {
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.type) {
            this.type.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null != this.assPard) {
            this.assPard.check(timestamp);
            return;
        }
        this.type.setGenName(this.getGenName());
        this.type.check(timestamp);
        ReferenceChain chain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        this.type.checkRecursions(timestamp, chain);
        chain.release();
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && null != this.type) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            propCollector.addProposal(this.identifier, " - unknown value assignment", ImageCache.getImage(this.getOutlineIcon()), UNKNOWNASSIGNMENT);
        } else if (subrefs.size() > index + 1 && null != this.type && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public String getAssignmentName() {
        return "value set";
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.assPard != null) {
            return true;
        }
        return this.type == null || this.type.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        if (null != this.assPard || this.dontGenerate) {
            return;
        }
        if (this.type == null) {
            return;
        }
        String genName = this.getGenName();
        StringBuilder sb = aData.getCodeForType(genName);
        StringBuilder source = new StringBuilder();
        this.type.generateCode(aData, source);
        sb.append((CharSequence)source);
    }
}

