/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.common.product.ProductIdentity;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ModuleVersionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TitanVersionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.VersionRequirementAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.core.CompilerVersionInformationCollector;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProductIdentityHelper;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.HoverProposal;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Keywords;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserUtilities;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;
import org.eclipse.ui.IEditorPart;

public final class TTCN3Module
extends Module {
    private static final String FULLNAMEPART = ".control";
    private static final String MISSINGREFERENCE = "There is no visible definition with name `{0}'' in module `{1}''";
    private List<String> languageSpecifications;
    private final List<ImportModule> importedModules = new CopyOnWriteArrayList<ImportModule>();
    private final List<FriendModule> friendModules = new CopyOnWriteArrayList<FriendModule>();
    private final Definitions definitions = new Definitions();
    private ControlPart controlpart;
    private Location commentLocation = null;
    private Set<IFile> includedFiles = null;
    private List<Location> inactiveCodeLocations = null;
    private final Anytype_Type anytype;
    private final Def_Type anytypeDefinition;
    private WithAttributesPath withAttributesPath = null;
    private ProductIdentity versionNumber = null;
    private final List<Reference> missingReferences;
    private byte[] digest;
    private boolean needsTobeBuilt = true;
    private static final int PROTOTYPE_INDEX = -1;

    public TTCN3Module(Identifier identifier, IProject project) {
        super(identifier, project);
        this.definitions.setParentScope(this);
        this.definitions.setFullNameParent(this);
        this.anytype = new Anytype_Type();
        this.anytypeDefinition = new Def_Type(new Identifier(Identifier.Identifier_type.ID_TTCN, "anytype"), this.anytype);
        this.anytypeDefinition.setMyScope(this);
        this.anytypeDefinition.setFullNameParent(this);
        this.missingReferences = new ArrayList<Reference>();
    }

    @Override
    public Module.module_type getModuletype() {
        return Module.module_type.TTCN3_MODULE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = new StringBuilder();
        builder.append("@").append(this.getIdentifier().getDisplayName());
        if (this.controlpart != null && this.controlpart == child) {
            return builder.append(FULLNAMEPART);
        }
        if (this.anytypeDefinition == child) {
            Identifier identifier = this.anytypeDefinition.getIdentifier();
            return builder.append(".").append(identifier.getDisplayName());
        }
        return builder;
    }

    public void addMD5Digest(byte[] digest) {
        this.digest = new byte[digest.length];
        System.arraycopy(digest, 0, this.digest, 0, digest.length);
    }

    public void setLanguageSpecifications(List<String> languageSpecifications) {
        this.languageSpecifications = languageSpecifications;
    }

    public List<String> getLanguageSpecifictions() {
        return this.languageSpecifications;
    }

    public void setDefinitionsLocation(Location location) {
        this.definitions.setLocation(location);
    }

    private void setVersion(ProductIdentity versionNumber) {
        this.versionNumber = versionNumber;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public void addDefinitions(List<Definition> definitionList) {
        this.definitions.addDefinitions(definitionList);
    }

    public void addImportedModule(ImportModule impmod) {
        if (impmod == null || impmod.getIdentifier() == null || impmod.getLocation() == null) {
            return;
        }
        this.importedModules.add(impmod);
        impmod.setMyModule(this.identifier);
        impmod.setMyModule(this);
        impmod.setProject(this.project);
    }

    public void addGroup(Group group) {
        if (group != null && group.getIdentifier() != null) {
            this.definitions.addGroup(group);
        }
    }

    public void addFriendModule(FriendModule friendModule) {
        if (friendModule != null) {
            this.friendModules.add(friendModule);
            friendModule.setProject(this.project);
        }
    }

    public void addFriendModules(List<FriendModule> friendModuleList) {
        if (friendModuleList != null) {
            ArrayList<FriendModule> safeToAdd = new ArrayList<FriendModule>(friendModuleList.size());
            for (FriendModule friendModule : friendModuleList) {
                if (friendModule == null) continue;
                safeToAdd.add(friendModule);
                friendModule.setProject(this.project);
            }
            this.friendModules.addAll(safeToAdd);
        }
    }

    @Override
    public Definitions getAssignmentsScope() {
        return this.definitions;
    }

    @Override
    public Assignments getAssignments() {
        return this.definitions;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    @Override
    public Def_Type getAnytype() {
        return this.anytypeDefinition;
    }

    public IType getAddressType(CompilationTimeStamp timestamp) {
        Identifier addressIdentifier = new Identifier(Identifier.Identifier_type.ID_TTCN, "address");
        if (!this.definitions.hasLocalAssignmentWithID(timestamp, addressIdentifier)) {
            return null;
        }
        Definition definition = this.definitions.getLocalAssignmentByID(timestamp, addressIdentifier);
        if (!Assignment.Assignment_type.A_TYPE.semanticallyEquals(definition.getAssignmentType())) {
            return null;
        }
        return definition.getType(timestamp);
    }

    @Override
    public Object[] getOutlineChildren() {
        if (!this.importedModules.isEmpty()) {
            return new Object[]{this.importedModules, this.definitions};
        }
        return new Object[]{this.definitions};
    }

    @Override
    public String getOutlineIcon() {
        return "ttcn.gif";
    }

    public void addControlpart(ControlPart controlpart) {
        if (controlpart != null) {
            this.controlpart = controlpart;
            controlpart.setMyScope(this.definitions);
            controlpart.setFullNameParent(this);
        }
    }

    @Override
    public boolean isValidModuleId(Identifier identifier) {
        if (identifier == null) {
            return false;
        }
        String originalName = identifier.getName();
        if (this.identifier != null && originalName.equals(this.identifier.getName())) {
            return true;
        }
        for (ImportModule impMod : this.importedModules) {
            if (!originalName.equals(impMod.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (this.lastImportCheckTimeStamp != null && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        for (ImportModule impmod : this.importedModules) {
            impmod.setUsedForImportation(false);
        }
        for (ImportModule impmod : this.importedModules) {
            referenceChain.markState();
            impmod.checkImports(timestamp, referenceChain, moduleStack);
            referenceChain.previousState();
            LoadBalancingUtilities.astNodeChecked();
        }
        this.lastImportCheckTimeStamp = timestamp;
    }

    private void checkFriendModuleUniqueness() {
        if (!this.friendModules.isEmpty()) {
            HashMap<String, FriendModule> map = new HashMap<String, FriendModule>(this.friendModules.size());
            for (FriendModule friendModule : this.friendModules) {
                Identifier identifier = friendModule.getIdentifier();
                String name = identifier.getName();
                if (map.containsKey(name)) {
                    Location otherLocation = ((FriendModule)map.get(name)).getIdentifier().getLocation();
                    otherLocation.reportSingularSemanticError(MessageFormat.format("Duplicate friend module `{0}'' was first declared here", identifier.getDisplayName()));
                    Location friendLocation = friendModule.getIdentifier().getLocation();
                    friendLocation.reportSingularSemanticError(MessageFormat.format("Duplicate friend module `{0}'' was declared here again", identifier.getDisplayName()));
                    continue;
                }
                map.put(name, friendModule);
            }
        }
    }

    public List<ImportModule> getImports() {
        ArrayList<ImportModule> result = new ArrayList<ImportModule>(this.importedModules.size());
        result.addAll(this.importedModules);
        return result;
    }

    @Override
    public List<Module> getImportedModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (ImportModule impmod : this.importedModules) {
            Module module = impmod.getReferredModule();
            if (module == null) continue;
            result.add(module);
        }
        return result;
    }

    public List<FriendModule> getFriendModules() {
        ArrayList<FriendModule> result = new ArrayList<FriendModule>(this.friendModules.size());
        result.addAll(this.friendModules);
        return result;
    }

    @Override
    public boolean hasUnhandledImportChanges() {
        for (ImportModule impmod : this.importedModules) {
            if (!impmod.hasUnhandledChange()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        this.needsTobeBuilt = true;
        if (this.getSkippedFromSemanticChecking()) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTTCN3Module", this.identifier, "TTCN-3 module");
        this.versionNumber = null;
        this.missingReferences.clear();
        this.definitions.setGenName();
        this.anytypeDefinition.setGenName(this.anytypeDefinition.getIdentifier().getName());
        if (this.withAttributesPath != null) {
            MarkerHandler.markAllSemanticMarkersForRemoval(this.withAttributesPath);
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        for (ImportModule impMod : this.importedModules) {
            impMod.check(timestamp);
        }
        this.checkFriendModuleUniqueness();
        for (FriendModule friendModule : this.friendModules) {
            friendModule.check(timestamp);
        }
        this.analyzeExtensionAttributes(timestamp);
        this.anytypeDefinition.check(timestamp);
        this.definitions.check(timestamp);
        if (this.controlpart != null) {
            this.controlpart.check(timestamp);
        }
    }

    public void checkWithDefinitions(CompilationTimeStamp timestamp, List<Assignment> assignments) {
        if (this.lastCompilationTimeStamp != null && !this.lastCompilationTimeStamp.isLess(timestamp)) {
            return;
        }
        this.lastCompilationTimeStamp = timestamp;
        this.needsTobeBuilt = true;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTTCN3Module", this.identifier, "TTCN-3 module");
        this.versionNumber = null;
        this.missingReferences.clear();
        if (this.withAttributesPath != null) {
            MarkerHandler.markAllSemanticMarkersForRemoval(this.withAttributesPath);
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.checkFriendModuleUniqueness();
        for (FriendModule friendModule : this.friendModules) {
            friendModule.check(timestamp);
        }
        this.analyzeExtensionAttributes(timestamp);
        this.definitions.checkWithDefinitions(timestamp, assignments);
        if (this.controlpart != null) {
            this.controlpart.check(timestamp);
        }
    }

    @Override
    public void postCheck() {
        boolean isDocCheckEnabled;
        if (this.hasDocumentComment() && (isDocCheckEnabled = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableDocumentCommentOnTheFlyCheck"))) {
            this.parseDocumentComment();
        }
        this.definitions.postCheck();
        if (this.controlpart != null) {
            this.controlpart.postCheck();
        }
    }

    private void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        if (this.withAttributesPath == null) {
            return;
        }
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (int i = 0; i < realAttributes.size(); ++i) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (int i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        block7: for (int i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            switch (extensionAttribute.getAttributeType()) {
                case VERSION: {
                    ModuleVersionAttribute moduleVersion = (ModuleVersionAttribute)extensionAttribute;
                    moduleVersion.parse();
                    if (this.versionNumber != null) {
                        moduleVersion.getLocation().reportSemanticError("Duplicate version attribute");
                        continue block7;
                    }
                    this.setVersion(moduleVersion.getVersionNumber());
                    continue block7;
                }
                case REQUIRES: {
                    VersionRequirementAttribute versionReq = (VersionRequirementAttribute)extensionAttribute;
                    versionReq.parse();
                    ModuleImportation theImport = null;
                    String requiredModuleName = versionReq.getRequiredModule().getName();
                    for (ImportModule impMod : this.importedModules) {
                        if (!requiredModuleName.equals(impMod.getIdentifier().getName())) continue;
                        theImport = impMod;
                        break;
                    }
                    if (theImport == null) {
                        String message = MessageFormat.format("There is no module with name `{0}''", versionReq.getRequiredModule().getDisplayName());
                        versionReq.getRequiredModule().getLocation().reportSemanticError(message);
                        continue block7;
                    }
                    TTCN3Module theImportedModule = (TTCN3Module)theImport.getReferredModule();
                    if (theImportedModule == null) continue block7;
                    theImportedModule.check(timestamp);
                    ProductIdentity requiredVersion = versionReq.getVersionNumber();
                    if (requiredVersion == null || theImportedModule.versionNumber == null || theImportedModule.versionNumber.compareTo(requiredVersion) >= 0) continue block7;
                    String message = MessageFormat.format("Module `{0}'' requires version {1} of module `{2}'', but only version {3} is available", this.identifier.getDisplayName(), requiredVersion.toString(), theImportedModule.getIdentifier().getDisplayName(), theImportedModule.versionNumber.toString());
                    versionReq.getLocation().reportSemanticError(message);
                    continue block7;
                }
                case TITANVERSION: {
                    String message;
                    TitanVersionAttribute titanReq = (TitanVersionAttribute)extensionAttribute;
                    titanReq.parse();
                    ProductIdentity requiredTITANVersion = titanReq.getVersionNumber();
                    String temp = CompilerVersionInformationCollector.getCompilerProductNumber();
                    ProductIdentity compilerVersion = ProductIdentityHelper.getProductIdentity(temp, null);
                    if (requiredTITANVersion != null && compilerVersion != null && compilerVersion.compareTo(requiredTITANVersion) < 0) {
                        message = MessageFormat.format("Module `{0}'' requires TITAN version {1}, but version {2} is used right now", this.identifier.getDisplayName(), requiredTITANVersion.toString(), compilerVersion.toString());
                        titanReq.getLocation().reportSemanticError(message);
                    }
                    if (requiredTITANVersion == null || GeneralConstants.ON_THE_FLY_ANALYZER_VERSION == null || GeneralConstants.ON_THE_FLY_ANALYZER_VERSION.compareTo(requiredTITANVersion) >= 0) continue block7;
                    message = MessageFormat.format("Module `{0}'' requires TITAN version {1}, but the on-the-fly analyzer is of version {2}", this.identifier.getDisplayName(), requiredTITANVersion.toString(), GeneralConstants.ON_THE_FLY_ANALYZER_VERSION.toString());
                    titanReq.getLocation().reportSemanticError(message);
                    continue block7;
                }
            }
        }
    }

    @Override
    public Scope getSmallestEnclosingScope(int offset) {
        if (this.location == null || offset < this.location.getOffset() || offset > this.location.getEndOffset()) {
            return null;
        }
        if (this.controlpart != null && this.controlpart.getLocation() != null && this.controlpart.getLocation().getOffset() < offset && offset < this.controlpart.getLocation().getEndOffset()) {
            return this.controlpart.getSmallestEnclosingScope(offset);
        }
        if (!NULL_Location.INSTANCE.equals(this.definitions.getLocation()) && this.definitions.getLocation().getOffset() < offset && offset < this.definitions.getLocation().getEndOffset()) {
            return this.definitions.getSmallestEnclosingScope(offset);
        }
        return this;
    }

    @Override
    public boolean hasImportedAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        for (ImportModule impMod : this.importedModules) {
            if (!impMod.hasImportedAssignmentWithID(timestamp, identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Definition importAssignment(CompilationTimeStamp timestamp, Identifier moduleId, Reference reference) {
        Definition result = this.definitions.getLocalAssignmentByID(timestamp, reference.getId());
        if (result == null) {
            return null;
        }
        VisibilityModifier modifier = result.getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return result;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().equals(moduleId)) continue;
                    return result;
                }
                return null;
            }
            case Private: {
                return null;
            }
        }
        return result;
    }

    public boolean isVisible(CompilationTimeStamp timestamp, Identifier moduleId, ImportModule impmod) {
        VisibilityModifier modifier = impmod.getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return true;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().equals(moduleId)) continue;
                    return true;
                }
                return false;
            }
            case Private: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isVisible(CompilationTimeStamp timestamp, Identifier moduleId, Assignment assignment) {
        if (assignment == null || !(assignment instanceof Definition)) {
            return false;
        }
        if (this.definitions.getLocalAssignmentByID(timestamp, assignment.getIdentifier()) != assignment) {
            return false;
        }
        VisibilityModifier modifier = ((Definition)assignment).getVisibilityModifier();
        switch (modifier) {
            case Public: {
                return true;
            }
            case Friend: {
                for (FriendModule friend : this.friendModules) {
                    if (!friend.getIdentifier().equals(moduleId)) continue;
                    return true;
                }
                return false;
            }
            case Private: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        Identifier moduleId = reference.getModuleIdentifier();
        Location referenceLocation = reference.getLocation();
        Identifier id = reference.getId();
        if (id == null) {
            return null;
        }
        Assignment temporalAssignment = null;
        if (moduleId == null) {
            if ("anytype".equals(id.getTtcnName())) {
                return this.anytypeDefinition;
            }
            Assignment tempResult = null;
            for (ImportModule impMod : this.importedModules) {
                if (impMod.getReferredModule() == null) continue;
                ModuleImportationChain referenceChain = new ModuleImportationChain("Circular reference chain: `{0}''", false);
                tempResult = impMod.importAssignment(timestamp, referenceChain, this.identifier, reference, new ArrayList<ModuleImportation>());
                if (tempResult != null && !tempResult.getMyScope().getModuleScope().isVisible(timestamp, this.getIdentifier(), tempResult)) {
                    tempResult = null;
                }
                if (tempResult == null) continue;
                if (temporalAssignment == null) {
                    temporalAssignment = tempResult;
                    continue;
                }
                if (temporalAssignment == tempResult) continue;
                reference.getLocation().reportSemanticError("It is not possible to resolve this reference unambigously, as  it can be resolved to `" + temporalAssignment.getFullName() + "' and to `" + tempResult.getFullName() + "'");
                return null;
            }
            if (temporalAssignment != null) {
                return temporalAssignment;
            }
            List<ISubReference> subReferences = reference.getSubreferences();
            if (subReferences.size() > 0 && subReferences.get(0) instanceof ParameterisedSubReference) {
                Referenced_Value value;
                IType governor;
                boolean isReferenced = false;
                StringBuilder propCode = new StringBuilder();
                propCode.append("\n\tfunction ");
                propCode.append(reference.getDisplayName().substring(0, reference.getDisplayName().length() - 1));
                ParameterisedSubReference subref = (ParameterisedSubReference)subReferences.get(0);
                ParsedActualParameters parsed = subref.getParsedParameters();
                TemplateInstances instances = parsed.getInstances();
                for (int i = 0; i < instances.getNofTis(); ++i) {
                    TemplateInstance inst = instances.getInstanceByIndex(i);
                    if (i > 0) {
                        propCode.append(", ");
                    }
                    propCode.append(Type.typeToSrcType(inst.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE)));
                    propCode.append(" param" + (i + 1));
                }
                propCode.append(")");
                IType.Type_type valueType = null;
                if (reference.getNameParent() instanceof Referenced_Value && (governor = (value = (Referenced_Value)reference.getNameParent()).getMyGovernor()) != null) {
                    valueType = value.getMyGovernor().getTypetype();
                    propCode.append(" return ");
                    propCode.append(Type.typeToSrcType(valueType));
                    propCode.append(' ');
                    isReferenced = true;
                }
                propCode.append("{\n\t\t// function body\n");
                if (isReferenced) {
                    propCode.append("\n\t\treturn ");
                    propCode.append(Type.typeToSrcTypeDefault(valueType));
                    propCode.append(";\n");
                }
                propCode.append("\t}\n\n");
                ArrayList<1> proposals = new ArrayList<1>();
                HoverProposal prop = new HoverProposal("Insert missing function prototype as a module function...", "IMG_OBJ_ADD"){

                    @Override
                    public void run(IMarker marker) {
                        this.insertTextAtDefs(-1);
                    }
                };
                prop.addProposal(-1, propCode.toString());
                proposals.add(prop);
                HoverProposal[] propArray = proposals.toArray(new HoverProposal[proposals.size()]);
                referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), this.identifier.getDisplayName()), propArray);
                this.missingReferences.add(reference);
                return temporalAssignment;
            }
            referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), this.identifier.getDisplayName()));
            this.missingReferences.add(reference);
        } else if (moduleId.getName().equals(this.name)) {
            if ("anytype".equals(id.getTtcnName())) {
                return this.anytypeDefinition;
            }
            temporalAssignment = this.definitions.getLocalAssignmentByID(timestamp, id);
            if (temporalAssignment == null) {
                referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), this.identifier.getDisplayName()));
            }
        } else {
            for (ImportModule impMod : this.importedModules) {
                if (!moduleId.getName().equals(impMod.getName())) continue;
                if (impMod.getReferredModule() == null) {
                    return temporalAssignment;
                }
                ModuleImportationChain referenceChain = new ModuleImportationChain("Circular reference chain: `{0}''", false);
                temporalAssignment = impMod.importAssignment(timestamp, referenceChain, this.identifier, reference, new ArrayList<ModuleImportation>());
                if (!impMod.getReferredModule().isVisible(timestamp, this.getIdentifier(), temporalAssignment)) {
                    temporalAssignment = null;
                }
                if (temporalAssignment == null) {
                    referenceLocation.reportSemanticError(MessageFormat.format(MISSINGREFERENCE, id.getDisplayName(), impMod.getIdentifier().getDisplayName()));
                }
                return temporalAssignment;
            }
            this.missingReferences.add(reference);
        }
        return temporalAssignment;
    }

    public List<Reference> getMissingReferences() {
        return this.missingReferences;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("module: ").append(this.name);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        Identifier moduleId = propCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null) continue;
                importedModule.addProposal(propCollector, this.identifier);
            }
        } else if (this.identifier != null && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addProposal(propCollector, 0);
            }
        } else {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null || !importedModule.getName().equals(moduleId.getName())) continue;
                importedModule.addProposal(propCollector, this.identifier);
            }
        }
        super.addProposal(propCollector);
    }

    @Override
    public void addSkeletonProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.MODULE_LEVEL_SKELETON_PROPOSALS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
    }

    @Override
    public void addKeywordProposal(ProposalCollector propCollector) {
        propCollector.addProposal(TTCN3Keywords.MODULE_SCOPE, null, "keyword");
        propCollector.addProposal(TTCN3Keywords.GENERALLY_USABLE, null, "keyword");
        super.addKeywordProposal(propCollector);
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector) {
        Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (subrefs.size() == 1 && this.identifier != null && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(this.name, this.identifier.getLocation(), this);
            }
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null) continue;
                importedModule.addDeclaration(declarationCollector, this.identifier);
            }
        } else if (this.identifier != null && moduleId.getName().equals(this.identifier.getName())) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
            }
        } else {
            for (ImportModule importedModule : this.importedModules) {
                if (importedModule == null || !importedModule.getName().equals(moduleId.getName())) continue;
                importedModule.addDeclaration(declarationCollector, this.identifier);
            }
        }
        super.addDeclaration(declarationCollector);
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void addDeclarationWithoutImportLookup(DeclarationCollector declarationCollector) {
        Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
        if (moduleId == null) {
            for (int i = 0; i < this.definitions.getNofAssignments(); ++i) {
                this.definitions.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
            }
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (subrefs.size() == 1 && this.identifier != null && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(this.name, this.identifier.getLocation(), this);
            }
        }
    }

    @Override
    public void extractStructuralInformation(ProjectStructureDataCollector collector) {
        for (ImportModule imported : this.importedModules) {
            collector.addImportation(this.identifier, imported.getIdentifier());
        }
    }

    private int reparseAfterModule(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparser_optionalWithStatementContext root = parser.pr_reparser_optionalWithStatement();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                MultipleWithAttributes attributes = root.attributes;
                Ttcn3Reparser.Pr_EndOfFileContext rootEof = parser.pr_EndOfFile();
                ParserUtilities.logParseTree((ParseTree)rootEof, parser);
                if (parser.isErrorListEmpty()) {
                    TTCN3Module.this.withAttributesPath = new WithAttributesPath();
                    TTCN3Module.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        TTCN3Module.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    private int reparseInsideAttributelist(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                Ttcn3Reparser.Pr_reparser_optionalWithStatementContext root = parser.pr_reparser_optionalWithStatement();
                ParserUtilities.logParseTree((ParseTree)root, parser);
                MultipleWithAttributes attributes = root.attributes;
                Ttcn3Reparser.Pr_EndOfFileContext rootEof = parser.pr_EndOfFile();
                ParserUtilities.logParseTree((ParseTree)rootEof, parser);
                if (parser.isErrorListEmpty()) {
                    TTCN3Module.this.withAttributesPath.setWithAttributes(attributes);
                    TTCN3Module.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                }
            }
        });
    }

    public void updateSyntax(TTCN3ReparseUpdater reparser, ProjectSourceParser sourceParser) throws ReParseException {
        this.needsTobeBuilt = true;
        if (reparser.getShift() < 0) {
            throw new ReParseException();
        }
        if (reparser.getDamageEnd() < this.location.getOffset()) {
            reparser.updateLocation(this.identifier.getLocation());
            if (this.definitions != null) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
            }
            if (this.controlpart != null) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            return;
        }
        if (reparser.getDamageStart() > this.location.getEndOffset()) {
            if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
                reparser.extendDamagedRegionTillFileEnd();
                int result = this.reparseAfterModule(reparser);
                if (result != 0) {
                    throw new ReParseException();
                }
            }
            return;
        }
        Location temporalIdentifier = this.identifier.getLocation();
        if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
            reparser.extendDamagedRegion(temporalIdentifier);
            IdentifierReparser r = new IdentifierReparser(reparser);
            int result = r.parse();
            this.identifier = r.getIdentifier();
            if (result != 0) {
                throw new ReParseException(result);
            }
            if (this.definitions != null) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
            }
            if (this.controlpart != null) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            if (this.withAttributesPath != null) {
                this.withAttributesPath.updateSyntax(reparser, false);
                reparser.updateLocation(this.withAttributesPath.getLocation());
            }
            return;
        }
        if (reparser.isDamaged(temporalIdentifier)) {
            throw new ReParseException();
        }
        boolean enveloped = false;
        if (this.definitions != null && reparser.envelopsDamage(this.definitions.getLocation()) || this.controlpart != null && reparser.envelopsDamage(this.controlpart.getLocation())) {
            if (this.definitions != null && reparser.isAffected(this.definitions.getLocation())) {
                this.definitions.updateSyntax(reparser, this.importedModules, this.friendModules, this.controlpart);
                reparser.updateLocation(this.definitions.getLocation());
            }
            if (this.controlpart != null && reparser.isAffected(this.controlpart.getLocation())) {
                this.controlpart.updateSyntax(reparser);
                reparser.updateLocation(this.controlpart.getLocation());
            }
            enveloped = true;
        }
        if (this.withAttributesPath != null && reparser.isAffected(this.withAttributesPath.getLocation())) {
            if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                int result = this.reparseInsideAttributelist(reparser);
                if (result != 0) {
                    throw new ReParseException();
                }
                return;
            }
            if (enveloped) {
                this.withAttributesPath.updateSyntax(reparser, reparser.envelopsDamage(this.withAttributesPath.getLocation()));
                reparser.updateLocation(this.withAttributesPath.getLocation());
            } else {
                throw new ReParseException();
            }
        }
        if (!enveloped) {
            throw new ReParseException();
        }
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.definitions == null) {
            return null;
        }
        return this.definitions.getEnclosingAssignment(offset);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.definitions != null) {
            this.definitions.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.controlpart != null) {
            this.controlpart.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.anytypeDefinition != null) {
            this.anytypeDefinition.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.importedModules != null) {
            for (ImportModule im : this.importedModules) {
                if (im.accept(v)) continue;
                return false;
            }
        }
        if (this.friendModules != null) {
            for (FriendModule fm : this.friendModules) {
                if (fm.accept(v)) continue;
                return false;
            }
        }
        if (this.definitions != null && !this.definitions.accept(v)) {
            return false;
        }
        if (this.controlpart != null && !this.controlpart.accept(v)) {
            return false;
        }
        if (this.anytypeDefinition != null && !this.anytypeDefinition.accept(v)) {
            return false;
        }
        return this.withAttributesPath == null || this.withAttributesPath.accept(v);
    }

    public void setIncludedFiles(Set<IFile> includedFiles) {
        this.includedFiles = includedFiles;
    }

    public Set<IFile> getIncludedFiles() {
        return this.includedFiles;
    }

    public void setInactiveCodeLocations(List<Location> inactiveCodeLocations) {
        this.inactiveCodeLocations = inactiveCodeLocations;
    }

    public List<Location> getInactiveCodeLocations() {
        return this.inactiveCodeLocations;
    }

    @Override
    public boolean shouldBeGenerated() {
        return this.needsTobeBuilt;
    }

    @Override
    public void generateCode(JavaGenData aData) {
        this.needsTobeBuilt = false;
        aData.addBuiltinTypeImport("TTCN_Module");
        for (ImportModule importModule : this.importedModules) {
            importModule.generateCode(aData);
        }
        aData.getClassHeader().append(MessageFormat.format("public final class {0} extends TTCN_Module '{'\n", this.name));
        if (this.definitions != null) {
            this.definitions.generateCode(aData);
        }
        StringBuilder constructor = aData.getConstructor();
        constructor.append(MessageFormat.format("\tpublic {0}() '{'\n", this.identifier.getName()));
        constructor.append(MessageFormat.format("\t\tsuper(\"{0}\", module_type_enum.TTCN3_MODULE", this.identifier.getDisplayName()));
        if (this.digest == null) {
            constructor.append(", null");
        } else {
            constructor.append(", new byte[] {");
            for (int i = 0; i < this.digest.length; ++i) {
                if (i > 0) {
                    constructor.append(", ");
                }
                constructor.append("(byte)").append(String.format("0x%02X", this.digest[i] & 0xFF));
            }
            constructor.append('}');
        }
        constructor.append(");\n");
        constructor.append("\t}\n\n");
        if (this.anytypeDefinition != null) {
            this.anytypeDefinition.generateCode(aData, false);
        }
        if (this.controlpart != null) {
            this.controlpart.generateCode(aData);
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("module").addText(" ").addStyledText(this.identifier.getDisplayName(), 1);
        this.hoverContent.closeHeader();
        if (this.hasDocumentComment()) {
            DocumentComment dc = this.parseDocumentComment();
            dc.addDescsContent(this.hoverContent);
            dc.addVerdictsContent(this.hoverContent);
            dc.addRequirementsContent(this.hoverContent);
            dc.addPurposeContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(ind).append("@author").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

