/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Single_ValueRedirection
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private final Reference variableReference;
    private final ArrayList<ISubReference> subreferences;
    private final boolean decoded;
    private final Value encodingString;
    private IType declarationType;
    private Location location = NULL_Location.INSTANCE;

    public Single_ValueRedirection(Reference variableReference) {
        this.variableReference = variableReference;
        this.subreferences = null;
        this.decoded = false;
        this.encodingString = null;
        this.declarationType = null;
        if (variableReference != null) {
            variableReference.setFullNameParent(this);
        }
    }

    public Single_ValueRedirection(Reference variableReference, ArrayList<ISubReference> subreferences, boolean decoded, Value encodingString) {
        this.variableReference = variableReference;
        this.subreferences = subreferences;
        this.decoded = decoded;
        this.encodingString = encodingString;
        this.declarationType = null;
        if (variableReference != null) {
            variableReference.setFullNameParent(this);
        }
        if (subreferences != null) {
            for (ISubReference subreference : subreferences) {
                subreference.setFullNameParent(this);
            }
        }
        if (encodingString != null) {
            encodingString.setFullNameParent(this);
        }
    }

    public Reference getVariableReference() {
        return this.variableReference;
    }

    public ArrayList<ISubReference> getSubreferences() {
        return this.subreferences;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public Value getStringEncoding() {
        return this.encodingString;
    }

    public void setDeclarationType(IType declarationType) {
        this.declarationType = declarationType;
    }

    public IType getDeclarationType() {
        return this.declarationType;
    }

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.variableReference == child) {
            return builder.append(".varref");
        }
        if (this.encodingString == child) {
            return builder.append(".<string_encoding>");
        }
        if (this.subreferences != null) {
            for (int i = 0; i < this.subreferences.size(); ++i) {
                ISubReference subReference = this.subreferences.get(i);
                if (subReference != child) continue;
                return builder.append(".fieldrefs.").append(i + 1);
            }
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.variableReference.setMyScope(scope);
        if (this.subreferences != null) {
            for (ISubReference subreference : this.subreferences) {
                subreference.setMyScope(scope);
            }
        }
        if (this.encodingString != null) {
            this.encodingString.setMyScope(scope);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.variableReference != null) {
            this.variableReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.variableReference.getLocation());
        }
        if (this.subreferences != null) {
            for (ISubReference subreference : this.subreferences) {
                if (subreference == null) continue;
                subreference.updateSyntax(reparser, false);
                reparser.updateLocation(subreference.getLocation());
            }
        }
        if (this.encodingString != null) {
            this.encodingString.updateSyntax(reparser, false);
            reparser.updateLocation(this.encodingString.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.variableReference != null && !this.variableReference.accept(v)) {
            return false;
        }
        if (this.subreferences != null) {
            for (ISubReference subreference : this.subreferences) {
                if (subreference == null || subreference.accept(v)) continue;
                return false;
            }
        }
        if (this.encodingString != null && !this.encodingString.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

