/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.math.BigInteger;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;

public final class IntegerLimit
extends LimitType {
    public static final IntegerLimit MAXIMUM = new IntegerLimit(ValueType.PLUS_INFINITY);
    public static final IntegerLimit MINIMUM = new IntegerLimit(ValueType.MINUS_INFINITY);
    private final ValueType valueType;
    private final BigInteger value;

    public IntegerLimit(BigInteger value) {
        this.valueType = ValueType.NUMBER;
        this.value = value;
    }

    public IntegerLimit(ValueType valueType) {
        this.valueType = valueType;
        this.value = BigInteger.ZERO;
    }

    @Override
    public LimitType.Type getType() {
        return LimitType.Type.INTEGER;
    }

    @Override
    public LimitType decrement() {
        return this.valueType == ValueType.NUMBER ? new IntegerLimit(this.value.subtract(BigInteger.ONE)) : this;
    }

    @Override
    public LimitType increment() {
        return this.valueType == ValueType.NUMBER ? new IntegerLimit(this.value.add(BigInteger.ONE)) : this;
    }

    @Override
    public boolean isAdjacent(LimitType other) {
        IntegerLimit il = (IntegerLimit)other;
        return this.valueType == ValueType.NUMBER && il.valueType == ValueType.NUMBER && this.value.add(BigInteger.ONE).equals(il.value);
    }

    @Override
    public void toString(StringBuilder sb) {
        switch (this.valueType) {
            case MINUS_INFINITY: {
                sb.append("-infinity");
                break;
            }
            case PLUS_INFINITY: {
                sb.append("infinity");
                break;
            }
            default: {
                sb.append(this.value.toString());
            }
        }
    }

    @Override
    public int compareTo(LimitType other) {
        IntegerLimit il = (IntegerLimit)other;
        switch (this.valueType) {
            case MINUS_INFINITY: {
                return il.valueType == ValueType.MINUS_INFINITY ? 0 : -1;
            }
            case PLUS_INFINITY: {
                return il.valueType == ValueType.PLUS_INFINITY ? 0 : 1;
            }
        }
        switch (il.valueType) {
            case MINUS_INFINITY: {
                return 1;
            }
            case PLUS_INFINITY: {
                return -1;
            }
        }
        return this.value.compareTo(il.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerLimit)) {
            return false;
        }
        IntegerLimit other = (IntegerLimit)obj;
        return this.valueType == other.valueType && this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static enum ValueType {
        MINUS_INFINITY,
        NUMBER,
        PLUS_INFINITY;

    }
}

