/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RealLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class RealRangeListConstraint
extends SubtypeConstraint {
    private final boolean hasNan;
    private final RangeListConstraint rlc;

    public RealRangeListConstraint() {
        this.hasNan = false;
        this.rlc = new RangeListConstraint(LimitType.Type.REAL);
    }

    public RealRangeListConstraint(Double d) {
        if (Double.isNaN(d)) {
            this.hasNan = true;
            this.rlc = new RangeListConstraint(LimitType.Type.REAL);
            return;
        }
        this.hasNan = false;
        this.rlc = new RangeListConstraint(new RealLimit(d));
    }

    public RealRangeListConstraint(RealLimit rlBegin, RealLimit rlEnd) {
        this.hasNan = false;
        this.rlc = new RangeListConstraint(rlBegin, rlEnd);
    }

    private RealRangeListConstraint(boolean hasNan, RangeListConstraint rlc) {
        this.hasNan = hasNan;
        this.rlc = rlc;
    }

    @Override
    public RealRangeListConstraint complement() {
        return new RealRangeListConstraint(!this.hasNan, this.rlc.complement());
    }

    @Override
    public RealRangeListConstraint intersection(SubtypeConstraint other) {
        RealRangeListConstraint o = (RealRangeListConstraint)other;
        return new RealRangeListConstraint(this.hasNan && o.hasNan, this.rlc.intersection(o.rlc));
    }

    @Override
    public boolean isElement(Object o) {
        Double d = (Double)o;
        if (d.isNaN()) {
            return this.hasNan;
        }
        return this.rlc.isElement(new RealLimit(d));
    }

    @Override
    public TernaryBool isEmpty() {
        return this.rlc.isEmpty().and(TernaryBool.fromBool(!this.hasNan));
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        RealRangeListConstraint o = (RealRangeListConstraint)other;
        return this.rlc.isEqual(o.rlc).and(TernaryBool.fromBool(this.hasNan == o.hasNan));
    }

    @Override
    public TernaryBool isFull() {
        return this.rlc.isFull().and(TernaryBool.fromBool(this.hasNan));
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        this.rlc.toString(sb, false);
        if (this.hasNan) {
            if (this.rlc.isEmpty() != TernaryBool.TTRUE) {
                sb.append(", ");
            }
            sb.append("NaN");
        }
        sb.append(')');
    }

    @Override
    public RealRangeListConstraint union(SubtypeConstraint other) {
        RealRangeListConstraint o = (RealRangeListConstraint)other;
        return new RealRangeListConstraint(this.hasNan || o.hasNan, this.rlc.union(o.rlc));
    }
}

