/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Code;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ComponentCreateExpression
extends Expression_Value {
    private static final String FIRSTOPERANDERROR = "The first operand of operation `create()' should be a charstring value";
    private static final String SECONDOPERANDERROR = "The second operand of operation `create()' should be a charstring value";
    private static final String COMPONENTEXPECTED = "Operation `create'' should refer to a component type instead of {0}";
    private static final String TYPEMISMATCH1 = "Type mismatch: reference to a component type was expected in operation `create'' instead of `{0}''";
    private static final String TYPEMISMATCH2 = "Incompatible component type: operation `create'' should refer to `{0}'' instead of `{1}''";
    private static final String OPERATIONNAME = "create()";
    private final Reference componentReference;
    private final Value name;
    private final Value location;
    private final boolean isAlive;
    private CompilationTimeStamp checkCreateTimestamp;
    private Component_Type checkCreateCache;

    public ComponentCreateExpression(Reference componentReference, Value name, Value location, boolean isAlive) {
        this.componentReference = componentReference;
        this.name = name;
        this.location = location;
        this.isAlive = isAlive;
        if (componentReference != null) {
            componentReference.setFullNameParent(this);
        }
        if (name != null) {
            name.setFullNameParent(this);
        }
        if (location != null) {
            location.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.COMPONENT_CREATE_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public String createStringRepresentation() {
        if (this.componentReference == null) {
            return "<erroneous value>";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.componentReference.getDisplayName());
        builder.append(".create");
        if (this.name != null || this.location != null) {
            builder.append('(');
            if (this.name != null) {
                builder.append(this.name.createStringRepresentation());
            } else {
                builder.append('-');
            }
            if (this.location != null) {
                builder.append(", ");
                builder.append(this.location.createStringRepresentation());
            }
            builder.append(')');
        }
        if (this.isAlive) {
            builder.append(" alive");
        }
        return null;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
        if (this.name != null) {
            this.name.setMyScope(scope);
        }
        if (this.location != null) {
            this.location.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.componentReference != null) {
            this.componentReference.setCodeSection(codeSection);
        }
        if (this.name != null) {
            this.name.setCodeSection(codeSection);
        }
        if (this.location != null) {
            this.location.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(".<operand1>");
        }
        if (this.name == child) {
            return builder.append(".<operand2>");
        }
        if (this.location == child) {
            return builder.append(".<operand3>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_COMPONENT;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    @Override
    public Type getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return this.checkCreate(timestamp);
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IType.Type_type typeType;
        IValue last;
        this.checkCreate(timestamp);
        if (this.name != null) {
            last = this.name.setLoweridToReference(timestamp);
            typeType = last.getExpressionReturntype(timestamp, expectedValue);
            if (!last.getIsErroneous(timestamp)) {
                switch (typeType) {
                    case TYPE_CHARSTRING: {
                        last.getValueRefdLast(timestamp, referenceChain);
                        break;
                    }
                    case TYPE_UNDEFINED: {
                        break;
                    }
                    default: {
                        this.name.getLocation().reportSemanticError(FIRSTOPERANDERROR);
                        this.setIsErroneous(true);
                    }
                }
            }
        }
        if (this.location != null) {
            last = this.location.setLoweridToReference(timestamp);
            typeType = last.getExpressionReturntype(timestamp, expectedValue);
            if (!last.getIsErroneous(timestamp)) {
                switch (typeType) {
                    case TYPE_CHARSTRING: {
                        last.getValueRefdLast(timestamp, referenceChain);
                        break;
                    }
                    case TYPE_UNDEFINED: {
                        break;
                    }
                    default: {
                        this.name.getLocation().reportSemanticError(SECONDOPERANDERROR);
                        this.setIsErroneous(true);
                    }
                }
            }
        }
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, false, true, false);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.componentReference == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    private Component_Type checkCreate(CompilationTimeStamp timestamp) {
        IType last;
        if (this.checkCreateTimestamp != null && !this.checkCreateTimestamp.isLess(timestamp)) {
            return this.checkCreateCache;
        }
        this.checkCreateTimestamp = timestamp;
        this.checkCreateCache = null;
        Assignment assignment = this.componentReference.getRefdAssignment(timestamp, true);
        if (assignment == null) {
            this.setIsErroneous(true);
            return null;
        }
        if (!Assignment.Assignment_type.A_TYPE.semanticallyEquals(assignment.getAssignmentType())) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(COMPONENTEXPECTED, assignment.getDescription()));
            this.setIsErroneous(true);
            return null;
        }
        IType type = ((Def_Type)assignment).getType(timestamp).getFieldType(timestamp, this.componentReference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (type == null) {
            this.setIsErroneous(true);
            return null;
        }
        if (!IType.Type_type.TYPE_COMPONENT.equals((Object)type.getTypetype())) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH1, type.getTypename()));
            this.setIsErroneous(true);
            return null;
        }
        if (this.myGovernor != null && IType.Type_type.TYPE_COMPONENT.equals((Object)(last = this.myGovernor.getTypeRefdLast(timestamp)).getTypetype()) && !last.isCompatible(timestamp, type, null, null, null)) {
            this.componentReference.getLocation().reportSemanticError(MessageFormat.format(TYPEMISMATCH2, last.getTypename(), type.getTypename()));
            this.setIsErroneous(true);
            return null;
        }
        this.checkCreateCache = (Component_Type)type;
        return this.checkCreateCache;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference != null) {
            this.componentReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference.getLocation());
        }
        if (this.name != null) {
            this.name.updateSyntax(reparser, false);
            reparser.updateLocation(this.name.getLocation());
        }
        if (this.location != null) {
            this.location.updateSyntax(reparser, false);
            reparser.updateLocation(this.location.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference != null) {
            this.componentReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.name != null) {
            this.name.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.location != null) {
            this.location.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference != null && !this.componentReference.accept(v)) {
            return false;
        }
        if (this.name != null && !this.name.accept(v)) {
            return false;
        }
        return this.location == null || this.location.accept(v);
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return !(this.name != null && !this.name.canGenerateSingleExpression() || this.location != null && !this.location.canGenerateSingleExpression());
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        String temp;
        IValue last;
        ReferenceChain referenceChain;
        aData.addCommonLibraryImport("TTCN_Runtime");
        expression.expression.append("TTCN_Runtime.create_component(");
        Assignment assignment = this.componentReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (assignment == null || !Assignment.Assignment_type.A_TYPE.equals((Object)assignment.getAssignmentType())) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for expression `" + this.getFullName() + "''"));
            return;
        }
        IType componentType = assignment.getType(CompilationTimeStamp.getBaseTimestamp()).getFieldType(CompilationTimeStamp.getBaseTimestamp(), this.componentReference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
        if (componentType == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for expression `" + this.getFullName() + "''"));
            return;
        }
        if (!IType.Type_type.TYPE_COMPONENT.equals((Object)(componentType = componentType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())).getTypetype())) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for expression `" + this.getFullName() + "''"));
            return;
        }
        ((Component_Type)componentType).getComponentBody().generateCodeComponentTypeName(expression);
        expression.expression.append(", ");
        if (this.name != null) {
            referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            last = this.name.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
            referenceChain.release();
            if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)last.getValuetype())) {
                temp = ((Charstring_Value)last).getValue();
                expression.expression.append('\"');
                expression.expression.append(Code.translate_string(temp));
                expression.expression.append('\"');
            } else if (this.name.returnsNative()) {
                this.name.generateCodeExpressionMandatory(aData, expression, false);
            } else {
                this.name.generateCodeExpressionMandatory(aData, expression, true);
                expression.expression.append(".get_value().toString()");
            }
        } else {
            expression.expression.append("null");
        }
        expression.expression.append(", ");
        if (this.location != null) {
            referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            last = this.location.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
            referenceChain.release();
            if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)last.getValuetype())) {
                temp = ((Charstring_Value)last).getValue();
                expression.expression.append('\"');
                expression.expression.append(Code.translate_string(temp));
                expression.expression.append('\"');
            } else if (this.location.returnsNative()) {
                this.location.generateCodeExpressionMandatory(aData, expression, false);
            } else {
                this.location.generateCodeExpressionMandatory(aData, expression, true);
                expression.expression.append(".get_value().toString()");
            }
        } else {
            expression.expression.append("null");
        }
        expression.expression.append(MessageFormat.format(", {0})", this.isAlive ? "true" : "false"));
    }
}

