/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class NowExpression
extends Expression_Value {
    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.NOW_OPERATION;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public String createStringRepresentation() {
        return "now";
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        StatementBlock statementBlock = this.myScope.getStatementBlockScope();
        if (statementBlock == null || statementBlock.getMyDefinition() == null) {
            this.location.reportSemanticError("Operation `now' can only be used in testcases, functions or altsteps");
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        expression.expression.append("TTCN_Runtime.now()");
    }
}

