/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.asn1editor.PairMatcher;

public final class ASN1DoubleClickStrategy
implements ITextDoubleClickStrategy {
    private ITextViewer fText;

    public final void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        this.fText = part;
        if (this.fText.getDocument().getLength() < pos) {
            return;
        }
        if (pos < 0) {
            return;
        }
        PairMatcher pairMatcher = new PairMatcher();
        IRegion region = pairMatcher.match(this.fText.getDocument(), pos);
        if (region != null) {
            this.fText.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
            return;
        }
        this.selectWord(pos);
    }

    protected void selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            int endPos;
            char c;
            int startPos;
            for (startPos = caretPos; startPos >= 0 && ((c = doc.getChar(startPos)) == '_' || c == '-' || Character.isLetterOrDigit(c)); --startPos) {
            }
            int length = doc.getLength();
            for (endPos = caretPos; endPos < length && ((c = doc.getChar(endPos)) == '_' || c == '-' || Character.isLetterOrDigit(c)); ++endPos) {
            }
            this.fText.setSelectedRange(startPos + 1, endPos - startPos - 1);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

