/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.configeditor.CodeScanner;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public final class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final String KEYWORD = "keyword";
    private static final String REFERENCE_SPLITTER = "\\.";
    private final AbstractDecoratedTextEditor editor;

    public ContentAssistProcessor(AbstractDecoratedTextEditor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        int ofs = this.findWordStart(offset, doc);
        String incompleteString = "";
        try {
            if (doc != null && offset >= ofs) {
                incompleteString = doc.get(ofs, offset - ofs);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        String[] reference = incompleteString.trim().split(REFERENCE_SPLITTER, -1);
        Reference ref = new Reference(null);
        ref.setLocation(new Location((IResource)file, 0, 0, offset - ofs));
        FieldSubReference subref = new FieldSubReference(new Identifier(Identifier.Identifier_type.ID_TTCN, reference[0]));
        subref.setLocation(new Location((IResource)file, 0, 0, reference[0].length()));
        ref.addSubReference(subref);
        if (reference.length > 1) {
            subref = new FieldSubReference(new Identifier(Identifier.Identifier_type.ID_TTCN, reference[1]));
            subref.setLocation(new Location((IResource)file, 0, reference[0].length() + 1, offset - ofs));
            ref.addSubReference(subref);
        }
        ProposalCollector propCollector = new ProposalCollector(Identifier.Identifier_type.ID_TTCN, doc, ref, ofs);
        propCollector.addProposal(CodeScanner.SECTION_TITLES, null, KEYWORD);
        propCollector.addProposal(CodeScanner.KEYWORDS, null, KEYWORD);
        propCollector.addProposal(CodeScanner.MASK_OPTIONS, null, KEYWORD);
        propCollector.addProposal(CodeScanner.EXTERNAL_COMMAND_TYPES, null, KEYWORD);
        propCollector.addProposal(CodeScanner.OPTIONS, null, KEYWORD);
        String sortingpolicy = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.proposalSorting");
        if ("alphabetically".equals(sortingpolicy)) {
            propCollector.sortAll();
        }
        return propCollector.getCompletitions();
    }

    private boolean isSeparatingChar(char c) {
        switch (c) {
            case ')': 
            case '.': 
            case ']': 
            case '_': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private int findWordStart(int offset, IDocument document) {
        int ofs = offset - 1;
        if (-1 == ofs) {
            return 0;
        }
        try {
            char currentChar = document.getChar(ofs);
            while (ofs > 0 && (Character.isLetterOrDigit(currentChar) || this.isSeparatingChar(currentChar))) {
                currentChar = document.getChar(--ofs);
            }
            if (ofs != 0) {
                ++ofs;
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return ofs;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new ContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[0];
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

