/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchContentProvider;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchMatch;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReferenceSearchResultView
extends AbstractTextSearchViewPage {
    private ReferenceSearchContentProvider contentProvider;

    public ReferenceSearchResultView() {
        super(2);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.getViewer().refresh();
        }
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new ReferenceSearchContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ReferenceSearchLabelProvider());
        viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    Object selectedElement = ((TreeSelection)event.getSelection()).getFirstElement();
                    if (selectedElement instanceof ReferenceSearchMatch) {
                        ReferenceSearchMatch match = (ReferenceSearchMatch)((Object)selectedElement);
                        ReferenceSearchResultView.this.showMatch(match, match.getOffset(), match.getLength(), false);
                        return;
                    }
                }
                catch (PartInitException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        });
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
        if (!(match instanceof ReferenceSearchMatch)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection != null && !selection.toList().contains(match)) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)match));
        }
        IFile file = (IFile)match.getElement();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (desc == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId(), false);
        if (part != null && part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            textEditor.selectAndReveal(currentOffset, currentLength);
        }
    }

    private static Color getLineNumberColor() {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), ColorManager.getColorTheme() == ColorManager.Theme.Light ? new RGB(51, 56, 152) : new RGB(238, 137, 133));
    }

    private static class ReferenceSearchLabelProvider
    extends StyledCellLabelProvider {
        private static final String ICON_MATCH = "match.gif";
        private final Image matchIcon;
        private List<StyleRange> ranges = new ArrayList<StyleRange>();

        public ReferenceSearchLabelProvider() {
            this.matchIcon = ImageCache.getImage(ICON_MATCH);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IResource) {
                cell.setText(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getText(element));
            } else if (element instanceof ReferenceSearchMatch) {
                ReferenceSearchMatch refSearchMatch = (ReferenceSearchMatch)((Object)element);
                Location location = refSearchMatch.getId().getLocation();
                Integer line = location.getLine();
                Path path = Path.of(location.getFile().getLocation().toOSString(), new String[0]);
                try {
                    String codeText = Files.readAllLines(path).get(line - 1).stripLeading();
                    cell.setText(line + ":   " + codeText);
                    StyleRange lineRange = new StyleRange(0, line.toString().length(), ReferenceSearchResultView.getLineNumberColor(), null);
                    this.ranges.add(lineRange);
                }
                catch (IOException iOException) {}
            } else {
                cell.setText("Unexpected element");
            }
            if (element instanceof Match) {
                cell.setImage(this.matchIcon);
            }
            cell.setImage(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage(element));
            cell.setStyleRanges(this.ranges.toArray(new StyleRange[0]));
        }
    }
}

