/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HtmlTagDetectionRule
implements IPredicateRule {
    private final IToken token;

    public HtmlTagDetectionRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int count = 0;
        int c = scanner.read();
        if (c != 60) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        ++count;
        do {
            c = scanner.read();
            ++count;
            if (c == -1) break;
            if (c != 62) continue;
            return this.token;
        } while (c != 60);
        for (int i = 0; i < count; ++i) {
            scanner.unread();
        }
        return Token.UNDEFINED;
    }
}

