/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.actions.OpenDeclarationHelper;
import org.eclipse.titan.designer.editors.actions.OpenDeclarationLabelProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3ReferenceParser;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public final class AddImport
implements IEditorActionDelegate {
    public static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified";
    public static final String NOTTTCN3DECLARATION = "Current text selection does not resolve to a TTCN3 declaration";
    public static final String TTCN3EDITORNOTFOUND = "The TTCN3 editor could not be found";
    private IEditorPart targetEditor = null;
    private ISelection selection = TextSelection.emptySelection();

    public void run(IAction action) {
        int offset;
        TITANDebugConsole.println("Add import called: ");
        if (this.targetEditor == null || !(this.targetEditor instanceof TTCN3Editor)) {
            return;
        }
        this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(FILENOTIDENTIFIABLE);
            return;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return;
        }
        IPreferencesService prefs = Platform.getPreferencesService();
        boolean reportDebugInformation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (!this.selection.isEmpty() && this.selection instanceof TextSelection && !"".equals(((TextSelection)this.selection).getText())) {
            if (reportDebugInformation) {
                TITANDebugConsole.println("text selected: " + ((TextSelection)this.selection).getText());
            }
            TextSelection tSelection = (TextSelection)this.selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((TTCN3Editor)this.targetEditor).getCarretOffset();
        }
        DeclarationCollector declarationCollector = OpenDeclarationHelper.findVisibleDeclarations(this.targetEditor, new TTCN3ReferenceParser(false), ((TTCN3Editor)this.targetEditor).getDocument(), offset, false);
        if (declarationCollector == null) {
            return;
        }
        List<DeclarationCollectionHelper> collected = declarationCollector.getCollected();
        if (collected.isEmpty()) {
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
            if (reportDebugInformation) {
                TITANDebugConsole.println("No visible elements found");
            }
            for (String moduleName2 : projectSourceParser.getKnownModuleNames()) {
                Module module2 = projectSourceParser.getModuleByName(moduleName2);
                if (module2 == null) continue;
                Assignments assignments = module2.getAssignments();
                for (int i = 0; i < assignments.getNofAssignments(); ++i) {
                    assignments.getAssignmentByIndex(i).addDeclaration(declarationCollector, 0);
                }
            }
            if (declarationCollector.getCollectionSize() == 0) {
                this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(NOTTTCN3DECLARATION);
                return;
            }
            if (reportDebugInformation) {
                TITANDebugConsole.println("Elements were only found in not visible modules");
            }
            DeclarationCollectionHelper resultToInsert = null;
            if (collected.size() == 1) {
                resultToInsert = collected.get(0);
            } else {
                OpenDeclarationLabelProvider labelProvider = new OpenDeclarationLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
                dialog.setTitle("Add Import");
                dialog.setMessage("Choose element to generate an import statement for.");
                dialog.setElements(collected.toArray());
                if (dialog.open() == 0) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("Selected: " + dialog.getFirstResult());
                    }
                    resultToInsert = (DeclarationCollectionHelper)dialog.getFirstResult();
                }
            }
            if (resultToInsert == null) {
                return;
            }
            IFile newfile = (IFile)resultToInsert.location.getFile();
            Module newModule = projectSourceParser.containedModule(newfile);
            if (newModule == null) {
                this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("Could not identify the module in file " + newfile.getName());
                return;
            }
            String ttcnName = newModule.getIdentifier().getTtcnName();
            TITANDebugConsole.println("the new module to insert: " + ttcnName);
            IFile actualFile = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
            Module actualModule = projectSourceParser.containedModule(actualFile);
            int insertionOffset = ((TTCN3Module)actualModule).getAssignmentsScope().getLocation().getOffset() + 1;
            MultiTextEdit multiEdit = new MultiTextEdit(insertionOffset, 0);
            RewriteSessionEditProcessor processor = new RewriteSessionEditProcessor(((TTCN3Editor)this.targetEditor).getDocument(), (TextEdit)multiEdit, 3);
            multiEdit.addChild((TextEdit)new InsertEdit(insertionOffset, "\nimport from " + ttcnName + " all;\n"));
            try {
                processor.performEdits();
            }
            catch (BadLocationException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        } else if (reportDebugInformation) {
            for (DeclarationCollectionHelper foundDeclaration : collected) {
                TITANDebugConsole.println("declaration:" + foundDeclaration.location.getFile() + ": " + foundDeclaration.location.getOffset() + " - " + foundDeclaration.location.getEndOffset() + " is available");
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)"Study feature", (String)"Adding a missing importation is still under study");
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }
}

