/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.utils.SelectionUtils;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.utils.Analyzer;
import org.eclipse.titanium.markers.utils.AnalyzerCache;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CheckCodeSmells
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage iwPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = iwPage.getSelection();
        List res = SelectionUtils.getResourcesFromSelection((ISelection)selection);
        ArrayList<IProject> projects = new ArrayList<IProject>();
        this.collectResourcesToBeAnalyzed(new LinkedList<IResource>(res), projects);
        String titaniumId = "org.eclipse.titanium";
        String onTheFlyPref = "CODE_SMELL.ON_THE_FLY_SMELLS";
        boolean onTheFlyEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.titanium", "CODE_SMELL.ON_THE_FLY_SMELLS", false, null);
        Analyzer analyzer = AnalyzerCache.withPreference();
        this.checkProjects(projects, onTheFlyEnabled, analyzer);
        return null;
    }

    private void collectResourcesToBeAnalyzed(Deque<IResource> res, List<IProject> projects) {
        while (!res.isEmpty()) {
            IResource resource = res.pollFirst();
            if (!(resource instanceof IProject)) continue;
            IProject project = (IProject)resource;
            projects.add(project);
        }
    }

    private void checkProjects(List<IProject> projects, final boolean onTheFlyEnabled, final Analyzer analyzer) {
        for (final IProject project : projects) {
            new ProjectAnalyzerJob("Check " + project.getName() + " for code smells"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (!onTheFlyEnabled) {
                        MarkerHandler handler;
                        IProject iProject = project;
                        synchronized (iProject) {
                            handler = analyzer.analyzeProject((IProgressMonitor)progress.newChild(100), project);
                        }
                        handler.showAll(project);
                    }
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
        }
    }
}

