/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.preferences.RiskMethod;
import org.eclipse.titanium.preferences.PreferenceConstants;

public final class PreferenceManager {
    private static IPreferenceStore store = null;

    private PreferenceManager() {
    }

    public static synchronized IPreferenceStore getStore() {
        if (store == null) {
            store = Activator.getDefault().getPreferenceStore();
        }
        return store;
    }

    public static boolean getEnabled(IMetricEnum metric, boolean def) {
        String name = PreferenceConstants.nameMetricEnabled(metric.id());
        if (def) {
            return PreferenceManager.getStore().getDefaultBoolean(name);
        }
        return PreferenceManager.getStore().getBoolean(name);
    }

    public static RiskMethod getRiskMethod(IMetricEnum metric, boolean def) {
        String name = PreferenceConstants.nameMetricRisk(metric.id());
        if (def) {
            return RiskMethod.myMethod(PreferenceManager.getStore().getDefaultInt(name));
        }
        return RiskMethod.myMethod(PreferenceManager.getStore().getInt(name));
    }

    public static Number[] getLimits(IMetricEnum metric, boolean def) {
        String name = PreferenceConstants.nameMetricLimits(metric.id());
        switch (PreferenceManager.getRiskMethod(metric, def)) {
            case NEVER: {
                return null;
            }
            case NO_LOW: 
            case NO_HIGH: {
                double d = Double.parseDouble(def ? PreferenceManager.getStore().getDefaultString(name) : PreferenceManager.getStore().getString(name));
                Double n = metric.isInteger() ? (double)Integer.valueOf((int)Math.round(d)).intValue() : new Double(d);
                return new Number[]{n};
            }
            case NO_LOW_HIGH: {
                String[] parts = (def ? PreferenceManager.getStore().getDefaultString(name) : PreferenceManager.getStore().getString(name)).split(";");
                Number[] ret = new Number[2];
                for (int i = 0; i < 2; ++i) {
                    double d = Double.parseDouble(parts[i]);
                    ret[i] = metric.isInteger() ? (double)Integer.valueOf((int)Math.round(d)).intValue() : new Double(d);
                }
                return ret;
            }
        }
        return null;
    }

    public static void storeRisk(IMetricEnum metric, RiskMethod method, Number[] limits) {
        PreferenceManager.getStore().setValue(PreferenceConstants.nameMetricRisk(metric.id()), method.ordinal());
        String name = PreferenceConstants.nameMetricLimits(metric.id());
        switch (method) {
            case NEVER: {
                break;
            }
            case NO_LOW: 
            case NO_HIGH: {
                PreferenceManager.getStore().setValue(name, limits[0].toString());
                break;
            }
            case NO_LOW_HIGH: {
                PreferenceManager.getStore().setValue(name, limits[0].toString() + ";" + limits[1].toString());
            }
        }
    }

    public static boolean isEnabledOnModuleGraph(IMetricEnum metric) {
        return PreferenceManager.getStore().getBoolean(PreferenceConstants.nameMetricGraph(metric.id()));
    }

    public static boolean isEnabledOnView(IMetricEnum metric) {
        return PreferenceManager.getStore().getBoolean(PreferenceConstants.nameMetricEnabled(metric.id()));
    }
}

