/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.log.viewer.actions.OpenTextTableProjectsViewMenuAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class LogFileActionProvider
extends CommonActionProvider {
    private OpenTextTableProjectsViewMenuAction openLogFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;

    public void init(ICommonActionExtensionSite site) {
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)site.getViewSite();
            this.openLogFileAction = new OpenTextTableProjectsViewMenuAction();
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IFile) {
            this.openLogFileAction.selectionChanged(null, (ISelection)selection);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.getContext().getSelection().isEmpty()) {
            return;
        }
        super.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.openLogFileAction.selectionChanged(null, (ISelection)selection);
        if (this.openLogFileAction.isEnabled()) {
            // empty if block
        }
        this.addOpenWithMenu(menu);
    }

    private void addOpenWithMenu(IMenuManager aMenu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection == null || selection.size() != 1 || !(selection.getFirstElement() instanceof IFile)) {
            return;
        }
        IFile file = (IFile)selection.getFirstElement();
        MenuManager submenu = new MenuManager("Open with", "group.openWith");
        submenu.add((IContributionItem)new GroupMarker("group.top"));
        submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), (IAdaptable)file));
        submenu.add((IContributionItem)new GroupMarker("additions"));
        if (submenu.getItems().length > 2 && submenu.isEnabled()) {
            aMenu.appendToGroup("group.openWith", (IContributionItem)submenu);
        }
    }
}

