/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.logging;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.logging.ContextLoggingRefactoring;
import org.eclipse.titanium.refactoring.logging.ContextLoggingWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public final class ContextLoggingActionFromEditor
extends AbstractHandler {
    private static final String ERR_MSG_NO_SELECTION = "Empty selection! ";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ContextLoggingRefactoring refactoring;
        Utils.updateASTForProjectActiveInEditor("ContextLogging");
        Activator.getDefault().pauseHandlingResourceChanges();
        TTCN3Editor targetEditor = Utils.getActiveEditor();
        if (targetEditor == null) {
            return null;
        }
        IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
        IFile selectedFile = Utils.getSelectedFileInEditor("MinimizeVisibility");
        if (selectedFile == null) {
            return null;
        }
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection sel = selectionService.getSelection();
        if (sel == null) {
            ContextLoggingActionFromEditor.setStatusLineMsg(ERR_MSG_NO_SELECTION, statusLineManager);
            return null;
        }
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"ContextLoggingActionFromEditor: selection is not a TextSelection");
            return null;
        }
        TextSelection selection = (TextSelection)sel;
        if (selection.getLength() == 0) {
            StructuredSelection ssel = new StructuredSelection(new Object[]{selectedFile});
            refactoring = new ContextLoggingRefactoring((IStructuredSelection)ssel, null);
        } else {
            refactoring = new ContextLoggingRefactoring(selectedFile, (ITextSelection)selection, null);
        }
        ContextLoggingWizard wiz = new ContextLoggingWizard(refactoring);
        RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wiz);
        try {
            operation.run(targetEditor.getEditorSite().getShell(), "");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            ErrorReporter.logError((String)"ContextLoggingActionFromEditor: Error while performing refactoring change! ");
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        IProject project = selectedFile.getProject();
        GlobalParser.getProjectSourceParser((IProject)project).reportOutdating(selectedFile);
        GlobalParser.getProjectSourceParser((IProject)project).analyzeAll();
        return null;
    }

    private static void setStatusLineMsg(final String msg, final IStatusLineManager toSet) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                toSet.setErrorMessage(msg);
            }
        });
    }
}

