/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.engine;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.ValidationSet;
import org.eclipse.cbi.p2repo.aggregator.engine.Builder;
import org.eclipse.cbi.p2repo.aggregator.engine.BuilderPhase;
import org.eclipse.cbi.p2repo.aggregator.util.ResourceUtils;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.cbi.p2repo.util.MonitorUtils;
import org.eclipse.cbi.p2repo.util.TimeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

public class MetadataMirrorGenerator
extends BuilderPhase {
    private ValidationSet validationSet;

    public MetadataMirrorGenerator(Builder builder, ValidationSet validationSet) {
        super(builder);
        this.validationSet = validationSet;
    }

    private void mirror(List<IInstallableUnit> iusToMirror, MetadataRepository source, IMetadataRepository dest) throws CoreException {
        dest.addInstallableUnits(iusToMirror);
        Builder builder = this.getBuilder();
        if (source == null || !builder.isMirrorReferences()) {
            return;
        }
        ArrayList<RepositoryReference> refs = new ArrayList<RepositoryReference>();
        for (IRepositoryReference ref : source.getReferences()) {
            String refType;
            URI location = ref.getLocation();
            String refKey = location.toString();
            String string = refType = ref.getType() == 0 ? "meta-data" : "artifacts";
            if (!builder.isMatchedReference(refKey)) {
                LogUtils.debug((String)"- %s reference %s was ruled out by inclusion/exclusion patterns", (Object[])new Object[]{refType, refKey});
                continue;
            }
            if (refKey.endsWith("/site.xml")) {
                location = URI.create(refKey.substring(0, refKey.length() - 8));
            }
            LogUtils.debug((String)"- mirroring %s reference %s", (Object[])new Object[]{refType, refKey});
            refs.add(new RepositoryReference(location, ref.getNickname(), ref.getType(), 0));
        }
        dest.addReferences(refs);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        boolean artifactErrors;
        long start;
        block13: {
            Builder builder = this.getBuilder();
            final Set<IInstallableUnit> unitsToAggregate = builder.getUnitsToAggregate(this.validationSet);
            if (unitsToAggregate.isEmpty()) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return;
            }
            String taskLabel = Builder.getValidationSetLabel(this.validationSet);
            LogUtils.info((String)("Starting mirroring of meta-data for validationSet: " + taskLabel), (Object[])new Object[0]);
            start = TimeUtils.getNow();
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
            artifactErrors = false;
            try {
                try {
                    subMon.setTaskName("Mirroring meta-data for validationSet: " + taskLabel + "...");
                    MonitorUtils.subTask((IProgressMonitor)subMon, (String)"Initializing");
                    MonitorUtils.worked((IProgressMonitor)subMon, (int)5);
                    final IMetadataRepository targetMdr = builder.getAggregationMetadataRepository();
                    MonitorUtils.worked((IProgressMonitor)subMon, (int)10);
                    IStatus status = targetMdr.executeBatch(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, OperationCanceledException {
                            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor);
                            try {
                                try {
                                    EList contribs = MetadataMirrorGenerator.this.validationSet.getAllContributions();
                                    MonitorUtils.begin((IProgressMonitor)subMon, (int)(contribs.size() * 100 + 20));
                                    for (Contribution contrib : contribs) {
                                        SubMonitor contribMonitor = subMon.newChild(100);
                                        EList repos = contrib.getRepositories(true);
                                        MonitorUtils.begin((IProgressMonitor)contribMonitor, (int)(repos.size() * 100));
                                        for (MappedRepository repo : repos) {
                                            MetadataRepository mdr = ResourceUtils.getMetadataRepository((MetadataRepositoryReference)repo);
                                            ArrayList<IInstallableUnit> iusToMirror = null;
                                            for (IInstallableUnit iu : mdr.getInstallableUnits()) {
                                                if (!unitsToAggregate.contains(iu)) continue;
                                                if (iusToMirror == null) {
                                                    iusToMirror = new ArrayList<IInstallableUnit>();
                                                }
                                                iusToMirror.add(iu);
                                            }
                                            if (iusToMirror != null) {
                                                String msg = String.format("Mirroring meta-data consisting of %d units from %s", iusToMirror.size(), mdr.getLocation());
                                                LogUtils.info((String)msg, (Object[])new Object[0]);
                                                MetadataMirrorGenerator.this.mirror(iusToMirror, mdr, targetMdr);
                                            }
                                            MonitorUtils.worked((IProgressMonitor)contribMonitor, (int)100);
                                        }
                                        MonitorUtils.done((IProgressMonitor)contribMonitor);
                                    }
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    LogUtils.info((String)"Operation canceled.", (Object[])new Object[0]);
                                    MonitorUtils.done((IProgressMonitor)monitor);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                MonitorUtils.done((IProgressMonitor)monitor);
                            }
                        }
                    }, (IProgressMonitor)subMon.newChild(900, 6));
                    if (status.getSeverity() == 8) {
                        throw new OperationCanceledException();
                    }
                    if (status.getSeverity() == 4) {
                        Throwable t = status.getException();
                        if (t instanceof InvocationTargetException) {
                            t = ((InvocationTargetException)t).getTargetException();
                        }
                        if (t instanceof CoreException) {
                            throw (CoreException)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new RuntimeException(t);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    LogUtils.info((String)"Operation canceled.", (Object[])new Object[0]);
                    MonitorUtils.done((IProgressMonitor)monitor);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                MonitorUtils.done((IProgressMonitor)monitor);
                throw throwable;
            }
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        if (!monitor.isCanceled()) {
            LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
        }
        if (artifactErrors) {
            throw ExceptionUtils.fromMessage((String)"Not all artifacts could be mirrored, see log for details", (Object[])new Object[0]);
        }
    }
}

