/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.tests;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.cbi.p2repo.util.Trivial;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.repository.IRepository;
import org.junit.Assert;

public class RepositoryTests<T> {
    protected IProgressMonitor monitor = new NullProgressMonitor();

    public static URI getTestData(String fileName) throws Exception {
        File file;
        URI testDataURI = URI.create("platform:/plugin/org.eclipse.cbi.p2repo.p2.tests/testData/" + fileName);
        URL resolved = FileLocator.resolve((URL)testDataURI.toURL());
        if (!"file".equalsIgnoreCase(resolved.getProtocol())) {
            Assert.fail((String)("Unable to resolve URL" + testDataURI));
        }
        if (!(file = new File(testDataURI = resolved.toURI())).canRead()) {
            Assert.fail((String)("File does not exist: " + file.getAbsolutePath()));
        }
        return testDataURI;
    }

    private static void assertFieldEquals(String field, Object a, Object b) {
        if (!Trivial.equalsAllowNull((Object)a, (Object)b)) {
            Assert.fail((String)("Repository " + field + " differs"));
        }
    }

    public void assertEquals(IRepository<T> a, IRepository<T> b) {
        RepositoryTests.assertFieldEquals("name", a.getName(), b.getName());
        RepositoryTests.assertFieldEquals("location", a.getLocation(), b.getLocation());
        RepositoryTests.assertFieldEquals("description", a.getDescription(), b.getDescription());
        RepositoryTests.assertFieldEquals("provider", a.getProvider(), b.getProvider());
        RepositoryTests.assertFieldEquals("type", a.getType(), b.getType());
        RepositoryTests.assertFieldEquals("version", a.getVersion(), b.getVersion());
        RepositoryTests.assertFieldEquals("properties", a.getProperties(), b.getProperties());
    }
}

