/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Composite parent;
    Cursor cursor;
    long lastCursor;
    long window;
    long overlay;
    boolean tracking;
    boolean cancelled;
    boolean grabbed;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        Point point = this.display.mapInPixels(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int[] state = new int[1];
        this.gdk_window_get_device_position(this.window, actualX, actualY, state);
        return new Point(actualX[0], actualY[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.mapInPixels(this.parent, null, newX, newY);
        this.display.setCursorLocation(point);
        int[] actualX = new int[1];
        int[] actualY = new int[1];
        int[] state = new int[1];
        this.gdk_window_get_device_position(this.window, actualX, actualY, state);
        return new Point(actualX[0], actualY[0]);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects) {
        long window = OS.gdk_get_default_root_window();
        if (this.parent != null) {
            window = this.gtk_widget_get_window(this.parent.paintHandle());
        }
        if (window == 0L) {
            return;
        }
        if (OS.GTK3) {
            if (this.overlay == 0L) {
                return;
            }
            OS.gtk_widget_shape_combine_region(this.overlay, 0L);
            long region = OS.gdk_region_new();
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < rects.length) {
                Rectangle r = this.parent != null ? this.display.mapInPixels(this.parent, null, rects[i]) : rects[i];
                rect.x = r.x;
                rect.y = r.y;
                rect.width = r.width + 1;
                rect.height = 1;
                OS.gdk_region_union_with_rect(region, rect);
                rect.width = 1;
                rect.height = r.height + 1;
                OS.gdk_region_union_with_rect(region, rect);
                rect.x = r.x + r.width;
                OS.gdk_region_union_with_rect(region, rect);
                rect.x = r.x;
                rect.y = r.y + r.height;
                rect.width = r.width + 1;
                rect.height = 1;
                OS.gdk_region_union_with_rect(region, rect);
                ++i;
            }
            OS.gtk_widget_shape_combine_region(this.overlay, region);
            OS.gdk_region_destroy(region);
            long overlayWindow = OS.gtk_widget_get_window(this.overlay);
            OS.gdk_window_hide(overlayWindow);
            OS.gdk_window_show(overlayWindow);
            return;
        }
        long gc = OS.gdk_gc_new(window);
        if (gc == 0L) {
            return;
        }
        long colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white(colormap, color);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_subwindow(gc, 1L);
        OS.gdk_gc_set_function(gc, 2L);
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            int x = rect.x;
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                x = this.parent.getClientWidth() - rect.width - x;
            }
            OS.gdk_draw_rectangle(window, gc, 0, x, rect.y, rect.width, rect.height);
            ++i;
        }
        OS.g_object_unref(gc);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = DPIUtil.autoScaleDown(new Rectangle(current.x, current.y, current.width, current.height));
            ++i;
        }
        return result;
    }

    Rectangle[] getRectanglesInPixels() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    boolean grab() {
        long cursor = this.cursor != null ? this.cursor.handle : 0L;
        int result = this.gdk_pointer_grab(this.window, 0, false, 516, 0L, cursor, 0);
        return result == 0;
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        return this.gtk_mouse(7, widget, event);
    }

    @Override
    long gtk_key_press_event(long widget, long eventPtr) {
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, eventPtr, (long)GdkEventKey.sizeof);
        int stepSize = (keyEvent.state & 4) != 0 ? 1 : 9;
        int xChange = 0;
        int yChange = 0;
        switch (keyEvent.keyval) {
            case 65307: {
                this.cancelled = true;
            }
            case 65293: {
                this.tracking = false;
                break;
            }
            case 65361: {
                xChange = -stepSize;
                break;
            }
            case 65363: {
                xChange = stepSize;
                break;
            }
            case 65362: {
                yChange = -stepSize;
                break;
            }
            case 65364: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            Rectangle eventRect = new Rectangle(this.oldX + xChange, this.oldY + yChange, 0, 0);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth()) - event.width - event.x;
            }
            if ((this.style & 0x10) != 0) {
                Point cursorPos;
                this.resizeRectangles(xChange, yChange);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectsToErase);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
                if ((cursorPos = this.adjustResizeCursor()) != null) {
                    this.oldX = cursorPos.x;
                    this.oldY = cursorPos.y;
                }
            } else {
                Point cursorPos;
                this.moveRectangles(xChange, yChange);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    this.drawRectangles(rectsToErase);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((cursorPos = this.adjustMoveCursor()) != null) {
                    this.oldX = cursorPos.x;
                    this.oldY = cursorPos.y;
                }
            }
        }
        return result;
    }

    @Override
    long gtk_motion_notify_event(long widget, long eventPtr) {
        long cursor;
        long l = cursor = this.cursor != null ? this.cursor.handle : 0L;
        if (cursor != this.lastCursor) {
            this.ungrab();
            this.grabbed = this.grab();
            this.lastCursor = cursor;
        }
        return this.gtk_mouse(3, widget, eventPtr);
    }

    long gtk_mouse(int eventType, long widget, long eventPtr) {
        int[] newX = new int[1];
        int[] newY = new int[1];
        this.gdk_window_get_device_position(this.window, newX, newY, null);
        if (this.oldX != newX[0] || this.oldY != newY[0]) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            if (this.parent == null) {
                Rectangle eventRect = new Rectangle(newX[0], newY[0], 0, 0);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
            } else {
                Point screenCoord = this.display.mapInPixels(this.parent, null, newX[0], newY[0]);
                Rectangle eventRect = new Rectangle(screenCoord.x, screenCoord.y, 0, 0);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
            }
            if ((this.style & 0x10) != 0) {
                Point cursorPos;
                this.resizeRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectsToErase);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
                if ((cursorPos = this.adjustResizeCursor()) != null) {
                    newX[0] = cursorPos.x;
                    newY[0] = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX[0] - this.oldX, newY[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i3 = 0;
                        while (i3 < length) {
                            if (!this.rectangles[i3].equals(rectsToErase[i3])) {
                                draw = true;
                                break;
                            }
                            ++i3;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectsToErase);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
            }
            this.oldX = newX[0];
            this.oldY = newY[0];
        }
        this.tracking = eventType != 7;
        return 0L;
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            xChange *= -1;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        int mask;
        boolean mouseDown;
        int hStyle;
        this.checkWidget();
        this.window = OS.gdk_get_default_root_window();
        if (this.parent != null) {
            this.window = this.gtk_widget_get_window(this.parent.paintHandle());
        }
        if (this.window == 0L) {
            return false;
        }
        this.cancelled = false;
        this.tracking = true;
        if (!OS.GTK3) {
            this.update();
            this.drawRectangles(this.rectangles);
        }
        int[] oldX = new int[1];
        int[] oldY = new int[1];
        int[] state = new int[1];
        this.gdk_window_get_device_position(this.window, oldX, oldY, state);
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean bl = mouseDown = (state[0] & (mask = 1792)) != 0;
        if (!mouseDown) {
            Point cursorPos = null;
            cursorPos = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            if (cursorPos != null) {
                oldX[0] = cursorPos.x;
                oldY[0] = cursorPos.y;
            }
        }
        this.oldX = oldX[0];
        this.oldY = oldY[0];
        this.grabbed = this.grab();
        long l = this.lastCursor = this.cursor != null ? this.cursor.handle : 0L;
        if (OS.GTK3) {
            this.overlay = OS.gtk_window_new(1);
            OS.gtk_window_set_skip_taskbar_hint(this.overlay, true);
            OS.gtk_window_set_title(this.overlay, new byte[1]);
            OS.gtk_widget_realize(this.overlay);
            long overlayWindow = OS.gtk_widget_get_window(this.overlay);
            OS.gdk_window_set_override_redirect(overlayWindow, true);
            if (OS.GTK_VERSION < OS.VERSION(3, 16, 0)) {
                OS.gtk_widget_override_background_color(this.overlay, 0, new GdkRGBA());
            } else {
                String name = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "window" : "GtkWindow";
                String css = String.valueOf(name) + " {background-color: rgb(0,0,0);}";
                long provider = 0L;
                long context = OS.gtk_widget_get_style_context(this.overlay);
                if (provider == 0L) {
                    provider = OS.gtk_css_provider_new();
                    OS.gtk_style_context_add_provider(context, provider, 600);
                    OS.g_object_unref(provider);
                }
                OS.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(null, css, true), -1L, null);
            }
            long region = OS.gdk_region_new();
            OS.gtk_widget_shape_combine_region(this.overlay, region);
            OS.gtk_widget_input_shape_combine_region(this.overlay, region);
            OS.gdk_region_destroy(region);
            Rectangle bounds = this.display.getBoundsInPixels();
            OS.gtk_window_move(this.overlay, bounds.x, bounds.y);
            OS.gtk_window_resize(this.overlay, bounds.width, bounds.height);
            OS.gtk_widget_show(this.overlay);
        }
        Display display = this.display;
        Tracker oldTracker = display.tracker;
        display.tracker = this;
        try {
            while (this.tracking) {
                if (this.parent != null && this.parent.isDisposed()) {
                    break;
                }
                display.runSkin();
                display.runDeferredLayouts();
                display.sendPreExternalEventDispatchEvent();
                OS.gdk_threads_leave();
                OS.g_main_context_iteration(0L, true);
                display.sendPostExternalEventDispatchEvent();
                display.runAsyncMessages(false);
            }
        }
        finally {
            display.tracker = oldTracker;
        }
        if (!this.isDisposed() && !OS.GTK3) {
            this.update();
            this.drawRectangles(this.rectangles);
        }
        this.ungrab();
        if (this.overlay != 0L) {
            OS.gtk_widget_destroy(this.overlay);
            this.overlay = 0L;
        }
        this.window = 0L;
        return !this.cancelled;
    }

    boolean processEvent(long eventPtr) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEvent.sizeof);
        long widget = OS.gtk_get_event_widget(eventPtr);
        switch (gdkEvent.type) {
            case 3: {
                this.gtk_motion_notify_event(widget, eventPtr);
                break;
            }
            case 7: {
                this.gtk_button_release_event(widget, eventPtr);
                break;
            }
            case 8: {
                this.gtk_key_press_event(widget, eventPtr);
                break;
            }
            case 9: {
                this.gtk_key_release_event(widget, eventPtr);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                this.update();
                if (!OS.GTK3) {
                    this.drawRectangles(this.rectangles);
                }
                OS.gtk_main_do_event(eventPtr);
                if (OS.GTK3) break;
                this.drawRectangles(this.rectangles);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            xChange *= -1;
        }
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.cursor = newCursor;
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        int i = 0;
        while (i < length) {
            rectangles[i] = DPIUtil.autoScaleUp(rectangles[i]);
            ++i;
        }
        this.setRectanglesInPixels(rectangles);
    }

    void setRectanglesInPixels(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }

    void ungrab() {
        if (this.grabbed) {
            this.gdk_pointer_ungrab(this.window, 0);
        }
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

