/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IByteConverter;
import org.eclipse.dstore.core.model.IByteStreamHandler;
import org.eclipse.dstore.core.server.SecuredThread;

public class ByteStreamHandler
implements IByteStreamHandler {
    protected DataStore _dataStore;
    protected DataElement _log;
    protected static final String FILEMSG_REMOTE_SAVE_FAILED = "RSEF5006";
    private boolean _doBackups = true;
    private boolean _keepBackups = false;

    public ByteStreamHandler(DataStore dataStore, DataElement log) {
        this._dataStore = dataStore;
        this._log = log;
        String doBackups = System.getProperty("backupfiles");
        boolean bl = this._doBackups = doBackups == null || doBackups.equals("true");
        if (this._doBackups) {
            String keepBackups = System.getProperty("keepbackupfiles");
            this._keepBackups = keepBackups != null && keepBackups.equals("true");
        }
    }

    public String getId() {
        return this.getClass().getName();
    }

    private void deleteBackupFile(File currentFile, File backupFile) {
        if (backupFile != null && !this._keepBackups) {
            DeleteBackupThread thread = new DeleteBackupThread(this._dataStore, currentFile, backupFile);
            thread.start();
        }
    }

    private void backupFile(File file, File backupFile) {
        FileInputStream inputStream = null;
        FileOutputStream backupFileStream = null;
        try {
            try {
                inputStream = new FileInputStream(file);
                backupFileStream = new FileOutputStream(backupFile);
                byte[] buffer = new byte[512000];
                long totalSize = file.length();
                int totalRead = 0;
                while ((long)totalRead < totalSize) {
                    int available = inputStream.available();
                    available = available < 512000 ? available : 512000;
                    int bytesRead = inputStream.read(buffer, 0, available);
                    if (bytesRead == -1) {
                        break;
                    }
                    backupFileStream.write(buffer, 0, bytesRead);
                    totalRead += bytesRead;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    inputStream.close();
                    backupFileStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                try {
                    inputStream.close();
                    backupFileStream.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                inputStream.close();
                backupFileStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void receiveBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        remotePath = new String(remotePath.replace('\\', '/'));
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            this._dataStore.trace("Receiving Bytes for " + fileName);
            try {
                File file = new File(fileName);
                File backupFile = null;
                File parent = new File(file.getParent());
                if (!file.exists()) {
                    parent.mkdirs();
                } else if (!this._dataStore.isVirtual() && this._doBackups) {
                    String n = file.getName();
                    backupFile = new File(parent, String.valueOf('.') + n + '~');
                    this._dataStore.trace("Backing up as " + backupFile.getAbsolutePath());
                    this.backupFile(file, backupFile);
                }
                File newFile = new File(fileName);
                FileOutputStream fileStream = new FileOutputStream(newFile);
                if (binary) {
                    fileStream.write(buffer, 0, size);
                } else {
                    IByteConverter byteConverter = this._dataStore.getByteConverter();
                    byteConverter.setContext(file);
                    byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                    fileStream.write(convertedBytes, 0, convertedBytes.length);
                }
                fileStream.close();
                this.deleteBackupFile(newFile, backupFile);
                if (status == null) {
                    return;
                }
                status.setAttribute(4, "success");
                this._dataStore.refresh(status.getParent());
            }
            catch (IOException e) {
                this._dataStore.trace(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
            catch (Exception e) {
                this._dataStore.trace(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }

    public void receiveAppendedBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        remotePath = new String(remotePath.replace('\\', '/'));
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            this._dataStore.trace("Receiving Appended Bytes for " + fileName);
            try {
                File file = new File(fileName);
                File parent = new File(file.getParent());
                if (!file.exists()) {
                    parent.mkdirs();
                    File newFile = new File(fileName);
                    FileOutputStream fileStream = new FileOutputStream(newFile);
                    if (binary) {
                        fileStream.write(buffer, 0, size);
                    } else {
                        IByteConverter byteConverter = this._dataStore.getByteConverter();
                        byteConverter.setContext(file);
                        byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                        fileStream.write(convertedBytes, 0, convertedBytes.length);
                    }
                    fileStream.close();
                } else {
                    FileOutputStream outStream = new FileOutputStream(fileName, true);
                    if (binary) {
                        outStream.write(buffer, 0, size);
                    } else {
                        IByteConverter byteConverter = this._dataStore.getByteConverter();
                        byteConverter.setContext(file);
                        byte[] convertedBytes = byteConverter.convertClientBytesToHostBytes(buffer, 0, size);
                        outStream.write(convertedBytes, 0, convertedBytes.length);
                    }
                    outStream.close();
                }
                if (status == null) {
                    return;
                }
                status.setAttribute(4, "success");
                this._dataStore.refresh(status.getParent());
            }
            catch (IOException e) {
                this._dataStore.trace(e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, FILEMSG_REMOTE_SAVE_FAILED);
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }

    protected void internalSendBytes(String path, byte[] bytes, int size, boolean binary) {
        if (this._dataStore.isVirtual()) {
            this._dataStore.replaceFile(path, bytes, size, binary);
        } else {
            this._dataStore.updateFile(path, bytes, size, binary);
        }
    }

    protected void internalSendAppendBytes(String path, byte[] bytes, int size, boolean binary) {
        if (this._dataStore.isVirtual()) {
            this._dataStore.replaceAppendFile(path, bytes, size, binary);
        } else {
            this._dataStore.updateAppendFile(path, bytes, size, binary);
        }
    }

    protected DataElement findStatusFor(String remotePath) {
        if (this._log != null) {
            int i = 0;
            while (i < this._log.getNestedSize()) {
                DataElement child = this._log.get(i);
                if (child.getName().equals(remotePath)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    class DeleteBackupThread
    extends SecuredThread {
        private File _currentFile;
        private File _backupFile;
        private long _initialLength;

        public DeleteBackupThread(DataStore dataStore, File currentFile, File backupFile) {
            super(dataStore);
            this._currentFile = currentFile;
            this._backupFile = backupFile;
            this._initialLength = this._currentFile.length();
        }

        public void run() {
            super.run();
            boolean doneDelete = false;
            while (!doneDelete) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this._dataStore.isConnected()) {
                    doneDelete = true;
                    continue;
                }
                long curLength = this._currentFile.length();
                if (curLength == this._initialLength) {
                    this._backupFile.delete();
                    doneDelete = true;
                    continue;
                }
                this._initialLength = curLength;
            }
        }
    }
}

